/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsForceShownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsUtilEx {
    @Nullable
    static FileViewProvider findViewProvider(VirtualFile file2, Project project) {
        if (file2 == null || file2.isDirectory()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findViewProvider(file2);
    }

    @Nullable
    static BreadcrumbsProvider findProvider(@NotNull Editor editor, VirtualFile file2) {
        Project project;
        if (editor == null) {
            BreadcrumbsUtilEx.$$$reportNull$$$0(0);
        }
        return (project = editor.getProject()) == null ? null : BreadcrumbsUtilEx.findProvider(editor, BreadcrumbsUtilEx.findViewProvider(file2, project));
    }

    @Nullable
    public static BreadcrumbsProvider findProvider(@NotNull Editor editor, @Nullable FileViewProvider viewProvider) {
        if (editor == null) {
            BreadcrumbsUtilEx.$$$reportNull$$$0(1);
        }
        if (viewProvider == null) {
            return null;
        }
        Boolean forceShown = BreadcrumbsForceShownSettings.getForcedShown(editor);
        if (forceShown == null) {
            return BreadcrumbsUtilEx.findProvider(true, viewProvider);
        }
        return forceShown != false ? BreadcrumbsUtilEx.findProvider(false, viewProvider) : null;
    }

    @Nullable
    public static BreadcrumbsProvider findProvider(boolean checkSettings, @NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            BreadcrumbsUtilEx.$$$reportNull$$$0(2);
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (checkSettings && !settings.isBreadcrumbsShown()) {
            return null;
        }
        Language baseLang = viewProvider.getBaseLanguage();
        if (checkSettings && !settings.isBreadcrumbsShownFor(baseLang.getID())) {
            return null;
        }
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)baseLang);
        if (provider == null) {
            for (Language language : viewProvider.getLanguages()) {
                if (checkSettings && !settings.isBreadcrumbsShownFor(language.getID()) || (provider = BreadcrumbsUtil.getInfoProvider((Language)language)) == null) continue;
                break;
            }
        }
        return provider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "viewProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsUtilEx";
        objectArray[2] = "findProvider";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

