/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.SwingUtilities;

public class WrappedFlowLayout
extends FlowLayout {
    public WrappedFlowLayout(int hGap, int vGap) {
        super(3, hGap, vGap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target2) {
        Dimension baseSize = super.preferredLayoutSize(target2);
        if (this.getAlignOnBaseline()) {
            return baseSize;
        }
        return this.getWrappedSize(target2);
    }

    public Dimension getWrappedSize(Container target2) {
        Container parent = SwingUtilities.getUnwrappedParent(target2);
        int maxWidth = parent.getWidth() - (parent.getInsets().left + parent.getInsets().right);
        return this.getDimension(target2, maxWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getDimension(Container target2, int maxWidth) {
        Insets insets = target2.getInsets();
        int height = insets.top + insets.bottom;
        int width = insets.left + insets.right;
        int rowHeight = 0;
        int rowWidth = insets.left + insets.right;
        boolean isVisible = false;
        boolean start2 = true;
        Object object = target2.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < target2.getComponentCount(); ++i) {
                Component component = target2.getComponent(i);
                if (!component.isVisible()) continue;
                isVisible = true;
                Dimension size = component.getPreferredSize();
                if (rowWidth + this.getHgap() + size.width > maxWidth && !start2) {
                    height += this.getVgap() + rowHeight;
                    width = Math.max(width, rowWidth);
                    rowWidth = insets.left + insets.right;
                    rowHeight = 0;
                }
                rowWidth += this.getHgap() + size.width;
                rowHeight = Math.max(rowHeight, size.height);
                start2 = false;
            }
            height += this.getVgap() + rowHeight;
            width = Math.max(width, rowWidth);
            if (!isVisible) {
                return super.preferredLayoutSize(target2);
            }
            return new Dimension(width, height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target2) {
        if (this.getAlignOnBaseline()) {
            return super.minimumLayoutSize(target2);
        }
        return this.getWrappedSize(target2);
    }
}

