/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.accessibility.AccessibleContext;

class A11YFix {
    private static Class cAccessBridge;
    private static Field fAccessBridge;
    private static Method mFocusGained;
    private static boolean initialized;
    private static final boolean ENABLED;

    A11YFix() {
    }

    public static void invokeFocusGained(Window closingWindow) {
        Object bridge;
        Window focusedWindow;
        Component focusOwner;
        if (!ENABLED || !ScreenReader.isActive()) {
            return;
        }
        IdeFocusManager manager = IdeFocusManager.findInstanceByComponent((Component)closingWindow);
        if (manager != null && (focusOwner = manager.getFocusOwner()) != null && (focusedWindow = UIUtil.getWindow((Component)focusOwner)) != closingWindow && (bridge = A11YFix.getAccessBridge()) != null) {
            FocusEvent fe = new FocusEvent(focusOwner, 1004);
            try {
                mFocusGained.invoke(bridge, fe, focusOwner.getAccessibleContext());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static boolean checkInit() {
        if (initialized) {
            return fAccessBridge != null && mFocusGained != null;
        }
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            cAccessBridge = cl.loadClass("com.sun.java.accessibility.AccessBridge");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cAccessBridge != null && (fAccessBridge = ReflectionUtil.getDeclaredField((Class)cAccessBridge, (String)"theAccessBridge")) != null) {
            fAccessBridge.setAccessible(true);
            mFocusGained = ReflectionUtil.getDeclaredMethod((Class)cAccessBridge, (String)"focusGained", (Class[])new Class[]{FocusEvent.class, AccessibleContext.class});
            if (mFocusGained != null) {
                mFocusGained.setAccessible(true);
            }
        }
        initialized = true;
        return fAccessBridge != null && mFocusGained != null;
    }

    private static Object getAccessBridge() {
        if (!A11YFix.checkInit()) {
            return null;
        }
        try {
            return fAccessBridge.get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        ENABLED = SystemInfo.isWindows && ScreenReader.isEnabled((String)"com.sun.java.accessibility.AccessBridge");
    }
}

