/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.MultiValuesMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsEditorContext {
    CopyOnWriteArraySet<OptionsEditorColleague> myColleagues = new CopyOnWriteArraySet();
    Configurable myCurrentConfigurable;
    Set<Configurable> myModified = new CopyOnWriteArraySet<Configurable>();
    Map<Configurable, ConfigurationException> myErrors = new THashMap();
    private boolean myHoldingFilter;
    private final Map<Configurable, Configurable> myConfigurableToParentMap = new HashMap<Configurable, Configurable>();
    private final MultiValuesMap<Configurable, Configurable> myParentToChildrenMap = new MultiValuesMap();

    ActionCallback fireSelected(final @Nullable Configurable configurable, @NotNull OptionsEditorColleague requestor) {
        if (requestor == null) {
            OptionsEditorContext.$$$reportNull$$$0(0);
        }
        if (this.myCurrentConfigurable == configurable) {
            return ActionCallback.REJECTED;
        }
        final Configurable old = this.myCurrentConfigurable;
        this.myCurrentConfigurable = configurable;
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onSelected(configurable, old);
            }
        }, requestor);
    }

    ActionCallback fireModifiedAdded(final @NotNull Configurable configurable, @Nullable OptionsEditorColleague requestor) {
        if (configurable == null) {
            OptionsEditorContext.$$$reportNull$$$0(1);
        }
        if (this.myModified.contains(configurable)) {
            return ActionCallback.REJECTED;
        }
        this.myModified.add(configurable);
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onModifiedAdded(configurable);
            }
        }, requestor);
    }

    ActionCallback fireModifiedRemoved(final @NotNull Configurable configurable, @Nullable OptionsEditorColleague requestor) {
        if (configurable == null) {
            OptionsEditorContext.$$$reportNull$$$0(2);
        }
        if (!this.myModified.contains(configurable)) {
            return ActionCallback.REJECTED;
        }
        this.myModified.remove(configurable);
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onModifiedRemoved(configurable);
            }
        }, requestor);
    }

    ActionCallback fireErrorsChanged(Map<Configurable, ConfigurationException> errors, OptionsEditorColleague requestor) {
        if (this.myErrors.equals(errors)) {
            return ActionCallback.REJECTED;
        }
        this.myErrors = errors != null ? errors : new HashMap();
        return this.notify(new ColleagueAction(){

            @Override
            public ActionCallback process(OptionsEditorColleague colleague) {
                return colleague.onErrorsChanged();
            }
        }, requestor);
    }

    ActionCallback notify(ColleagueAction action, OptionsEditorColleague requestor) {
        ActionCallback.Chunk chunk = new ActionCallback.Chunk();
        for (OptionsEditorColleague each : this.myColleagues) {
            if (each == requestor) continue;
            chunk.add(action.process(each));
        }
        return chunk.getWhenProcessed();
    }

    public void fireReset(Configurable configurable) {
        if (this.myModified.contains(configurable)) {
            this.fireModifiedRemoved(configurable, null);
        }
        if (this.myErrors.containsKey(configurable)) {
            THashMap newErrors = new THashMap();
            newErrors.remove(configurable);
            this.fireErrorsChanged((Map<Configurable, ConfigurationException>)newErrors, null);
        }
    }

    public boolean isModified(Configurable configurable) {
        return this.myModified.contains(configurable);
    }

    public void setHoldingFilter(boolean holding) {
        this.myHoldingFilter = holding;
    }

    public boolean isHoldingFilter() {
        return this.myHoldingFilter;
    }

    public Configurable getParentConfigurable(Configurable configurable) {
        return this.myConfigurableToParentMap.get(configurable);
    }

    public void registerKid(Configurable parent, Configurable kid) {
        this.myConfigurableToParentMap.put(kid, parent);
        this.myParentToChildrenMap.put((Object)parent, (Object)kid);
    }

    public Collection<Configurable> getChildren(Configurable parent) {
        Collection result2 = this.myParentToChildrenMap.get((Object)parent);
        return result2 == null ? Collections.emptySet() : result2;
    }

    public Configurable getCurrentConfigurable() {
        return this.myCurrentConfigurable;
    }

    public Set<Configurable> getModified() {
        return this.myModified;
    }

    public Map<Configurable, ConfigurationException> getErrors() {
        return this.myErrors;
    }

    public void addColleague(@NotNull OptionsEditorColleague colleague) {
        if (colleague == null) {
            OptionsEditorContext.$$$reportNull$$$0(3);
        }
        this.myColleagues.add(colleague);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colleague";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/newEditor/OptionsEditorContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fireSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fireModifiedAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fireModifiedRemoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addColleague";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface ColleagueAction {
        public ActionCallback process(OptionsEditorColleague var1);
    }
}

