/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSRemoveBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        RemoveBracesPredicate removeBracesPredicate = new RemoveBracesPredicate();
        if (removeBracesPredicate == null) {
            JSRemoveBracesIntention.$$$reportNull$$$0(0);
        }
        return removeBracesPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = ifStatement.getElse();
            keyword = element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD;
        } else {
            PsiElement keywordChild = parent.getFirstChild();
            assert (keywordChild != null);
            keyword = keywordChild.getText();
        }
        return this.getText(keyword);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSRemoveBracesIntention.$$$reportNull$$$0(1);
        }
        JSBlockStatement blockStatement = (JSBlockStatement)element;
        JSStatement[] statements = blockStatement.getStatements();
        JSStatement statement = statements[0];
        JSElement parent = (JSElement)blockStatement.getParent();
        assert (parent != null);
        JSElement grandParent = (JSElement)parent.getParent();
        assert (grandParent != null);
        PsiElement sibling = statement.getFirstChild();
        assert (sibling != null);
        for (sibling = sibling.getNextSibling(); sibling != null && !sibling.equals(statement); sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof PsiComment)) continue;
            grandParent.addBefore(sibling, (PsiElement)parent);
        }
        PsiElement lastChild = blockStatement.getLastChild();
        if (lastChild instanceof PsiComment) {
            JSElement nextSibling = (JSElement)parent.getNextSibling();
            grandParent.addAfter(lastChild, (PsiElement)nextSibling);
        }
        String text = statement.getText();
        JSElementFactory.replaceStatement((JSStatement)blockStatement, (String)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemoveBracesPredicate
    implements JSElementPredicate {
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                RemoveBracesPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSBlockStatement)) {
                return false;
            }
            JSBlockStatement blockStatement = (JSBlockStatement)element;
            PsiElement parent = blockStatement.getParent();
            if (!(parent instanceof JSIfStatement || parent instanceof JSWhileStatement || parent instanceof JSDoWhileStatement || parent instanceof JSForStatement || parent instanceof JSForInStatement)) {
                return false;
            }
            JSStatement[] statements = blockStatement.getStatements();
            return statements.length == 1 && !(statements[0] instanceof JSVarStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention$RemoveBracesPredicate", "satisfiedBy"));
        }
    }
}

