/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.Producer;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestLanguage;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class OpenInScratchFileAction
extends AnAction
implements ActionIdProvider {
    private static final String ID = "HTTPClient.OpenInScratchFile";
    private final Producer<? extends RestClientRequest> myRequestProducer;

    public OpenInScratchFileAction(@NotNull Producer<? extends RestClientRequest> requestProducer) {
        if (requestProducer == null) {
            OpenInScratchFileAction.$$$reportNull$$$0(0);
        }
        this.myRequestProducer = requestProducer;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenInScratchFileAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        RestClientRequest request = (RestClientRequest)this.myRequestProducer.produce();
        OpenInScratchFileAction.createAndOpenScratchFile(project, request);
    }

    public String getId() {
        return ID;
    }

    public static void createAndOpenScratchFile(@NotNull Project project, @NotNull RestClientRequest request) {
        NavigatablePsiElement psiElement;
        if (project == null) {
            OpenInScratchFileAction.$$$reportNull$$$0(2);
        }
        if (request == null) {
            OpenInScratchFileAction.$$$reportNull$$$0(3);
        }
        String fileName = PathUtil.makeFileName((String)"rest-api", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        try {
            psiElement = (NavigatablePsiElement)WriteCommandAction.writeCommandAction((Project)project).withName(RestClientBundle.message("http.request.create.scratch.file.with.request.action.title", new Object[0])).withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(() -> {
                VirtualFile file;
                if (project == null) {
                    OpenInScratchFileAction.$$$reportNull$$$0(4);
                }
                if (request == null) {
                    OpenInScratchFileAction.$$$reportNull$$$0(5);
                }
                ScratchFileService fileService = ScratchFileService.getInstance();
                try {
                    file = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_new_always);
                }
                catch (IOException e) {
                    throw new Exception(UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), e);
                }
                fileService.getScratchesMapping().setMapping(file, (Object)HttpRequestLanguage.INSTANCE);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof HttpRequestPsiFile)) {
                    throw new Exception(RestClientBundle.message("http.request.create.scratch.file.with.request.failed", new Object[0]));
                }
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                Document document = manager.getDocument(psiFile);
                if (document == null) {
                    throw new Exception(RestClientBundle.message("http.request.create.scratch.file.with.request.file.is.invalid", new Object[0]));
                }
                document.insertString(document.getTextLength(), (CharSequence)HttpRequestPsiConverter.toPsiHttpRequest(request));
                manager.commitDocument(document);
                HttpRequestBlock[] updated = HttpRequestPsiUtils.getRequestBlocks(psiFile);
                if (updated.length > 0) {
                    return updated[updated.length - 1];
                }
                return psiFile;
            });
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
            return;
        }
        if (psiElement != null) {
            psiElement.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/actions/OpenInScratchFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAndOpenScratchFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createAndOpenScratchFile$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

