/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.parser;

import com.intellij.indentation.IndentationParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.psi.HAMLElementTypes;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public final class HAMLParser
extends IndentationParser {
    private boolean myAddClosingTags = true;

    public HAMLParser() {
        super(HAMLElementTypes.HAML_DOCUMENT, HAMLElementTypes.HAML_TAG, HAMLTokenTypes.EOL, HAMLTokenTypes.INDENT);
    }

    protected void closeBlock(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @Nullable IElementType startTokenType) {
        if (builder == null) {
            HAMLParser.$$$reportNull$$$0(0);
        }
        if (marker == null) {
            HAMLParser.$$$reportNull$$$0(1);
        }
        if (startTokenType == HAMLTokenTypes.XHTML) {
            marker.drop();
            this.myAddClosingTags = true;
            return;
        }
        if (this.myAddClosingTags) {
            builder.mark().done(HAMLElementTypes.XML_END_TAG_START);
            builder.mark().done(HAMLElementTypes.XML_TAG_END);
        }
        super.closeBlock(builder, marker, startTokenType);
    }

    protected void advanceLexer(@NotNull PsiBuilder builder) {
        IElementType tokenType;
        if (builder == null) {
            HAMLParser.$$$reportNull$$$0(2);
        }
        if ((tokenType = builder.getTokenType()) != HAMLTokenTypes.EOL && tokenType != HAMLTokenTypes.INDENT) {
            this.myAddClosingTags = true;
        }
        if (tokenType == HAMLTokenTypes.CLOSE_TAG) {
            this.myAddClosingTags = false;
            builder.mark().done(HAMLElementTypes.XML_END_TAG_START);
            super.advanceLexer(builder);
        } else if (tokenType == HAMLTokenTypes.OP_BRACE) {
            HAMLParser.parseArguments(builder);
        } else if (tokenType == HAMLTokenTypes.XHTML) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done(HAMLElementTypes.HAML_DOCTYPE);
        } else if (tokenType == HAMLTokenTypes.CLASS_START || tokenType == HAMLTokenTypes.ID_START) {
            PsiBuilder.Marker argument = builder.mark();
            builder.advanceLexer();
            builder.mark().done(HAMLElementTypes.HAML_CLASS_OR_ID);
            PsiBuilder.Marker value = builder.mark();
            if (tokenType != HAMLTokenTypes.TEXT) {
                builder.advanceLexer();
            } else {
                builder.error("Expected " + ("#".equals(builder.getTokenText()) ? "id " : "class") + " name");
            }
            value.done(HAMLElementTypes.HAML_ARGUMENT_VALUE);
            argument.done(HAMLElementTypes.HAML_ARGUMENT);
        } else {
            super.advanceLexer(builder);
        }
    }

    private static void parseArguments(PsiBuilder builder) {
        builder.advanceLexer();
        boolean first = true;
        while (builder.getTokenType() != HAMLTokenTypes.CL_BRACE) {
            if (builder.getTokenType() != HAMLTokenTypes.PARAM) {
                builder.error("Expected argument name");
                return;
            }
            HAMLParser.parseArgument(builder, first);
            first = false;
            if (builder.eof()) {
                builder.error("Unexpected end of file");
                return;
            }
            IElementType tokenType = builder.getTokenType();
            if (tokenType != HAMLTokenTypes.PSEUDO_TAG_START && tokenType != HAMLTokenTypes.CLASS_START && tokenType != HAMLTokenTypes.ID_START && tokenType != HAMLTokenTypes.TEXT) continue;
            builder.error("Missing )");
            return;
        }
    }

    private static void parseArgument(PsiBuilder builder, boolean first) {
        if (first) {
            builder.mark().done(HAMLElementTypes.HAML_PSEUDO_WHITESPACE);
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        IElementType type = builder.getTokenType();
        if (type == HAMLTokenTypes.CL_BRACE) {
            mark.done(HAMLElementTypes.HAML_ARGUMENT);
        } else if (type == HAMLTokenTypes.EQUALS) {
            builder.advanceLexer();
            HAMLParser.parseValue(builder);
            mark.done(HAMLElementTypes.HAML_ARGUMENT);
        } else {
            if (builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                builder.error("Missing closing quote sign");
            }
            mark.done(HAMLElementTypes.HAML_ARGUMENT);
        }
    }

    private static void parseValue(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            HAMLParser.parseString(builder);
        } else if (type == HAMLTokenTypes.INJECTION_CODE || type == HAMLTokenTypes.PARAM) {
            builder.advanceLexer();
            if (builder.getTokenType() == HAMLTokenTypes.WHITESPACE) {
                builder.advanceLexer();
            }
        } else {
            builder.error("Expected argument value");
        }
    }

    private static void parseString(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        do {
            if (builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                builder.advanceLexer();
                mark.done(HAMLElementTypes.HAML_ARGUMENT_VALUE);
                break;
            }
            if (builder.eof() || builder.getTokenType() == HAMLTokenTypes.WHITESPACE || builder.getTokenType() == HAMLTokenTypes.EOL) {
                builder.error("Missing closing quote sign");
                mark.done(HAMLElementTypes.HAML_ARGUMENT_VALUE);
                break;
            }
            builder.advanceLexer();
        } while (builder.rawLookup(-1) != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER);
        if (builder.getTokenType() == HAMLTokenTypes.WHITESPACE) {
            builder.advanceLexer();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/haml/parser/HAMLParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "closeBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceLexer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

