/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.netgtp;

import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import net.sf.gogui.netgtp.SocketOutputCopy;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StreamCopy;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class NetGtp {
    private static Socket connect(String string, int n, int n2) throws IOException {
        int n3 = 0;
        while (true) {
            try {
                return new Socket(string, n);
            }
            catch (ConnectException connectException) {
                if (n3 >= n2) {
                    throw connectException;
                }
                String string2 = "netgtp: Connect failed; retrying in 5 sec...";
                System.err.println(string2);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n3 += 5;
                continue;
            }
            break;
        }
    }

    public NetGtp(String string, int n, int n2) throws Exception {
        Socket socket = NetGtp.connect(string, n, n2);
        Thread thread = new Thread(new StreamCopy(false, socket.getInputStream(), System.out, false));
        SocketOutputCopy socketOutputCopy = new SocketOutputCopy(socket);
        thread.start();
        socketOutputCopy.start();
        thread.join();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"config:", "help", "timeout:", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                NetGtp.printUsage(System.out);
                System.exit(0);
            }
            if (options.isSet("version")) {
                System.out.println("NetGtp " + Version.get());
                System.exit(0);
            }
            int n = options.getInteger("timeout", 10, 0);
            ArrayList arrayList = options.getArguments();
            if (arrayList.size() != 2) {
                NetGtp.printUsage(System.err);
                System.exit(-1);
            }
            String string = (String)arrayList.get(0);
            int n2 = Integer.parseInt((String)arrayList.get(1));
            new NetGtp(string, n2, n);
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private static void printUsage(PrintStream printStream) {
        String string = "Usage: java -jar netgtp.jar [options] hostname port\n\n-config  config file\n-help    display this help and exit\n-timeout stop trying to connect after n seconds (default 10)\n-version print version and exit\n";
        printStream.print(string);
    }
}

