/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.util.JMAppsCfg;

public class OpenRtpDialog
extends JMDialog
implements TextListener,
FocusListener {
    private TextField fieldAddress0;
    private TextField fieldAddress1;
    private TextField fieldAddress2;
    private TextField fieldAddress3;
    private TextField fieldPort;
    private Choice choiceTtl;
    private JMAppsCfg cfgJMApps = null;
    private String strAddress = null;
    private String strPort = null;
    private String strTtl = null;

    public OpenRtpDialog(Frame frame, JMAppsCfg cfgJMApps) {
        super(frame, JMFI18N.getResource("jmstudio.openrtp.title"), true);
        this.cfgJMApps = cfgJMApps;
        this.init();
    }

    public String getAddress() {
        return this.strAddress;
    }

    public String getPort() {
        return this.strPort;
    }

    public String getTtl() {
        return this.strTtl;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JMPanel panelContent = new JMPanel(new BorderLayout(6, 6));
        panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)panelContent, "Center");
        panelContent.setBackground(Color.lightGray);
        JMPanel panel = this.createPanelSource();
        panelContent.add((Component)panel, "Center");
        panel = new JMPanel(new FlowLayout(1));
        this.add((Component)panel, "South");
        JMPanel panelButtons = this.createButtonPanel(new String[]{JMDialog.ACTION_OPEN, JMDialog.ACTION_CANCEL});
        panel.add(panelButtons);
        this.pack();
        this.setResizable(false);
    }

    private JMPanel createPanelSource() {
        JMAppsCfg.RtpData dataRtp = this.cfgJMApps.getLastOpenRtpData();
        JMPanel panelSource = new JMPanel(new BorderLayout(6, 6));
        JMPanel panelLabels = new JMPanel(new GridLayout(0, 1, 6, 6));
        panelSource.add((Component)panelLabels, "West");
        JMPanel panelParams = new JMPanel(new GridLayout(0, 1, 6, 6));
        panelSource.add((Component)panelParams, "Center");
        Label label = new Label(JMFI18N.getResource("jmstudio.openrtp.label.address"));
        panelLabels.add(label);
        JMPanel panelAddress = new JMPanel(new GridLayout(1, 0, 2, 2));
        panelParams.add(panelAddress);
        this.fieldAddress0 = new TextField(3);
        if (dataRtp != null) {
            this.fieldAddress0.setText(dataRtp.strAddress0);
        }
        this.fieldAddress0.addTextListener(this);
        this.fieldAddress0.addFocusListener(this);
        panelAddress.add(this.fieldAddress0);
        this.fieldAddress1 = new TextField(3);
        if (dataRtp != null) {
            this.fieldAddress1.setText(dataRtp.strAddress1);
        }
        this.fieldAddress1.addTextListener(this);
        this.fieldAddress1.addFocusListener(this);
        panelAddress.add(this.fieldAddress1);
        this.fieldAddress2 = new TextField(3);
        if (dataRtp != null) {
            this.fieldAddress2.setText(dataRtp.strAddress2);
        }
        this.fieldAddress2.addTextListener(this);
        this.fieldAddress2.addFocusListener(this);
        panelAddress.add(this.fieldAddress2);
        this.fieldAddress3 = new TextField(3);
        if (dataRtp != null) {
            this.fieldAddress3.setText(dataRtp.strAddress3);
        }
        this.fieldAddress3.addTextListener(this);
        this.fieldAddress3.addFocusListener(this);
        panelAddress.add(this.fieldAddress3);
        label = new Label(JMFI18N.getResource("jmstudio.openrtp.label.port"));
        panelLabels.add(label);
        this.fieldPort = new TextField(5);
        if (dataRtp != null) {
            this.fieldPort.setText(dataRtp.strPort);
        }
        this.fieldPort.addFocusListener(this);
        panelParams.add(this.fieldPort);
        label = new Label(JMFI18N.getResource("jmstudio.openrtp.label.ttl"));
        panelLabels.add(label);
        this.choiceTtl = new Choice();
        panelParams.add(this.choiceTtl);
        this.choiceTtl.addItem("1");
        this.choiceTtl.addItem("2");
        this.choiceTtl.addItem("3");
        this.choiceTtl.addItem("4");
        this.choiceTtl.addItem("8");
        this.choiceTtl.addItem("16");
        this.choiceTtl.addItem("32");
        this.choiceTtl.addItem("64");
        this.choiceTtl.addItem("128");
        this.choiceTtl.addItem("255");
        if (dataRtp != null) {
            this.choiceTtl.select(dataRtp.strTtl);
        }
        return panelSource;
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        this.fieldAddress0.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        String strAction = event.getActionCommand();
        if (strAction.equals(JMDialog.ACTION_OPEN)) {
            if (this.validateData()) {
                this.setAction(strAction);
                this.dispose();
            }
        } else if (strAction.equals(JMDialog.ACTION_CANCEL)) {
            this.setAction(strAction);
            this.dispose();
        }
    }

    public void textValueChanged(TextEvent event) {
        TextField textField;
        String strValue;
        Object objectSource = event.getSource();
        if (objectSource instanceof TextField && (strValue = (textField = (TextField)objectSource).getText()).length() > 2) {
            textField.transferFocus();
        }
    }

    public boolean validateData() {
        int nValue;
        String strValue;
        JMAppsCfg.RtpData dataRtp = this.cfgJMApps.createRtpDataObject();
        dataRtp.strAddress0 = strValue = this.fieldAddress0.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = new String(strValue);
        dataRtp.strAddress1 = strValue = this.fieldAddress1.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = this.strAddress + "." + strValue;
        dataRtp.strAddress2 = strValue = this.fieldAddress2.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = this.strAddress + "." + strValue;
        dataRtp.strAddress3 = strValue = this.fieldAddress3.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = this.strAddress + "." + strValue;
        dataRtp.strPort = this.strPort = this.fieldPort.getText();
        try {
            nValue = Integer.valueOf(this.strPort);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || (nValue & 1) == 1) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.port"));
            return false;
        }
        dataRtp.strTtl = this.strTtl = this.choiceTtl.getSelectedItem();
        if (this.cfgJMApps != null) {
            this.cfgJMApps.setLastOpenRtpData(dataRtp);
        }
        return true;
    }

    public void focusGained(FocusEvent fe) {
        Object source = fe.getSource();
        if (source instanceof TextField) {
            ((TextField)source).selectAll();
        }
    }

    public void focusLost(FocusEvent fe) {
        Object source = fe.getSource();
        if (source instanceof TextField) {
            ((TextField)source).select(1, 0);
        }
    }
}

