/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageListAttribute;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.ImageAttributeBaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyImageAttribute
extends ImageAttributeBaseCmd {
    private static final String[] BLOCK_DEVICE_MAPPING_DESC = new String[]{"Set the block-device-mapping for the specified AMI to MAPPING."};
    private static final String BLOCK_DEVICE_MAPPING_ARG = "MAPPING";
    private static final String[] PROFILE_DESC = new String[]{"Set the OS-profile associated with the specified AKI to PROFILE."};
    private static final String PROFILE_ARG = "PROFILE";
    private static final String[] RAMDISK_DESC = new String[]{"Set the ramdisk associated with the specified AMI to RAMDISK-ID."};
    private static final String RAMDISK_ARG = "RAMDISK-ID";
    private static final String[] KERNEL_DESC = new String[]{"Set the kernel associated with the specified AMI to KERNEL-ID."};
    private static final String KERNEL_ARG = "KERNEL-ID";
    private static final String[] PRODUCT_CODE_DESC = new String[]{"Set the product code associated with the specified image to CODE."};
    private static final String PRODUCT_CODE_ARG = "CODE";
    private static final String[] REMOVE_DESC = new String[]{"Remove a stated attribute, e.g launch permissions, from the ENTITY", "specified. Valid ENTITY values are:", "  AWS Account ID:  User ID to lose stated image attribute.", "  all:             All users to lose the stated image attribute."};
    private static final String REMOVE_ARG = "ENTITY [--remove ENTITY...]";
    private static final String[] ADD_DESC = new String[]{"Add a stated attribute, e.g launch permissions, to the specified", "ENTITY. Valid ENTITY values are:", "  AWS Account ID:  User ID to receive stated image attribute.", "  all:             All users to receive the stated image attribute."};
    private static final String ADD_ARG = "ENTITY [--add ENTITY...]";
    private static final String[] LAUNCH_PERMISSION_DESC = new String[]{"Used together with the --add or --remove flags to, respectively,", "grant or revoke launch permissions on the specified image for the", "specified ENTITY."};
    public static final String[] MODIFY_ATTRIBUTE_ARGS = new String[]{"launch-permission", "product-code"};

    public ModifyImageAttribute(String[] args) {
        super("ec2mimatt", new String[]{"ec2-modify-image-attribute", "ec2matt"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"launch-permission");
        OptionBuilder.withDescription((String)ModifyImageAttribute.joinDescription(LAUNCH_PERMISSION_DESC));
        result.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"add");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyImageAttribute.joinDescription(ADD_DESC));
        OptionBuilder.withArgName((String)ADD_ARG);
        result.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"remove");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyImageAttribute.joinDescription(REMOVE_DESC));
        OptionBuilder.withArgName((String)REMOVE_ARG);
        result.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"product-code");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyImageAttribute.joinDescription(PRODUCT_CODE_DESC));
        OptionBuilder.withArgName((String)PRODUCT_CODE_ARG);
        result.addOption(OptionBuilder.create((String)"p"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return null;
    }

    @Override
    protected List<String> getOptionStrings() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("IMAGE (-l ( -a ENTITY | -r ENTITY ) | -p CODE )");
        return options;
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("launch-permission");
        this.printOption("add");
        this.printOption("remove");
        this.printOption("product-code");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modify an attribute on an Amazon Image. The IMAGE parameter is the ID of");
        System.out.println("     the Amazon Image for which to modify an attribute. An Amazon Image may be:");
        System.out.println("     \t- an Amazon Machine Image (AMI) or");
        System.out.println("     \t- an Amazon Kernel  Image (AKI) or");
        System.out.println("     \t- an Amazon Ramdisk Image (ARI).");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        String imageId = this.getAmiId();
        this.assertOnlyOneOptionSet(MODIFY_ATTRIBUTE_ARGS);
        ImageAttribute attribute = this.getImageAttribute(jec2);
        ImageListAttribute.ImageListAttributeOperationType operationType = null;
        if (attribute instanceof ImageListAttribute) {
            operationType = this.getAttributeListOperationType();
        }
        if (((Boolean)(rsp = jec2.modifyImageAttribute(imageId, attribute, operationType)).getResponse()).booleanValue()) {
            out.output(System.out, imageId, attribute, operationType);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    public static void main(String[] args) {
        new ModifyImageAttribute(args).invoke();
    }
}

