/*****
 NAME
	cxmlnode.h - header file for CXMLNode class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(CXMLNODE_H_INCLUDED)
#define CXMLNODE_H_INCLUDED

#include <coconut/cobject.h>
#include <coconut/pxmltree.h>

#include <coconut/dconfig.h>
#ifdef COCONUT_HAVE_XML2_CONFIG
#	include <libxml/xmlmemory.h>
#	include <libxml/parser.h>
#else
#	error "This code requires libxml2 package"
#endif

@interface CXMLNode : CObject <PXMLNode>
{
	xmlNodePtr	current_node ;
	xmlAttrPtr	attr_ptr ;
	selection_t	node_selection ;
}

- initXMLNode: (xmlNodePtr) node ;

/* private method for this class */
- (id <PXMLNode>) p_searchChildByTagName: (const utf8_char *) name 
    level: (int) level ;

- p_foreach: (id) dstobj message: (SEL) message with: p1 ;
- p_foreachCondition: (condition_func_t) func obj: (id) dstobj 
     message: (SEL) message with: p1 ;
- p_foreachObject: (SEL) message with: p1 with: p2 ;
- p_foreachConditionObject: (condition_func_t) func message: (SEL) message
     with: p1 with: p2 ;

@end

#endif /* !defined(CXMLNODE_H_INCLUDED) */

