/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer.rules;

import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.rules.BaseRule;

public class CharacterEncodingRule
extends BaseRule {
    private String encoding;

    public void setEncoding(String theEncoding) {
        if (theEncoding == null) {
            throw new IllegalArgumentException("The encoding cannot be null.");
        }
        this.encoding = theEncoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public boolean matches(HttpServletRequest request) {
        String actualEncoding = request.getCharacterEncoding();
        return this.getEncoding().compareTo(actualEncoding) == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        buffer.append("Target encoding: ");
        buffer.append(this.getEncoding());
        buffer.append(" / ");
        buffer.append("Redirect URL: ");
        buffer.append(this.getRedirectUrl());
        buffer.append("]");
        return buffer.toString();
    }
}

