/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class JavabinLoader
extends ContentStreamLoader {
    final ContentStreamLoader contentStreamLoader;

    public JavabinLoader() {
        this.contentStreamLoader = this;
    }

    public JavabinLoader(ContentStreamLoader contentStreamLoader) {
        this.contentStreamLoader = contentStreamLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        try (InputStream is = null;){
            is = stream.getStream();
            this.parseAndLoadDocs(req, rsp, is, processor);
        }
    }

    private void parseAndLoadDocs(final SolrQueryRequest req, SolrQueryResponse rsp, InputStream stream, final UpdateRequestProcessor processor) throws IOException {
        if (req.getParams().getBool("multistream", false)) {
            this.handleMultiStream(req, rsp, stream, processor);
            return;
        }
        UpdateRequest update = null;
        JavaBinUpdateRequestCodec.StreamingUpdateHandler handler = new JavaBinUpdateRequestCodec.StreamingUpdateHandler(){
            private AddUpdateCommand addCmd = null;

            public void update(SolrInputDocument document, UpdateRequest updateRequest, Integer commitWithin, Boolean overwrite) {
                if (document == null) {
                    return;
                }
                if (this.addCmd == null) {
                    this.addCmd = JavabinLoader.this.getAddCommand(req, (SolrParams)updateRequest.getParams());
                }
                this.addCmd.solrDoc = document;
                if (commitWithin != null) {
                    this.addCmd.commitWithin = commitWithin;
                }
                if (overwrite != null) {
                    this.addCmd.overwrite = overwrite;
                }
                if (updateRequest.isLastDocInBatch()) {
                    this.addCmd.isLastDocInBatch = true;
                }
                try {
                    processor.processAdd(this.addCmd);
                    this.addCmd.clear();
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR adding document " + document, (Throwable)e);
                }
            }
        };
        FastInputStream in = FastInputStream.wrap((InputStream)stream);
        while (true) {
            if (in.peek() == -1) {
                return;
            }
            try {
                update = new JavaBinUpdateRequestCodec().unmarshal((InputStream)in, handler);
            }
            catch (EOFException e) {
                break;
            }
            if (update.getDeleteByIdMap() == null && update.getDeleteQuery() == null) continue;
            this.delete(req, update, processor);
        }
    }

    private void handleMultiStream(final SolrQueryRequest req, final SolrQueryResponse rsp, InputStream stream, final UpdateRequestProcessor processor) throws IOException {
        FastInputStream in = FastInputStream.wrap((InputStream)stream);
        final SolrParams old = req.getParams();
        try (JavaBinCodec jbc = new JavaBinCodec(){
            SolrParams params;
            AddUpdateCommand addCmd = null;

            public List<Object> readIterator(DataInputInputStream fis) throws IOException {
                Object o;
                while ((o = this.readVal(fis)) != END_OBJ) {
                    if (o instanceof NamedList) {
                        this.params = ((NamedList)o).toSolrParams();
                        continue;
                    }
                    try {
                        if (o instanceof byte[]) {
                            if (this.params != null) {
                                req.setParams(this.params);
                            }
                            byte[] buf = (byte[])o;
                            JavabinLoader.this.contentStreamLoader.load(req, rsp, (ContentStream)new ContentStreamBase.ByteArrayStream(buf, null), processor);
                            continue;
                        }
                        throw new RuntimeException("unsupported type ");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.params = null;
                        req.setParams(old);
                    }
                }
                return Collections.emptyList();
            }
        };){
            jbc.unmarshal((InputStream)in);
        }
    }

    private AddUpdateCommand getAddCommand(SolrQueryRequest req, SolrParams params) {
        AddUpdateCommand addCmd = new AddUpdateCommand(req);
        addCmd.overwrite = params.getBool("overwrite", true);
        addCmd.commitWithin = params.getInt("commitWithin", -1);
        return addCmd;
    }

    private void delete(SolrQueryRequest req, UpdateRequest update, UpdateRequestProcessor processor) throws IOException {
        ModifiableSolrParams params = update.getParams();
        DeleteUpdateCommand delcmd = new DeleteUpdateCommand(req);
        if (params != null) {
            delcmd.commitWithin = params.getInt("commitWithin", -1);
        }
        if (update.getDeleteByIdMap() != null) {
            Set entries = update.getDeleteByIdMap().entrySet();
            for (Map.Entry e : entries) {
                String route;
                Long version;
                delcmd.id = (String)e.getKey();
                Map map = (Map)e.getValue();
                if (map != null && (version = (Long)map.get("ver")) != null) {
                    delcmd.setVersion(version);
                }
                if (map != null && (route = (String)map.get("_route_")) != null) {
                    delcmd.setRoute(route);
                }
                processor.processDelete(delcmd);
                delcmd.clear();
            }
        }
        if (update.getDeleteQuery() != null) {
            Iterator iterator = update.getDeleteQuery().iterator();
            while (iterator.hasNext()) {
                String s;
                delcmd.query = s = (String)iterator.next();
                processor.processDelete(delcmd);
            }
        }
    }
}

