/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.MergeIterator;

public class QueryFilter {
    public final DecoratedKey key;
    public final String cfName;
    public final IDiskAtomFilter filter;
    public final long timestamp;

    public QueryFilter(DecoratedKey key, String cfName, IDiskAtomFilter filter, long timestamp) {
        this.key = key;
        this.cfName = cfName;
        this.filter = filter;
        this.timestamp = timestamp;
    }

    public Iterator<Cell> getIterator(ColumnFamily cf) {
        assert (cf != null);
        return this.filter.getColumnIterator(cf);
    }

    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable) {
        return this.filter.getSSTableColumnIterator(sstable, this.key);
    }

    public void collateOnDiskAtom(ColumnFamily returnCF, List<? extends Iterator<? extends OnDiskAtom>> toCollate, int gcBefore) {
        QueryFilter.collateOnDiskAtom(returnCF, toCollate, this.filter, this.key, gcBefore, this.timestamp);
    }

    public static void collateOnDiskAtom(ColumnFamily returnCF, List<? extends Iterator<? extends OnDiskAtom>> toCollate, IDiskAtomFilter filter, DecoratedKey key, int gcBefore, long timestamp) {
        ArrayList<Iterator<Cell>> filteredIterators = new ArrayList<Iterator<Cell>>(toCollate.size());
        for (Iterator<? extends OnDiskAtom> iterator : toCollate) {
            filteredIterators.add(QueryFilter.gatherTombstones(returnCF, iterator));
        }
        QueryFilter.collateColumns(returnCF, filteredIterators, filter, key, gcBefore, timestamp);
    }

    public void collateOnDiskAtom(ColumnFamily returnCF, Iterator<? extends OnDiskAtom> toCollate, int gcBefore) {
        this.filter.collectReducedColumns(returnCF, QueryFilter.gatherTombstones(returnCF, toCollate), this.key, gcBefore, this.timestamp);
    }

    public void collateColumns(ColumnFamily returnCF, List<? extends Iterator<Cell>> toCollate, int gcBefore) {
        QueryFilter.collateColumns(returnCF, toCollate, this.filter, this.key, gcBefore, this.timestamp);
    }

    public static void collateColumns(ColumnFamily returnCF, List<? extends Iterator<Cell>> toCollate, IDiskAtomFilter filter, DecoratedKey key, int gcBefore, long timestamp) {
        Comparator<Cell> comparator = filter.getColumnComparator(returnCF.getComparator());
        Iterator<Cell> reduced = toCollate.size() == 1 ? toCollate.get(0) : MergeIterator.get(toCollate, comparator, QueryFilter.getReducer(comparator));
        filter.collectReducedColumns(returnCF, reduced, key, gcBefore, timestamp);
    }

    private static MergeIterator.Reducer<Cell, Cell> getReducer(final Comparator<Cell> comparator) {
        return new MergeIterator.Reducer<Cell, Cell>(){
            Cell current;

            @Override
            public void reduce(Cell next) {
                assert (this.current == null || comparator.compare(this.current, next) == 0);
                this.current = this.current == null ? next : this.current.reconcile(next);
            }

            @Override
            protected Cell getReduced() {
                assert (this.current != null);
                Cell toReturn = this.current;
                this.current = null;
                return toReturn;
            }

            @Override
            public boolean trivialReduceIsTrivial() {
                return true;
            }
        };
    }

    public static Iterator<Cell> gatherTombstones(final ColumnFamily returnCF, final Iterator<? extends OnDiskAtom> iter) {
        return new Iterator<Cell>(){
            private Cell next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                this.getNext();
                return this.next != null;
            }

            @Override
            public Cell next() {
                if (this.next == null) {
                    this.getNext();
                }
                assert (this.next != null);
                Cell toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private void getNext() {
                while (iter.hasNext()) {
                    OnDiskAtom atom = (OnDiskAtom)iter.next();
                    if (atom instanceof Cell) {
                        this.next = (Cell)atom;
                        break;
                    }
                    returnCF.addAtom(atom);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getColumnFamilyName() {
        return this.cfName;
    }

    public static QueryFilter getSliceFilter(DecoratedKey key, String cfName, Composite start, Composite finish, boolean reversed, int limit, long timestamp) {
        return new QueryFilter(key, cfName, new SliceQueryFilter(start, finish, reversed, limit), timestamp);
    }

    public static QueryFilter getIdentityFilter(DecoratedKey key, String cfName, long timestamp) {
        return new QueryFilter(key, cfName, new IdentityQueryFilter(), timestamp);
    }

    public static QueryFilter getNamesFilter(DecoratedKey key, String cfName, SortedSet<CellName> columns, long timestamp) {
        return new QueryFilter(key, cfName, new NamesQueryFilter(columns), timestamp);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(key=" + this.key + ", cfName=" + this.cfName + (this.filter == null ? "" : ", filter=" + this.filter) + ")";
    }

    public boolean shouldInclude(SSTableReader sstable) {
        return this.filter.shouldInclude(sstable);
    }

    public void delete(DeletionInfo target, ColumnFamily source) {
        target.add(source.deletionInfo().getTopLevelDeletion());
        Iterator<RangeTombstone> iter = this.filter.getRangeTombstoneIterator(source);
        while (iter.hasNext()) {
            target.add(iter.next(), source.getComparator());
        }
    }
}

