/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomAccessFileReader
extends Reader
implements DataInput {
    private static final Logger LOG = LoggerFactory.getLogger(RandomAccessFileReader.class);
    private RandomAccessFile file;
    private byte[] buffer;
    private int buffersize;
    private int bufferoffset;
    private long fileoffset;
    private long fp;
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private int point = 0;

    public RandomAccessFileReader(File f) throws FileNotFoundException {
        this.file = new RandomAccessFile(f, "r");
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Opened file(" + f + ") with FD (" + this.file.getFD() + ")");
            }
            catch (IOException ioe) {
                LOG.debug("Opened file(" + f + ") coulds get FD");
            }
        }
        this.buffer = new byte[524288];
        this.buffersize = 0;
        this.bufferoffset = 0;
        this.fileoffset = 0L;
        this.fp = 0L;
    }

    private int fill() throws IOException {
        this.fileoffset = this.fp;
        int read = this.file.read(this.buffer, 0, this.buffer.length);
        if (LOG.isDebugEnabled()) {
            String buf = new String(this.buffer, 0, 40, "UTF-8");
            LOG.debug("fill(buffer=" + buf + ")");
        }
        this.buffersize = read == -1 ? 0 : read;
        this.fp += (long)this.buffersize;
        this.bufferoffset = 0;
        return this.buffersize;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        byte[] b = new byte[2];
        int bytesread = 0;
        while (len > 0) {
            int read = this.read(b, 0, 2);
            bytesread += read;
            if (read < 2) {
                return bytesread;
            }
            cbuf[off] = (char)(b[0] << 8 | b[1] & 0xFF);
            off += read;
            len -= read;
        }
        return bytesread;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("read(buf, off=" + off + ", len=" + len);
        }
        int read = 0;
        while (len > 0) {
            if (this.buffersize == 0) {
                this.fill();
                if (this.buffersize == 0) break;
            }
            int tocopy = Math.min(len, this.buffersize);
            if (LOG.isTraceEnabled()) {
                LOG.trace("tocopy=" + tocopy);
            }
            System.arraycopy(this.buffer, this.bufferoffset, buf, off, tocopy);
            this.buffersize -= tocopy;
            this.bufferoffset += tocopy;
            len -= tocopy;
            read += tocopy;
            off += tocopy;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("read=" + read);
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public long getPosition() {
        return (long)this.bufferoffset + this.fileoffset;
    }

    public synchronized void seek(long pos) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("seek(" + pos + ")");
        }
        this.file.seek(pos);
        this.fp = pos;
        this.buffersize = 0;
    }

    @Override
    public synchronized String readLine() throws IOException {
        StringBuffer s = null;
        block0: while (true) {
            if (this.buffersize == 0) {
                this.fill();
                if (this.buffersize == 0) break;
            }
            for (int i = 0; i < this.buffersize; ++i) {
                if (this.buffer[this.bufferoffset + i] != 10) continue;
                if (i > 0) {
                    if (s == null) {
                        s = new StringBuffer();
                    }
                    s.append(new String(this.buffer, this.bufferoffset, i, "UTF-8"));
                }
                this.bufferoffset += i + 1;
                this.buffersize -= i + 1;
                break block0;
            }
            if (s == null) {
                s = new StringBuffer();
            }
            s.append(new String(this.buffer, this.bufferoffset, this.buffersize, "UTF-8"));
            this.buffersize = 0;
        }
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int read = this.read(b, off, len);
            len -= read;
            off += read;
            if (read != 0) continue;
            throw new EOFException("End of file reached");
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seek(this.getPosition() + (long)n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        byte[] b = new byte[1];
        this.readFully(b, 0, 1);
        return b[0];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte();
    }

    @Override
    public short readShort() throws IOException {
        byte[] b = new byte[2];
        this.readFully(b, 0, 2);
        return (short)(b[0] << 8 | b[1] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte[] b = new byte[2];
        this.readFully(b, 0, 2);
        return (b[0] & 0xFF) << 8 | b[1] & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public int readInt() throws IOException {
        byte[] b = new byte[4];
        this.readFully(b, 0, 4);
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        byte[] b = new byte[8];
        this.readFully(b, 0, 8);
        return (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)(b[5] & 0xFF) << 16 | (long)(b[6] & 0xFF) << 8 | (long)(b[7] & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.readUnsignedShort();
        byte[] bytes = new byte[len + 2];
        bytes[0] = (byte)(len >> 8 & 0xFF);
        bytes[1] = (byte)(len & 0xFF);
        this.readFully(bytes, 2, len);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        return dis.readUTF();
    }

    public static void main(String[] args) throws IOException {
        int i;
        RandomAccessFileReader f = new RandomAccessFileReader(new File(args[0]));
        long pos0 = f.getPosition();
        for (int i2 = 0; i2 < 5; ++i2) {
            System.out.println(f.readLine());
        }
        System.out.println("=============");
        long pos1 = f.getPosition();
        System.out.println("pos: " + pos1);
        for (i = 0; i < 5; ++i) {
            System.out.println(f.readLine());
        }
        System.out.println("=============");
        f.seek(pos1);
        for (i = 0; i < 5; ++i) {
            System.out.println(f.readLine());
        }
        System.out.println("=============");
        f.seek(pos0);
        for (i = 0; i < 5; ++i) {
            System.out.println(f.readLine());
        }
        long pos2 = f.getPosition();
        System.out.println("=============");
        System.out.println(f.readLine());
        f.seek(pos2);
        System.out.println(f.readLine());
        f.close();
    }
}

