/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public class ModuleRevisionId
extends UnmodifiableExtendableItem {
    private static final String ENCODE_SEPARATOR = ":#@#:";
    private static final String ENCODE_PREFIX = "+";
    private static final String NULL_ENCODE = "@#:NULL:#@";
    static final String STRICT_CHARS_PATTERN = "[a-zA-Z0-9\\-/\\._+=]";
    private static final String REV_STRICT_CHARS_PATTERN = "[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]";
    private static final Map CACHE = new WeakHashMap();
    public static final Pattern MRID_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)(?:#([a-zA-Z0-9\\-/\\._+=]+))?;([a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    public static final Pattern NON_CAPTURING_PATTERN = Pattern.compile("(?:[a-zA-Z0-9\\-/\\._+=]*)#(?:[a-zA-Z0-9\\-/\\._+=]+)(?:#(?:[a-zA-Z0-9\\-/\\._+=]+))?;(?:[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    private final ModuleId moduleId;
    private final String branch;
    private final String revision;
    private int hash;

    public static ModuleRevisionId parse(String string) {
        Matcher matcher = MRID_PATTERN.matcher(string.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("module revision text representation do not match expected pattern. given mrid='" + string + "' expected form=" + MRID_PATTERN.pattern());
        }
        return ModuleRevisionId.newInstance(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
    }

    public static ModuleRevisionId newInstance(String string, String string2, String string3) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3));
    }

    public static ModuleRevisionId newInstance(String string, String string2, String string3, Map map) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3, map));
    }

    public static ModuleRevisionId newInstance(String string, String string2, String string3, String string4) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3, string4));
    }

    public static ModuleRevisionId newInstance(String string, String string2, String string3, String string4, Map map) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3, string4, map));
    }

    public static ModuleRevisionId newInstance(String string, String string2, String string3, String string4, Map map, boolean bl) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(string, string2), string3, string4, map, bl));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId moduleRevisionId, String string) {
        return ModuleRevisionId.intern(new ModuleRevisionId(moduleRevisionId.getModuleId(), moduleRevisionId.getBranch(), string, moduleRevisionId.getQualifiedExtraAttributes()));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId moduleRevisionId, String string, String string2) {
        return ModuleRevisionId.intern(new ModuleRevisionId(moduleRevisionId.getModuleId(), string, string2, moduleRevisionId.getQualifiedExtraAttributes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleRevisionId intern(ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId moduleRevisionId2 = null;
        Map map = CACHE;
        synchronized (map) {
            WeakReference weakReference = (WeakReference)CACHE.get(moduleRevisionId);
            if (weakReference != null) {
                moduleRevisionId2 = (ModuleRevisionId)weakReference.get();
            }
            if (moduleRevisionId2 == null) {
                moduleRevisionId2 = moduleRevisionId;
                CACHE.put(moduleRevisionId2, new WeakReference<ModuleRevisionId>(moduleRevisionId2));
            }
        }
        return moduleRevisionId2;
    }

    public ModuleRevisionId(ModuleId moduleId, String string) {
        this(moduleId, null, string, null);
    }

    public ModuleRevisionId(ModuleId moduleId, String string, String string2) {
        this(moduleId, string, string2, null);
    }

    private ModuleRevisionId(ModuleId moduleId, String string, Map map) {
        this(moduleId, null, string, map);
    }

    private ModuleRevisionId(ModuleId moduleId, String string, String string2, Map map) {
        this(moduleId, string, string2, map, true);
    }

    private ModuleRevisionId(ModuleId moduleId, String string, String string2, Map map, boolean bl) {
        super(null, map);
        this.moduleId = moduleId;
        IvyContext ivyContext = IvyContext.getContext();
        this.branch = bl && string == null ? (ivyContext.peekIvy() == null ? null : ivyContext.getSettings().getDefaultBranch(moduleId)) : string;
        this.revision = string2 == null ? Ivy.getWorkingRevision() : ModuleRevisionId.normalizeRevision(string2);
        this.setStandardAttribute("organisation", this.moduleId.getOrganisation());
        this.setStandardAttribute("module", this.moduleId.getName());
        this.setStandardAttribute("branch", this.branch);
        this.setStandardAttribute("revision", this.revision);
    }

    public ModuleId getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.getModuleId().getName();
    }

    public String getOrganisation() {
        return this.getModuleId().getOrganisation();
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModuleRevisionId)) {
            return false;
        }
        ModuleRevisionId moduleRevisionId = (ModuleRevisionId)object;
        if (!moduleRevisionId.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (moduleRevisionId.getBranch() == null && this.getBranch() != null) {
            return false;
        }
        if (moduleRevisionId.getBranch() != null && !moduleRevisionId.getBranch().equals(this.getBranch())) {
            return false;
        }
        if (!moduleRevisionId.getModuleId().equals(this.getModuleId())) {
            return false;
        }
        return moduleRevisionId.getQualifiedExtraAttributes().equals(this.getQualifiedExtraAttributes());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.getBranch() == null ? 0 : this.getBranch().hashCode());
            this.hash = this.hash * 13 + this.getRevision().hashCode();
            this.hash = this.hash * 13 + this.getModuleId().hashCode();
            this.hash = this.hash * 13 + this.getQualifiedExtraAttributes().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.moduleId + (this.branch == null || this.branch.length() == 0 ? "" : "#" + this.branch) + ";" + (this.revision == null ? "NONE" : this.revision);
    }

    public String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap hashMap = new HashMap(this.getAttributes());
        hashMap.keySet().removeAll(this.getExtraAttributes().keySet());
        hashMap.putAll(this.getQualifiedExtraAttributes());
        for (String string : hashMap.keySet()) {
            String string2 = (String)hashMap.get(string);
            string2 = string2 == null ? NULL_ENCODE : string2;
            stringBuffer.append(ENCODE_PREFIX).append(string).append(ENCODE_SEPARATOR).append(ENCODE_PREFIX).append(string2).append(ENCODE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public static ModuleRevisionId decode(String string) {
        String string2;
        String string3;
        String[] stringArray = string.split(ENCODE_SEPARATOR);
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + string + "'");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            string3 = stringArray[i];
            if (!string3.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + string + "': " + string3 + " doesn't start with " + ENCODE_PREFIX);
            }
            string3 = string3.substring(1);
            string2 = stringArray[i + 1];
            if (!string2.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + string + "': " + string2 + " doesn't start with " + ENCODE_PREFIX);
            }
            if (NULL_ENCODE.equals(string2 = string2.substring(1))) {
                string2 = null;
            }
            hashMap.put(string3, string2);
        }
        String string4 = (String)hashMap.remove("organisation");
        string3 = (String)hashMap.remove("module");
        string2 = (String)hashMap.remove("revision");
        String string5 = (String)hashMap.remove("branch");
        if (string4 == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + string + "': no organisation");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + string + "': no module name");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + string + "': no revision");
        }
        return ModuleRevisionId.newInstance(string4, string3, string5, string2, hashMap);
    }

    public String getBranch() {
        return this.branch;
    }

    private static String normalizeRevision(String string) {
        if (string.startsWith("[") && string.endsWith("]") && string.indexOf(44) == -1) {
            if (IvyPatternHelper.getTokenString("revision").equals(string)) {
                return string;
            }
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

