/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private static final String SERVICE = "KeyGenerator";
    private KeyGeneratorSpi kgSpi;
    private Provider provider;
    private String algorithm;

    public static final KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        String msg = algorithm;
        int i = 0;
        while (i < provs.length) {
            try {
                return KeyGenerator.getInstance(algorithm, provs[i]);
            }
            catch (NoSuchAlgorithmException nsae) {
                msg = nsae.getMessage();
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(msg);
    }

    public static final KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyGenerator.getInstance(algorithm, p);
    }

    public static final KeyGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new KeyGenerator((KeyGeneratorSpi)Engine.getInstance(SERVICE, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
            if (ite.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ite.getCause();
            }
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final SecretKey generateKey() {
        return this.kgSpi.engineGenerateKey();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.init(params, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.kgSpi.engineInit(params, random);
    }

    public final void init(int keySize) {
        this.init(keySize, new SecureRandom());
    }

    public final void init(int keySize, SecureRandom random) {
        this.kgSpi.engineInit(keySize, random);
    }

    public final void init(SecureRandom random) {
        this.kgSpi.engineInit(random);
    }

    protected KeyGenerator(KeyGeneratorSpi kgSpi, Provider provider, String algorithm) {
        this.kgSpi = kgSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }
}

