/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptConfigGraphCache;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigServiceImpl
implements TypeScriptConfigService {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptConfigService.class);
    private static final Function<PsiFile, TypeScriptConfig> MAP_TO_CONFIG = file2 -> {
        if (JSLibraryUtil.isProbableLibraryFile(file2.getVirtualFile())) {
            return null;
        }
        return TypeScriptConfigBase.getConfig(file2);
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<List<TypeScriptConfig>> myConfigs;
    private final CachedValue<ConcurrentIntObjectMap<ConcurrentIntObjectMap<Boolean>>> myFilesMappings;
    private final SimpleModificationTracker myTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;
    @NotNull
    private final TypeScriptConfigGraphCache myConfigGraphCache;
    private final Collection<TypeScriptConfigsChangedListener> myListeners;
    @NotNull
    private final PsiManager myManager;

    public TypeScriptConfigServiceImpl(@NotNull Project project, @Nullable TypeScriptConfigLibraryUpdater updater, @NotNull TypeScriptConfigGraphCache configGraphCache) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(0);
        }
        if (configGraphCache == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(1);
        }
        this.myTracker = new SimpleModificationTracker();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myUpdater = updater;
        this.myConfigGraphCache = configGraphCache;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        CachedValueProvider configsProvider = () -> (CachedValueProvider.Result)ReadAction.compute(() -> {
            this.beforeUpdate();
            Collection virtualFiles = FileTypeIndex.getFiles((FileType)TypeScriptConfigFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
            List files = virtualFiles.stream().sorted(Comparator.comparing(el -> el.getName())).map(el -> this.myManager.findFile(el)).filter(el -> el != null).collect(Collectors.toList());
            List configs = ContainerUtil.mapNotNull(files, MAP_TO_CONFIG);
            HashSet depends = ContainerUtil.newHashSet((int)(configs.size() + 1));
            depends.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            ContainerUtil.addAll((Collection)depends, files);
            this.addAdditionalDeps(configs, depends);
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)configs, (Collection)depends);
            this.afterUpdate(configs);
            return result2;
        });
        this.myConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(configsProvider, false);
        this.myFilesMappings = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentIntObjectSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    private void addAdditionalDeps(@NotNull Collection<TypeScriptConfig> configs, @NotNull Collection<Object> depends) {
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(2);
        }
        if (depends == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(3);
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        for (TypeScriptConfig config2 : configs) {
            VirtualFile virtualFile = config2.getConfigFile();
            for (VirtualFile file2 : config2.getDependencies()) {
                if (file2.equals(virtualFile)) continue;
                PsiFile psiFile = manager.findFile(file2);
                depends.add(psiFile != null ? psiFile : file2);
            }
        }
    }

    private void beforeUpdate() {
        this.myTracker.incModificationCount();
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isAccessible(@NotNull VirtualFile scope, @NotNull VirtualFile referenced) {
        int refId;
        Boolean value;
        ConcurrentIntObjectMap prevValue;
        int scopeId;
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(4);
        }
        if (referenced == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(5);
        }
        if (scope.equals(referenced)) {
            return true;
        }
        if (!this.isEnabled() || DumbService.isDumb((Project)this.myProject)) {
            return true;
        }
        if (!(scope instanceof VirtualFileWithId) || !(referenced instanceof VirtualFileWithId)) {
            return this.isAccessibleImpl(scope, referenced);
        }
        ConcurrentIntObjectMap filesRefsMap = (ConcurrentIntObjectMap)this.myFilesMappings.getValue();
        ConcurrentIntObjectMap scopeFileMap = (ConcurrentIntObjectMap)filesRefsMap.get(scopeId = ((VirtualFileWithId)scope).getId());
        if (scopeFileMap == null && (prevValue = (ConcurrentIntObjectMap)filesRefsMap.putIfAbsent(scopeId, (Object)(scopeFileMap = ContainerUtil.createConcurrentIntObjectMap()))) != null) {
            scopeFileMap = prevValue;
        }
        if ((value = (Boolean)scopeFileMap.get(refId = ((VirtualFileWithId)referenced).getId())) == null) {
            value = this.isAccessibleImpl(scope, referenced);
            scopeFileMap.put(refId, (Object)value);
        }
        return value;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAccessScope(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(7);
            }
            return condition;
        }
        TypeScriptConfigService.IntPredicate filterId = this.getFilterId(scope);
        Condition condition = candidate -> filterId.contains(TypeScriptImportGraph.getFileId(candidate));
        if (condition == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(8);
        }
        return condition;
    }

    @Override
    @NotNull
    public TypeScriptConfigService.IntPredicate getFilterId(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            TypeScriptConfigService.IntPredicate intPredicate = el -> false;
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(10);
            }
            return intPredicate;
        }
        List<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            TypeScriptConfigService.IntPredicate intPredicate = el -> true;
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(11);
            }
            return intPredicate;
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(this.myProject);
        Set<VirtualFile> bundledLibraries = service.getAllBundledLibraries();
        if (bundledLibraries.contains(scope)) {
            TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(scope);
            TypeScriptConfigService.IntPredicate intPredicate = el -> graph.containsId(el);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(12);
            }
            return intPredicate;
        }
        Set<VirtualFile> customLibraries = service.getAllCustomLibraries();
        if (customLibraries.contains(scope)) {
            TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(scope);
            TypeScriptConfigService.IntPredicate intPredicate = el -> graph.containsId(el);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(13);
            }
            return intPredicate;
        }
        Set<VirtualFile> librariesToProcess = !customLibraries.isEmpty() ? customLibraries : bundledLibraries;
        int[] ints = librariesToProcess.stream().mapToInt(TypeScriptImportGraph::getFileId).toArray();
        TIntHashSet libraries = new TIntHashSet(ints);
        Collection<TypeScriptImportGraph> graphs = this.getIncludeGraphs(scope);
        TypeScriptConfigService.IntPredicate intPredicate = id -> {
            if (libraries.contains(id)) {
                return true;
            }
            for (TypeScriptImportGraph graph : graphs) {
                if (!graph.containsId(id)) continue;
                return true;
            }
            return false;
        };
        if (intPredicate == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(14);
        }
        return intPredicate;
    }

    private boolean isAccessibleImpl(@NotNull VirtualFile scope, @NotNull VirtualFile file2) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(16);
        }
        return this.getAccessScope(scope).value((Object)file2);
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableConfig(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(17);
        }
        ArrayList configs = ContainerUtil.newArrayList(this.getConfigFiles());
        Collection<Object> preferableConfigs = TypeScriptConfigUtil.getNearestParentConfigs(scopeFile, configs);
        while (!preferableConfigs.isEmpty()) {
            Optional preferable = ((StreamEx)StreamEx.of(preferableConfigs).filter(el -> {
                if (scopeFile == null) {
                    TypeScriptConfigServiceImpl.$$$reportNull$$$0(38);
                }
                return this.myConfigGraphCache.isConfigInclude(scopeFile, (TypeScriptConfig)el);
            })).findFirst();
            if (preferable.isPresent()) {
                return (TypeScriptConfig)preferable.get();
            }
            configs.removeAll(preferableConfigs);
            preferableConfigs = TypeScriptConfigUtil.getNearestParentConfigs(scopeFile, configs);
            if (!preferableConfigs.isEmpty() || configs.isEmpty()) continue;
            preferableConfigs = configs;
        }
        return null;
    }

    @NotNull
    private Collection<TypeScriptImportGraph> getIncludeGraphs(@NotNull VirtualFile scopeFile) {
        Collection<TypeScriptImportGraph> graphs;
        List<TypeScriptConfig> configs;
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(18);
        }
        if ((configs = this.getConfigFiles()).isEmpty()) {
            TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(scopeFile);
            List list = ContainerUtil.createMaybeSingletonList((Object)graph);
            if (list == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        Collection<? extends TypeScriptConfig> preferableConfigs = TypeScriptConfigUtil.getNearestParentConfigs(scopeFile, configs);
        if (!preferableConfigs.isEmpty() && !(graphs = this.getIncludeGraphs(scopeFile, preferableConfigs)).isEmpty()) {
            Collection<TypeScriptImportGraph> collection = graphs;
            if (collection == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(20);
            }
            return collection;
        }
        Collection<TypeScriptImportGraph> collection = this.getIncludeGraphs(scopeFile, configs);
        if (collection == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    private Collection<TypeScriptImportGraph> getIncludeGraphs(@NotNull VirtualFile scopeFile, @NotNull Collection<? extends TypeScriptConfig> configs) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(22);
        }
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(23);
        }
        List graphs = StreamEx.of(configs).map(config2 -> this.myConfigGraphCache.getGraph((TypeScriptConfig)config2)).toList();
        for (TypeScriptImportGraph graph : graphs) {
            graph.initialize(true);
        }
        List list = ((StreamEx)StreamEx.of((Collection)graphs).filter(el -> {
            if (scopeFile == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(37);
            }
            return this.isGraphIncludeFile((TypeScriptImportGraph)el, scopeFile);
        })).toList();
        if (list == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    protected boolean isGraphIncludeFile(@NotNull TypeScriptImportGraph el, @NotNull VirtualFile scopeFile) {
        if (el == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(25);
        }
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(26);
        }
        return el.containsFile(scopeFile);
    }

    @Override
    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener listener2) {
        if (listener2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(27);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public boolean hasConfigs() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection configs = (Collection)this.myConfigs.getValue();
        return !configs.isEmpty();
    }

    @Override
    @Nullable
    public TypeScriptConfig parseConfigFile(@NotNull VirtualFile file2) {
        PsiFile psiFile;
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myConfigs.hasUpToDateValue()) {
            for (TypeScriptConfig config2 : (List)this.myConfigs.getValue()) {
                if (!file2.equals(config2.getConfigFile())) continue;
                return config2;
            }
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2)) != null) {
            return TypeScriptConfigBase.getConfig(psiFile);
        }
        return null;
    }

    private void afterUpdate(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(29);
        }
        if (this.myUpdater != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myUpdater.processConfigsDirectory(configs);
            } else {
                this.myUpdater.queueToUpdate();
            }
        }
        for (TypeScriptConfigsChangedListener listener2 : this.myListeners) {
            listener2.afterUpdate(configs);
        }
    }

    @Override
    @NotNull
    public ModificationTracker getTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myTracker;
        if (simpleModificationTracker == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(30);
        }
        return simpleModificationTracker;
    }

    @Override
    public boolean isImplicitIncludedNodeModulesFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull VirtualFile topDirectory) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(31);
        }
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(32);
        }
        if (topDirectory == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(33);
        }
        if ("@types".contentEquals(topDirectory.getNameSequence())) {
            return true;
        }
        PsiFile psiFile = this.myManager.findFile(file2);
        if (!(psiFile instanceof JSFile) || ((JSFile)psiFile).isCommonJSModule()) {
            return true;
        }
        VirtualFile result2 = JSExactFileReference.resolveForNpmPackages(topDirectory, (NodeModuleDirectorySearchProcessor)new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project));
        return file2.equals(result2);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(34);
        }
        TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(file2);
        Collection collection = graph.getNodes();
        if (collection == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<TypeScriptConfig> getConfigFiles() {
        List value = (List)this.myConfigs.getValue();
        List list = value == null ? ContainerUtil.emptyList() : value;
        if (list == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(36);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 30: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 30: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configGraphCache";
                break;
            }
            case 2: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depends";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 30: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 16: 
            case 28: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 18: 
            case 22: 
            case 26: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessScope";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterId";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeGraphs";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedFiles";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalDeps";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessScope";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 30: 
            case 35: 
            case 36: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFilterId";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableConfig";
                break;
            }
            case 18: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeGraphs";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isGraphIncludeFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "afterUpdate";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitIncludedNodeModulesFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getIncludeGraphs$15";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPreferableConfig$13";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 30: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

