/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLookupElementRenderer
extends LookupElementRenderer<LookupElement>
implements JSLookupUtilImpl.IBoldnessProvidingLookupElementRenderer {
    private final String myName;
    private final JSLookupPriority myPriority;
    private final boolean myEcma;
    private final boolean myIsBold;
    @Nullable
    private final Couple<String> myTypeAndTail;

    public JSLookupElementRenderer(String name, @Nullable PsiElement element, @Nullable JSLookupPriority priority, boolean ecma, boolean isBold, JSTypeSubstitutor typeSubstitutor) {
        this(name, priority, ecma, isBold, element == null ? null : JSLookupUtilImpl.getTypeAndTailTexts(element, typeSubstitutor));
    }

    public JSLookupElementRenderer(@NotNull String name, @Nullable JSLookupPriority priority, boolean ecma, boolean isBold, @Nullable Couple<String> typeAndTail) {
        if (name == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myPriority = priority;
        this.myEcma = ecma;
        this.myIsBold = isBold;
        this.myTypeAndTail = typeAndTail;
    }

    public void renderElement(LookupElement element, LookupElementPresentation presentation) {
        if (presentation instanceof JSLookupUtilImpl.BoldCheckingLookupElementPresentation) {
            presentation.setItemTextBold(this.myIsBold);
            ((JSLookupUtilImpl.BoldCheckingLookupElementPresentation)presentation).setUseRenderer(this);
            return;
        }
        PsiElement value = JSLookupElementRenderer.getValidElement(element);
        presentation.setItemText(JSUtils.isPrivateSharpItem(value) ? "#" + this.myName : this.myName);
        boolean real = presentation.isReal();
        if (this.myPriority.compareTo(JSLookupPriority.MAX_PRIORITY) >= 0 || real) {
            presentation.setIcon(real ? JSLookupUtilImpl.getIcon(value, this.myEcma) : JSLookupUtilImpl.IconHolder.ourEmptyIconWithVisibility);
            if (real) {
                presentation.setStrikeout(JSDocumentationUtils.isDeprecated(value));
            }
            presentation.setItemTextBold(this.myIsBold);
            if (this.myTypeAndTail != null) {
                presentation.setTypeText((String)this.myTypeAndTail.first);
                presentation.setTailText((String)this.myTypeAndTail.second, false);
            }
        }
    }

    @Nullable
    private static PsiElement getValidElement(@NotNull LookupElement element) {
        PsiElement value;
        if (element == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(1);
        }
        if ((value = element.getPsiElement()) != null && !value.isValid()) {
            value = null;
        }
        return value;
    }

    @Override
    public LookupElementRenderer<LookupElement> copyWithBoldness(boolean bold) {
        if (this.myIsBold == bold) {
            return this;
        }
        return new JSLookupElementRenderer(this.myName, this.myPriority, this.myEcma, bold, this.myTypeAndTail);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSLookupElementRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

