/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.liveTemplates.JSLikeTemplateContextType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptCodeContextType
extends TemplateContextType
implements JSLikeTemplateContextType {
    @NonNls
    private static final String JAVA_SCRIPT = "JAVA_SCRIPT";

    public JavaScriptCodeContextType() {
        super(JAVA_SCRIPT, JSBundle.message((String)"javascript.template.context.type", (Object[])new Object[0]));
    }

    public boolean isInContext(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            JavaScriptCodeContextType.$$$reportNull$$$0(0);
        }
        return JavaScriptCodeContextType.areJavaScriptTemplatesApplicable(file2.findElementAt(offset));
    }

    public SyntaxHighlighter createHighlighter() {
        return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, null, null);
    }

    @Contract(value="null -> false")
    public static boolean areJavaScriptTemplatesApplicable(@Nullable PsiElement at) {
        if (at == null) {
            return false;
        }
        Language language = JSLanguageUtil.getLanguage(at);
        if (!(language instanceof JSLanguageDialect)) {
            return language == JavascriptLanguage.INSTANCE;
        }
        DialectOptionHolder optionHolder = ((JSLanguageDialect)language).getOptionHolder();
        return optionHolder.isJavaScript() || optionHolder.isTypeScript || optionHolder.isECMA6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JavaScriptCodeContextType", "isInContext"));
    }
}

