/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.netty;

import com.github.dockerjava.api.async.ResultCallback;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class AsyncResultCallbackCopy<A_RES_T>
implements ResultCallback<A_RES_T> {
    private A_RES_T result = null;
    private final CountDownLatch resultReady = new CountDownLatch(1);
    private Closeable stream;
    private boolean closed = false;
    private Throwable firstError = null;

    public void onStart(Closeable stream) {
        this.stream = stream;
        this.closed = false;
    }

    public void onNext(A_RES_T object) {
        this.onResult(object);
    }

    private void onResult(A_RES_T object) {
        if (this.resultReady.getCount() == 0L) {
            throw new IllegalStateException("Result has already been set");
        }
        try {
            this.result = object;
        }
        finally {
            this.resultReady.countDown();
        }
    }

    public void onError(Throwable throwable) {
        if (this.closed) {
            return;
        }
        if (this.firstError == null) {
            this.firstError = throwable;
        }
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onComplete() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        try {
            this.closed = true;
            if (this.stream != null) {
                this.stream.close();
            }
        }
        finally {
            this.resultReady.countDown();
        }
    }

    public A_RES_T awaitResult() {
        try {
            this.resultReady.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.rethrowFirstError();
        return this.result;
    }

    private void rethrowFirstError() {
        if (this.firstError != null) {
            throw Throwables.propagate((Throwable)this.firstError);
        }
    }
}

