/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteFile;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteProcessUtil {
    public static Pair<String[], String> buildRemoteCommandLine(@NotNull AbstractPathMapper pathMapper, @NotNull String[] command, @Nullable String workingDir, @NotNull String interpreterPath) {
        if (pathMapper == null) {
            RemoteProcessUtil.$$$reportNull$$$0(0);
        }
        if (command == null) {
            RemoteProcessUtil.$$$reportNull$$$0(1);
        }
        if (interpreterPath == null) {
            RemoteProcessUtil.$$$reportNull$$$0(2);
        }
        command = Arrays.copyOf(command, command.length);
        for (int i = 0; i < command.length; ++i) {
            if (pathMapper.canReplaceLocal(command[i])) {
                command[i] = RemoteFile.detectSystemByPath((String)interpreterPath).createRemoteFile(pathMapper.convertToRemote(command[i])).getPath();
            }
            if (!RemoteProcessUtil.isPathList(command[i])) continue;
            command[i] = RemoteProcessUtil.remapPathsList(command[i], (PathMapper)pathMapper, interpreterPath);
        }
        command[1] = pathMapper.convertToRemote(command[1]);
        command[0] = interpreterPath;
        return Pair.create((Object)command, (Object)RemoteProcessUtil.toRemoteFileSystemStyle(workingDir));
    }

    @Contract(value="null -> null")
    public static String toRemoteFileSystemStyle(@Nullable String path) {
        if (path == null) {
            return null;
        }
        return RemoteFile.detectSystemByPath((String)path).createRemoteFile(path).getPath();
    }

    public static String[] buildRemoteCommand(@NotNull AbstractPathMapper pathMapper, @NotNull Collection<String> commands) {
        if (pathMapper == null) {
            RemoteProcessUtil.$$$reportNull$$$0(3);
        }
        if (commands == null) {
            RemoteProcessUtil.$$$reportNull$$$0(4);
        }
        return ArrayUtil.toStringArray((Collection)pathMapper.convertToRemote(commands));
    }

    @NotNull
    public static String remapPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        if (pathsValue == null) {
            RemoteProcessUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            RemoteProcessUtil.$$$reportNull$$$0(6);
        }
        if (interpreterPath == null) {
            RemoteProcessUtil.$$$reportNull$$$0(7);
        }
        boolean isWin = RemoteFile.isWindowsPath((String)interpreterPath);
        ArrayList paths = Lists.newArrayList((Object[])pathsValue.split(File.pathSeparator));
        ArrayList mappedPaths = Lists.newArrayList();
        for (String path : paths) {
            mappedPaths.add(new RemoteFile(pathMapper.convertToRemote(path), isWin).getPath());
        }
        String string = Joiner.on((char)(isWin ? (char)';' : ':')).join((Iterable)mappedPaths);
        if (string == null) {
            RemoteProcessUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean isPathList(String value) {
        ArrayList paths = Lists.newArrayList((Object[])value.split(File.pathSeparator));
        if (paths.size() > 1) {
            for (String p : paths) {
                if (!new File(p).exists()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteProcessUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteProcessUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "remapPathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildRemoteCommandLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildRemoteCommand";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remapPathsList";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

