/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopySettingsPathAction
extends DumbAwareAction {
    public CopySettingsPathAction() {
        super(CopySettingsPathAction.getName(), ActionsBundle.message((String)"action.CopySettingsPath.description", (Object[])new Object[0]), null);
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CopySettingsPathAction.$$$reportNull$$$0(0);
        }
        Component component = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        SettingsEditor editor = (SettingsEditor)UIUtil.getParentOfType(SettingsEditor.class, (Component)component);
        event.getPresentation().setEnabledAndVisible(editor != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Collection<String> names;
        SettingsTreeView view;
        Component component;
        if (event == null) {
            CopySettingsPathAction.$$$reportNull$$$0(1);
        }
        if ((component = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof JTree && (view = (SettingsTreeView)UIUtil.getParentOfType(SettingsTreeView.class, (Component)component)) != null) {
            CopySettingsPathAction.copy(view.createTransferable(event.getInputEvent()));
            return;
        }
        SettingsEditor editor = (SettingsEditor)UIUtil.getParentOfType(SettingsEditor.class, (Component)component);
        Collection<String> collection = names = editor == null ? null : editor.getPathNames();
        if (names == null || names.isEmpty()) {
            return;
        }
        ConfigurableEditor inner = (ConfigurableEditor)UIUtil.getParentOfType(ConfigurableEditor.class, (Component)component);
        if (inner != null) {
            String label2 = CopySettingsPathAction.getTextLabel(component);
            ArrayDeque<String> path = new ArrayDeque<String>();
            while (component != null && component != inner) {
                TitledBorder tb;
                String title;
                JComponent c;
                Border border;
                JBTabs tabs2;
                TabInfo info;
                if (component instanceof JBTabs && (info = (tabs2 = (JBTabs)component).getSelectedInfo()) != null) {
                    path.addFirst(info.getText());
                }
                if (component instanceof JTabbedPane) {
                    JTabbedPane pane = (JTabbedPane)component;
                    int index = pane.getSelectedIndex();
                    path.addFirst(pane.getTitleAt(index));
                }
                if (component instanceof JComponent && (border = (c = (JComponent)component).getBorder()) instanceof TitledBorder && (title = (tb = (TitledBorder)border).getTitle()) != null && !title.isEmpty()) {
                    path.addFirst(title);
                }
                component = component.getParent();
            }
            names.addAll(path);
            if (label2 != null) {
                names.add(label2);
            }
        }
        CopySettingsPathAction.copy(CopySettingsPathAction.createTransferable(names));
    }

    @NotNull
    private static String getName() {
        String string = ActionsBundle.message((String)(SystemInfo.isMac ? "action.CopySettingsPath.mac.text" : "action.CopySettingsPath.text"), (Object[])new Object[0]);
        if (string == null) {
            CopySettingsPathAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    static Action createSwingAction(final @NotNull Supplier<? extends Transferable> supplier) {
        if (supplier == null) {
            CopySettingsPathAction.$$$reportNull$$$0(3);
        }
        AbstractAction action = new AbstractAction(CopySettingsPathAction.getName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                CopySettingsPathAction.copy((Transferable)supplier.get());
            }
        };
        KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("CopySettingsPath");
        if (shortcut != null) {
            action.putValue("AcceleratorKey", shortcut.getFirstKeyStroke());
        }
        AbstractAction abstractAction = action;
        if (abstractAction == null) {
            CopySettingsPathAction.$$$reportNull$$$0(4);
        }
        return abstractAction;
    }

    @Nullable
    static Transferable createTransferable(@Nullable Collection<String> names) {
        if (names == null || names.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(SystemInfo.isMac ? "Preferences" : "File | Settings");
        for (String object : names) {
            sb.append(" | ").append(object);
        }
        return new TextTransferable(sb.toString());
    }

    static boolean copy(@Nullable Transferable transferable) {
        if (transferable == null) {
            return false;
        }
        CopyPasteManager.getInstance().setContents(transferable);
        return true;
    }

    private static String getTextLabel(Object component) {
        JToggleButton button;
        String text;
        if (component instanceof JToggleButton && (text = (button = (JToggleButton)component).getText()) != null && !text.isEmpty()) {
            return text;
        }
        if (component instanceof JLabel) {
            JLabel label2 = (JLabel)component;
            text = label2.getText();
            if (text != null && !text.isEmpty()) {
                return text;
            }
        } else if (component instanceof JComponent) {
            JComponent c = (JComponent)component;
            return CopySettingsPathAction.getTextLabel(c.getClientProperty("labeledBy"));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/CopySettingsPathAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/CopySettingsPathAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwingAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSwingAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

