/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.dialects.mysql.dataFlow.MysqlErrorSpecHelper;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlShowStatementImpl;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractVariableHelper;
import com.intellij.sql.dialects.sql92.Sql92ReservedKeywords;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlDialectBase
extends SqlLanguageDialectEx {
    public MysqlDialectBase(String id) {
        super(id);
    }

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, "Geometry", "geometry", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "JSON", "json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Point", "point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Curve", "curve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "LineString", "linestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Line", "line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "LinearRing", "linearring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Surface", "surface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Polygon", "polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "GeometryCollection", "geometrycollection", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiPoint", "multipoint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiCurve", "multicurve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiLineString", "Multilinestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiSurface", "multisurface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiPolygon", "multipolygon", (SqlLanguageDialectEx)this);
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            MysqlDialectBase.$$$reportNull$$$0(0);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            MysqlDialectBase.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            MysqlDialectBase.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MysqlDialectBase.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        MysqlShowStatementImpl showStatement;
        Pair<IElementType, IElementType> type;
        ReservedEntity.Typed[] cols;
        if (element2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            MysqlDialectBase.$$$reportNull$$$0(5);
        }
        if (!MysqlDialectBase.processReservedEntitiesWithTypeDual(name, element2, resolve, processor)) {
            return false;
        }
        SqlStatement stmt = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
        if (stmt instanceof MysqlShowStatementImpl && (cols = LazyData.RE_SHOW_COLUMNS_BY_TYPE.get(type = (showStatement = (MysqlShowStatementImpl)stmt).getShowType())) != null) {
            for (ReservedEntity.Typed col : cols) {
                if (MysqlDialectBase.processReservedEntitiesWithTypeSimple(col, col.type, name, element2, resolve, processor, true, false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name, element2, resolve, processor);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = MysqlDialectBase.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                MysqlDialectBase.$$$reportNull$$$0(6);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, false);
        if (treePattern == null) {
            MysqlDialectBase.$$$reportNull$$$0(7);
        }
        return treePattern;
    }

    @Override
    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        if (column2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(8);
        }
        if (super.isAutoIncrementColumn(column2)) {
            return true;
        }
        String type = column2.getDataType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @Override
    @NotNull
    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(9);
        }
        String result2 = null;
        if (offset > 0) {
            for (MysqlDelimiterStatementImpl delimiter : SqlImplUtil.iterateStatementsBackward((PsiFile)file, offset).filter(MysqlDelimiterStatementImpl.class)) {
                if (delimiter.getDelimiter() == null) continue;
                result2 = delimiter.getDelimiter();
                break;
            }
        }
        if (result2 == null) {
            String string = super.getDelimiterAt(file, offset);
            if (string == null) {
                MysqlDialectBase.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            MysqlDialectBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new MysqlExtractVariableHelper();
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(12);
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element2) {
        if (element2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(13);
        }
        return element2 == SqlCompositeElementTypes.SQL_STRING_LITERAL || element2 == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element2 == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            MysqlDialectBase.$$$reportNull$$$0(14);
        }
        return kind == ObjectKind.TRIGGER;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            MysqlDialectBase.$$$reportNull$$$0(15);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "tinyint";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "binary";
            }
            case ARRAY: {
                return "binary";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            MysqlDialectBase.$$$reportNull$$$0(16);
        }
        name = super.getNormalizedTypeName(name);
        name = StringUtil.trimStart((String)name, (String)"national ");
        name = StringUtil.trimEnd((String)name, (String)" zerofill");
        name = StringUtil.trimEnd((String)name, (String)" signed");
        if ((name = StringUtil.trimEnd((String)name, (String)" unsigned")).equals("nchar varying")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(17);
            }
            return "varchar";
        }
        if (name.equals("nvarchar")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(18);
            }
            return "varchar";
        }
        if (name.equals("nchar")) {
            if ("char" == null) {
                MysqlDialectBase.$$$reportNull$$$0(19);
            }
            return "char";
        }
        if (name.equals("character varying")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(20);
            }
            return "varchar";
        }
        if (name.equals("char varying")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(21);
            }
            return "varchar";
        }
        if (name.equals("character")) {
            if ("char" == null) {
                MysqlDialectBase.$$$reportNull$$$0(22);
            }
            return "char";
        }
        if (name.equals("long")) {
            if ("mediumtext" == null) {
                MysqlDialectBase.$$$reportNull$$$0(23);
            }
            return "mediumtext";
        }
        if (name.equals("integer")) {
            if ("int" == null) {
                MysqlDialectBase.$$$reportNull$$$0(24);
            }
            return "int";
        }
        if (name.equals("boolean")) {
            if ("tinyint" == null) {
                MysqlDialectBase.$$$reportNull$$$0(25);
            }
            return "tinyint";
        }
        if (name.equals("bool")) {
            if ("tinyint" == null) {
                MysqlDialectBase.$$$reportNull$$$0(26);
            }
            return "tinyint";
        }
        if (name.equals("dec")) {
            if ("decimal" == null) {
                MysqlDialectBase.$$$reportNull$$$0(27);
            }
            return "decimal";
        }
        if (name.equals("numeric")) {
            if ("decimal" == null) {
                MysqlDialectBase.$$$reportNull$$$0(28);
            }
            return "decimal";
        }
        if (name.equals("fixed")) {
            if ("decimal" == null) {
                MysqlDialectBase.$$$reportNull$$$0(29);
            }
            return "decimal";
        }
        if (name.equals("double precision")) {
            if ("double" == null) {
                MysqlDialectBase.$$$reportNull$$$0(30);
            }
            return "double";
        }
        if (name.equals("real")) {
            if ("double" == null) {
                MysqlDialectBase.$$$reportNull$$$0(31);
            }
            return "double";
        }
        String string = name;
        if (string == null) {
            MysqlDialectBase.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            MysqlDialectBase.$$$reportNull$$$0(33);
        }
        if (state == null) {
            MysqlDialectBase.$$$reportNull$$$0(34);
        }
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(35);
        }
        if (processor.isExpected(MysqlElementTypes.Extra.USER_VARIABLE)) {
            SqlFileImpl sqlFile;
            PsiFile file = ref.getElement().getContainingFile();
            if (file != null) {
                file = (PsiFile)ObjectUtils.chooseNotNull((Object)file.getOriginalFile(), (Object)file);
            }
            if ((sqlFile = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)file, SqlFileImpl.class))) != null) {
                for (SqlReferenceExpression expression : MysqlDialectBase.getGlobalVariables(sqlFile)) {
                    if (processor.execute((PsiElement)expression, state)) continue;
                    return false;
                }
            }
            if (processor.referenceName != null && !processor.isExpected(SqlDbElementType.ANY)) {
                return false;
            }
        }
        return super.processUnqualifiedResolve(processor, state, ref);
    }

    @Override
    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        MysqlErrorSpecHelper mysqlErrorSpecHelper = MysqlErrorSpecHelper.INSTANCE;
        if (mysqlErrorSpecHelper == null) {
            MysqlDialectBase.$$$reportNull$$$0(36);
        }
        return mysqlErrorSpecHelper;
    }

    @NotNull
    public static List<SqlReferenceExpression> getGlobalVariables(@NotNull SqlFile file) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(37);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                MysqlDialectBase.$$$reportNull$$$0(42);
            }
            return CachedValueProvider.Result.create(MysqlDialectBase.calcGlobalVariables((SqlFileImpl)file), (Object[])new Object[]{file});
        });
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    private static List<SqlReferenceExpression> calcGlobalVariables(SqlFileImpl file) {
        SqlLanguageDialectEx language = file.getSqlLanguage();
        if (!language.getDbms().isMysql() || file.getStub() != null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                MysqlDialectBase.$$$reportNull$$$0(39);
            }
            return list;
        }
        HashMap gradedVariables = ContainerUtil.newHashMap();
        for (SqlReferenceExpression ref : SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlReferenceExpression.class)) {
            String prefix;
            if (ref.getReferenceElementType() != MysqlElementTypes.Extra.MYSQL_USER_VARIABLE_REFERENCE) continue;
            SqlIdentifier identifier = ref.getIdentifier();
            String string = prefix = identifier == null ? null : identifier.getNamePrefix();
            if (!language.isVariablePrefix(prefix)) continue;
            int grade = MysqlDialectBase.getVariableReferenceGrade(ref);
            String name = ref.getName();
            Pair old = (Pair)gradedVariables.get(name);
            if (old != null && grade >= (Integer)old.second) continue;
            gradedVariables.put(name, Pair.create((Object)ref, (Object)grade));
        }
        List list = ContainerUtil.map2List(gradedVariables.values(), val -> (SqlReferenceExpression)val.first);
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static int getVariableReferenceGrade(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(41);
        }
        int grade = 0;
        boolean insideRoutine = PsiTreeUtil.getParentOfType((PsiElement)ref, SqlCreateProcedureStatement.class) != null;
        SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlSetAssignment.class);
        if (assignment != null && assignment.getLValue() == ref) {
            return insideRoutine ? grade + 1 : grade;
        }
        grade += 2;
        SqlBinaryExpression expr = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlBinaryExpression.class);
        if (expr != null && expr.getLOperand() == ref && (expr.getOpSign() == SqlCommonTokens.SQL_OP_ASSIGN || expr.getOpSign() == SqlCommonTokens.SQL_OP_EQ)) {
            return insideRoutine ? grade + 1 : grade;
        }
        return insideRoutine ? grade + 1 : (grade += 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalVariables";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGlobalVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalVariables";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferenceGrade";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGlobalVariables$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final MysqlDialectBase INSTANCE = MysqlDialect.INSTANCE;
        static final TokenClasses ourClasses = new TokenClasses(MysqlTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final TokenSet ourClosingTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final Map<Pair<IElementType, IElementType>, ReservedEntity.Typed[]> RE_SHOW_COLUMNS_BY_TYPE;
        private static final EnterHandlerDelegate ENTER_HANDLER;

        LazyData() {
        }

        private static ReservedEntity.Typed[] cols(ReservedEntity.Typed ... entities) {
            return entities;
        }

        private static ReservedEntity.Typed col(@NotNull String name, @NotNull SqlType type) {
            if (name == null) {
                LazyData.$$$reportNull$$$0(0);
            }
            if (type == null) {
                LazyData.$$$reportNull$$$0(1);
            }
            return new ReservedEntity.Typed(name, ObjectKind.COLUMN, type);
        }

        private static Pair<IElementType, IElementType> type(IElementType f, IElementType s) {
            return Pair.create((Object)f, (Object)s);
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN})});
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_CONCAT, SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_COLLATE, SqlCommonKeywords.SQL_IN, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_INVERT, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.SQL_OP_LOGICAL_OR, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_LEFT_SHIFT, SqlCommonTokens.SQL_OP_RIGHT_SHIFT, SqlCommonTokens.SQL_OP_MODULO, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_NOT2, SqlCommonTokens.SQL_OP_ASSIGN, MysqlReservedKeywords.MYSQL_REGEXP, MysqlReservedKeywords.MYSQL_RLIKE, MysqlOptionalKeywords.MYSQL_SOUNDS, MysqlReservedKeywords.MYSQL_DIV, MysqlReservedKeywords.MYSQL_MOD, MysqlReservedKeywords.MYSQL_XOR, MysqlReservedKeywords.MYSQL_BINARY});
            RE_SHOW_COLUMNS_BY_TYPE = ContainerUtil.immutableMapBuilder().put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_CHARACTER, null), (Object)LazyData.cols(LazyData.col("Charset", LazyData.INSTANCE.stringType()), LazyData.col("Description", LazyData.INSTANCE.stringType()), LazyData.col("Default collation", LazyData.INSTANCE.stringType()), LazyData.col("Maxlen", LazyData.INSTANCE.integerType()))).put(LazyData.type((IElementType)Sql92ReservedKeywords.SQL_COLLATION, null), (Object)LazyData.cols(LazyData.col("Collation", LazyData.INSTANCE.stringType()), LazyData.col("Charset", LazyData.INSTANCE.stringType()), LazyData.col("Id", LazyData.INSTANCE.integerType()), LazyData.col("Default", LazyData.INSTANCE.stringType()), LazyData.col("Compiled", LazyData.INSTANCE.stringType()), LazyData.col("Sortlen", LazyData.INSTANCE.integerType()))).put(LazyData.type(MysqlTypes.MYSQL_COLUMNS, null), (Object)LazyData.cols(LazyData.col("Field", LazyData.INSTANCE.stringType()), LazyData.col("Type", LazyData.INSTANCE.stringType()), LazyData.col("Null", LazyData.INSTANCE.stringType()), LazyData.col("Default", LazyData.INSTANCE.stringType()), LazyData.col("Extra", LazyData.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_FULL, MysqlTypes.MYSQL_COLUMNS), (Object)LazyData.cols(LazyData.col("Field", LazyData.INSTANCE.stringType()), LazyData.col("Type", LazyData.INSTANCE.stringType()), LazyData.col("Collation", LazyData.INSTANCE.stringType()), LazyData.col("Null", LazyData.INSTANCE.stringType()), LazyData.col("Key", LazyData.INSTANCE.stringType()), LazyData.col("Default", LazyData.INSTANCE.stringType()), LazyData.col("Extra", LazyData.INSTANCE.stringType()), LazyData.col("Privileges", LazyData.INSTANCE.stringType()), LazyData.col("Comment", LazyData.INSTANCE.stringType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_DATABASES, null), (Object)LazyData.cols(LazyData.col("database", LazyData.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_EVENTS, null), (Object)LazyData.cols(LazyData.col("Db", LazyData.INSTANCE.stringType()), LazyData.col("Name", LazyData.INSTANCE.stringType()), LazyData.col("Definer", LazyData.INSTANCE.stringType()), LazyData.col("Time Zone", LazyData.INSTANCE.stringType()), LazyData.col("Type", LazyData.INSTANCE.stringType()), LazyData.col("Execute At", LazyData.INSTANCE.dateTimeType()), LazyData.col("Interval Value", LazyData.INSTANCE.stringType()), LazyData.col("Interval Field", LazyData.INSTANCE.stringType()), LazyData.col("Starts", LazyData.INSTANCE.dateTimeType()), LazyData.col("Ends", LazyData.INSTANCE.dateTimeType()), LazyData.col("Status", LazyData.INSTANCE.stringType()), LazyData.col("Originator", LazyData.INSTANCE.stringType()), LazyData.col("character_set_client", LazyData.INSTANCE.stringType()), LazyData.col("collation_connection", LazyData.INSTANCE.stringType()), LazyData.col("Database Collation", LazyData.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_FUNCTION, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", LazyData.INSTANCE.stringType()), LazyData.col("Name", LazyData.INSTANCE.stringType()), LazyData.col("Type", LazyData.INSTANCE.stringType()), LazyData.col("Definer", LazyData.INSTANCE.stringType()), LazyData.col("Modified", LazyData.INSTANCE.dateTimeType()), LazyData.col("Created", LazyData.INSTANCE.dateTimeType()), LazyData.col("Security_type", LazyData.INSTANCE.stringType()), LazyData.col("Comment", LazyData.INSTANCE.stringType()), LazyData.col("character_set_client", LazyData.INSTANCE.stringType()), LazyData.col("collation_connection", LazyData.INSTANCE.stringType()), LazyData.col("Database Collation", LazyData.INSTANCE.stringType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_INDEX, null), (Object)LazyData.cols(LazyData.col("Table", LazyData.INSTANCE.stringType()), LazyData.col("Non_unique", LazyData.INSTANCE.integerType()), LazyData.col("Key_name", LazyData.INSTANCE.stringType()), LazyData.col("Seq_in_index", LazyData.INSTANCE.integerType()), LazyData.col("Column_name", LazyData.INSTANCE.stringType()), LazyData.col("Collation", LazyData.INSTANCE.stringType()), LazyData.col("Cardinality", LazyData.INSTANCE.integerType()), LazyData.col("Sub_part", LazyData.INSTANCE.integerType()), LazyData.col("Packed", LazyData.INSTANCE.stringType()), LazyData.col("Null", LazyData.INSTANCE.stringType()), LazyData.col("Index_type", LazyData.INSTANCE.stringType()), LazyData.col("Comment", LazyData.INSTANCE.stringType()), LazyData.col("Index_comment", LazyData.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_TABLES), (Object)LazyData.cols(LazyData.col("Database", LazyData.INSTANCE.stringType()), LazyData.col("Table", LazyData.INSTANCE.stringType()), LazyData.col("In_use", LazyData.INSTANCE.integerType()), LazyData.col("Name_locked", LazyData.INSTANCE.integerType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_PROCEDURE, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", LazyData.INSTANCE.stringType()), LazyData.col("Name", LazyData.INSTANCE.stringType()), LazyData.col("Type", LazyData.INSTANCE.stringType()), LazyData.col("Definer", LazyData.INSTANCE.stringType()), LazyData.col("Modified", LazyData.INSTANCE.dateTimeType()), LazyData.col("Created", LazyData.INSTANCE.dateTimeType()), LazyData.col("Security_type", LazyData.INSTANCE.stringType()), LazyData.col("Comment", LazyData.INSTANCE.stringType()), LazyData.col("character_set_client", LazyData.INSTANCE.stringType()), LazyData.col("collation_connection", LazyData.INSTANCE.stringType()), LazyData.col("Database Collation", LazyData.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_STATUS, null), (Object)LazyData.cols(LazyData.col("Variable_name", LazyData.INSTANCE.stringType()), LazyData.col("Value", LazyData.INSTANCE.integerType()))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_TABLE, null), (Object)LazyData.cols(LazyData.col("Name", LazyData.INSTANCE.stringType()), LazyData.col("Engine", LazyData.INSTANCE.stringType()), LazyData.col("Version", LazyData.INSTANCE.integerType()), LazyData.col("Row_format", LazyData.INSTANCE.stringType()), LazyData.col("Rows", LazyData.INSTANCE.integerType()), LazyData.col("Avg_row_length", LazyData.INSTANCE.integerType()), LazyData.col("Data_length", LazyData.INSTANCE.integerType()), LazyData.col("Max_data_length", LazyData.INSTANCE.integerType()), LazyData.col("Index_length", LazyData.INSTANCE.integerType()), LazyData.col("Data_free", LazyData.INSTANCE.integerType()), LazyData.col("Auto_increment", LazyData.INSTANCE.integerType()), LazyData.col("Create_time", LazyData.INSTANCE.dateTimeType()), LazyData.col("Update_time", LazyData.INSTANCE.dateTimeType()), LazyData.col("Check_time", LazyData.INSTANCE.dateTimeType()), LazyData.col("Collation", LazyData.INSTANCE.stringType()), LazyData.col("Checksum", LazyData.INSTANCE.integerType()), LazyData.col("Create_options", LazyData.INSTANCE.stringType()), LazyData.col("Comment", LazyData.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_TRIGGERS, null), (Object)LazyData.cols(LazyData.col("Trigger", LazyData.INSTANCE.stringType()), LazyData.col("Event", LazyData.INSTANCE.stringType()), LazyData.col("Table", LazyData.INSTANCE.stringType()), LazyData.col("Statement", LazyData.INSTANCE.stringType()), LazyData.col("Timing", LazyData.INSTANCE.stringType()), LazyData.col("Created", LazyData.INSTANCE.dateTimeType()), LazyData.col("sql_mode", LazyData.INSTANCE.stringType()), LazyData.col("Definer", LazyData.INSTANCE.stringType()), LazyData.col("character_set_client", LazyData.INSTANCE.stringType()), LazyData.col("collation_connection", LazyData.INSTANCE.stringType()), LazyData.col("Database Collation", LazyData.INSTANCE.stringType()))).put(LazyData.type(MysqlTypes.MYSQL_VARIABLES, null), (Object)LazyData.cols(LazyData.col("Variable_name", LazyData.INSTANCE.stringType()), LazyData.col("Value", LazyData.INSTANCE.stringType()))).build();
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_LOOP}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_IF}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlTypes.MYSQL_DO, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_WHILE}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT, SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/dialects/mysql/MysqlDialectBase$LazyData";
            objectArray[2] = "col";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

