/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final OracleDialect INSTANCE = new OracleDialect();

    protected OracleDialect() {
        super(new TypeHelper.OracleTypeHelper(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OracleDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            OracleDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Oracle" == null) {
            OracleDialect.$$$reportNull$$$0(2);
        }
        return "Oracle";
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            OracleDialect.$$$reportNull$$$0(3);
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nvarchar2")) {
            return -9;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nchar")) {
            return -15;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nclob")) {
            return 2011;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).startsWith("TIMESTAMP")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsSynonymDefinition() {
        return true;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(4);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 1, true);
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsAlterAutoIncrement() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(5);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SYNONYM', '" + element2.getName() + "', '" + DasUtil.getSchema((DasObject)element2) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable table, DatabaseConnection connection2) throws Exception {
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlSynonymDefinition((DasObject)table);
        Dbms dbms = connection2.getDbms();
        String string = DbImplUtil.concatStringResults(connection2, dbms, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(8);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('TABLE', '" + element2.getName() + "', '" + DasUtil.getSchema((DasObject)element2) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(10);
        }
        if (connection2 == null) {
            OracleDialect.$$$reportNull$$$0(11);
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection2, dbms, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(13);
        }
        if (connection2 == null) {
            OracleDialect.$$$reportNull$$$0(14);
        }
        Dbms dbms = connection2.getDbms();
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection2, String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element2), true, dbms), DbImplUtil.escapeSql(element2.getName(), true, dbms)), new String[0]);
        if (map == null) {
            OracleDialect.$$$reportNull$$$0(15);
        }
        return map;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            OracleDialect.$$$reportNull$$$0(16);
        }
        if (connection2 == null) {
            OracleDialect.$$$reportNull$$$0(17);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection2, dbms = connection2.getDbms(), "select sys_context('userenv', 'current_schema') x from dual", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            OracleDialect.$$$reportNull$$$0(18);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("alter session set current_schema = %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            OracleDialect.$$$reportNull$$$0(19);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                OracleDialect.$$$reportNull$$$0(20);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("NUMBER".equals(typeName)) {
            String string = "number" + (precision == 0 && scale == -127 ? "" : "(" + precision + (scale == 0 ? "" : ", " + scale) + ")");
            if (string == null) {
                OracleDialect.$$$reportNull$$$0(21);
            }
            return string;
        }
        if ("LONG".equals(typeName) && jdbcType == -1 && precision == 0 && scale == 0) {
            if ("long" == null) {
                OracleDialect.$$$reportNull$$$0(22);
            }
            return "long";
        }
        if ("DATE".equals(typeName) && jdbcType == 93 && precision == 7 && scale == 0) {
            if ("date" == null) {
                OracleDialect.$$$reportNull$$$0(23);
            }
            return "date";
        }
        if ("ROWID".equals(typeName) && jdbcType == 1111 && precision == 10 && scale == 0) {
            if ("rowid" == null) {
                OracleDialect.$$$reportNull$$$0(24);
            }
            return "rowid";
        }
        if ("UROWID".equals(typeName) && jdbcType == 1111 && precision == 4000 && scale == 0) {
            if ("urowid" == null) {
                OracleDialect.$$$reportNull$$$0(25);
            }
            return "urowid";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(26);
        }
        return string;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkUpdate() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
        if (valuesCapability == null) {
            OracleDialect.$$$reportNull$$$0(27);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkDelete() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.SET_NULL, DasForeignKey.RuleAction.CASCADE);
        if (valuesCapability == null) {
            OracleDialect.$$$reportNull$$$0(28);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.Deferrability.values());
        if (valuesCapability == null) {
            OracleDialect.$$$reportNull$$$0(29);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(30);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(31);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, null);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(32);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(33);
        }
        if (view == null) {
            OracleDialect.$$$reportNull$$$0(34);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(35);
        }
        return ddlBuilder;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(36);
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element2, "PACKAGE BODY"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(37);
        }
        return pair;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    private static String getPackageDefinitionQuery(DasObject element2, String type) {
        return "select TEXT FROM SYS.ALL_SOURCE WHERE OWNER = '" + DasUtil.getSchema((DasObject)element2) + "' AND NAME = '" + element2.getName() + "' AND TYPE = '" + type + "' ORDER BY LINE";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(38);
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element2, "PACKAGE"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(39);
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(40);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SEQUENCE', '" + element2.getName() + "', '" + DasUtil.getSchema((DasObject)element2) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(41);
        }
        return pair;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(42);
        }
        return Pair.create((Object)("select TEXT FROM SYS.ALL_VIEWS WHERE OWNER = '" + DasUtil.getSchema((DasObject)element2) + "' AND VIEW_NAME = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            OracleDialect.$$$reportNull$$$0(43);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("select TEXT ");
        result2.append("FROM SYS.ALL_SOURCE ");
        result2.append("WHERE OWNER = ");
        result2.append("'");
        result2.append(DasUtil.getSchema((DasObject)element2));
        result2.append("'");
        result2.append(" AND NAME = ");
        result2.append("'");
        result2.append(element2.getName());
        result2.append("'");
        String type = StringUtil.toUpperCase((String)element2.getRoutineKind().name());
        result2.append(" AND TYPE = ");
        result2.append("'");
        result2.append(StringUtil.toUpperCase((String)type));
        result2.append("'");
        result2.append(" ORDER BY LINE");
        Pair pair = Pair.create((Object)result2.toString(), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(44);
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            OracleDialect.$$$reportNull$$$0(45);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || c2 == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            OracleDialect.$$$reportNull$$$0(46);
        }
        if (qualifier == null) {
            OracleDialect.$$$reportNull$$$0(47);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(48);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    protected String randomShorterUUID() {
        UUID uuid = UUID.randomUUID();
        return Base64.getEncoder().encodeToString(ByteBuffer.allocate(16).putLong(uuid.getLeastSignificantBits()).putLong(uuid.getMostSignificantBits()).array());
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(49);
        }
        if (statement == null) {
            OracleDialect.$$$reportNull$$$0(50);
        }
        if (analyze) {
            throw new UnsupportedOperationException("Oracle does not support EXPLAIN ANALYZE");
        }
        String uid = this.randomShorterUUID();
        builder.keywords("explain", "plan").space().keyword("set").space().plain("statement_id").symbol("=").symbol("'").plain(uid).symbol("'").space().keyword("for").space().plain(statement).newStatement();
        builder.keyword("select").space().symbol("*").space().keyword("from").space().keyword("table").symbol("(").plain("DBMS_XPLAN.DISPLAY").symbol("(").symbol("'").plain("PLAN_TABLE").symbol("'").symbol(",").symbol("'").plain(uid).symbol("'").symbol(")").symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(51);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected AbstractDatabaseDialect.LimitPlace getPlaceForLimit(@Nullable DasDataSource system) {
        AbstractDatabaseDialect.LimitPlace limitPlace = AbstractDatabaseDialect.LimitPlace.BOTH;
        if (limitPlace == null) {
            OracleDialect.$$$reportNull$$$0(52);
        }
        return limitPlace;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DasDataSource system, int rows) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(53);
        }
        DdlBuilder ddlBuilder = OracleDialect.rowNumLimit(builder, rows);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(54);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return true;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(55);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("ROWID");
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OracleDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 4: 
            case 30: 
            case 33: 
            case 49: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OracleDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSynonymDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkUpdate";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDelete";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLimit";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

