/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import b.h.la;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.rubyforge.debugcommons.ICommandFactory;
import org.rubyforge.debugcommons.ReadersSupport;
import org.rubyforge.debugcommons.RubyDebugCommandFactory;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.ExceptionSuspensionPoint;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.IRubyExceptionBreakpoint;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebuggerProxy {
    private static final Logger p;
    private static final int c = 3;
    private final QueueProcessor<DebuggerCommand> o;
    private final List<RubyDebugEventListener> a;
    private final Map<Integer, IRubyLineBreakpoint> h;
    private final int q;
    private final boolean j;
    private RubyDebugTarget k;
    private Socket l;
    private boolean d;
    private PrintWriter g;
    private final ICommandFactory i;
    private final ReadersSupport b;
    private final boolean m;
    private final Object e = new Object();
    private final Set<String> n;
    private final boolean f;
    private static final long r;

    public RubyDebuggerProxy(int timeout, boolean supportsFrameReadingForNonSuspendedThreads, boolean supportsCondition, boolean supportsCatchpointRemoval) {
        this.j = supportsFrameReadingForNonSuspendedThreads;
        this.a = ContainerUtil.createLockFreeCopyOnWriteList();
        this.h = new HashMap<Integer, IRubyLineBreakpoint>();
        this.f = supportsCatchpointRemoval;
        this.n = this.f ? null : new HashSet();
        this.q = timeout;
        this.b = new ReadersSupport(timeout);
        this.m = supportsCondition;
        this.i = new RubyDebugCommandFactory(this.j);
        this.o = new QueueProcessor(debuggerCommand -> {
            try {
                debuggerCommand.run(this.b);
            }
            catch (Exception exception) {
                debuggerCommand.rejected(exception);
            }
        });
    }

    public void setDebugTarget(RubyDebugTarget debugTarget) {
        long l2 = r ^ 0x5CF607710AA0L;
        this.k = debugTarget;
        p.debug("Proxy target: " + debugTarget);
    }

    public RubyDebugTarget getDebugTarget() {
        return this.k;
    }

    ReadersSupport getReadersSupport() {
        return this.b;
    }

    public void attach(boolean enableFileFiltering, @NotNull IRubyBreakpoint[] initialBreakpoints, @NotNull Collection<String> dirsToInclude, @NotNull Collection<String> dirsToExclude) throws RubyDebuggerException {
        if (initialBreakpoints == null) {
            RubyDebuggerProxy.a(0);
        }
        if (dirsToInclude == null) {
            RubyDebuggerProxy.a(1);
        }
        if (dirsToExclude == null) {
            RubyDebuggerProxy.a(2);
        }
        this.a(enableFileFiltering, initialBreakpoints, dirsToInclude, dirsToExclude);
        this.a();
    }

    private synchronized boolean c() {
        return this.d;
    }

    public synchronized boolean isReady() {
        return !this.d && this.g != null && this.k.isAvailable();
    }

    private synchronized void a(boolean bl2, @NotNull IRubyBreakpoint[] iRubyBreakpointArray, @NotNull Collection<String> collection, @NotNull Collection<String> collection2) throws RubyDebuggerException {
        long l2 = r ^ 0x1E9CA8075B52L;
        if (iRubyBreakpointArray == null) {
            RubyDebuggerProxy.a(3);
        }
        if (collection == null) {
            RubyDebuggerProxy.a(4);
        }
        if (collection2 == null) {
            RubyDebuggerProxy.a(5);
        }
        try {
            if (!this.b.startCommandLoop(this.getCommandSocket().getInputStream())) {
                return;
            }
            this.g = new PrintWriter(this.getCommandSocket().getOutputStream(), true);
            for (IRubyBreakpoint iRubyBreakpoint : iRubyBreakpointArray) {
                this.a(iRubyBreakpoint);
            }
            for (String string : collection) {
                this.a("include " + string);
            }
            for (String string : collection2) {
                this.a("exclude " + string);
            }
            if (bl2) {
                this.a("file-filter on");
            }
            this.a("start");
        }
        catch (IOException iOException) {
            throw new RubyDebuggerException(iOException);
        }
    }

    public void fireDebugEvent(RubyDebugEvent e10) {
        for (RubyDebugEventListener rubyDebugEventListener : this.a) {
            rubyDebugEventListener.onDebugEvent(e10);
        }
    }

    public void addRubyDebugEventListener(RubyDebugEventListener listener) {
        this.a.add(listener);
    }

    public void removeRubyDebugEventListener(RubyDebugEventListener listener) {
        this.a.remove(listener);
    }

    private PrintWriter f() throws RubyDebuggerException {
        long l2 = r ^ 0x3523FF2DDD1AL;
        assert (this.g != null) : "Proxy has to be started, before using the writer";
        return this.g;
    }

    public void addBreakpoint(final @NotNull IRubyBreakpoint breakpoint) {
        if (breakpoint == null) {
            RubyDebuggerProxy.a(6);
        }
        this.o.add((Object)new DebuggerCommand(){
            private static final long a = la.a(-6254231074708732317L, -1476221515833488803L, MethodHandles.lookup().lookupClass()).a(158069721437884L);

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                long l2 = a ^ 0x133DB716ACCBL;
                if (readersSupport == null) {
                    1.b(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    RubyDebuggerProxy.this.a(breakpoint);
                } else if (!RubyDebuggerProxy.this.c()) {
                    p.warn("Couldn't add breakpoint during timeout");
                }
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = a ^ 0x1318AE79B152L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$1", "run"));
            }
        });
    }

    private void a(@NotNull IRubyBreakpoint iRubyBreakpoint) {
        block5: {
            long l2 = r ^ 0x73DBA2D30B00L;
            if (iRubyBreakpoint == null) {
                RubyDebuggerProxy.a(7);
            }
            p.debug("Adding breakpoint: " + iRubyBreakpoint);
            try {
                if (iRubyBreakpoint instanceof IRubyLineBreakpoint) {
                    this.d((IRubyLineBreakpoint)iRubyBreakpoint);
                    break block5;
                }
                if (iRubyBreakpoint instanceof IRubyExceptionBreakpoint) {
                    this.a((IRubyExceptionBreakpoint)iRubyBreakpoint);
                    break block5;
                }
                throw new IllegalArgumentException("Unknown breakpoint type: " + iRubyBreakpoint);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                p.warn("Cannot add breakpoint to: " + this.getDebugTarget(), (Throwable)rubyDebuggerException);
            }
        }
    }

    private synchronized void a(@NotNull IRubyExceptionBreakpoint iRubyExceptionBreakpoint) throws RubyDebuggerException {
        long l2 = r ^ 0x2B8452A06ABAL;
        if (iRubyExceptionBreakpoint == null) {
            RubyDebuggerProxy.a(8);
        }
        if (!this.isReady()) {
            p.debug("Session and/or debuggee is not ready, skipping addition of breakpoint: " + iRubyExceptionBreakpoint);
            return;
        }
        if (this.f || !this.n.remove(iRubyExceptionBreakpoint.getException())) {
            String string = this.i.createCatchOn(iRubyExceptionBreakpoint);
            this.a(string);
            this.getReadersSupport().readCatchpointSet();
        }
    }

    private synchronized void d(@NotNull IRubyLineBreakpoint iRubyLineBreakpoint) throws RubyDebuggerException {
        long l2 = r ^ 0xDBCED4A1C14L;
        if (iRubyLineBreakpoint == null) {
            RubyDebuggerProxy.a(9);
        }
        if (!this.isReady()) {
            p.debug("Session and/or debuggee is not ready, skipping addition of breakpoint: " + iRubyLineBreakpoint);
            return;
        }
        String string = this.i.createAddBreakpoint(iRubyLineBreakpoint.getFilePath(), iRubyLineBreakpoint.getLineNumber());
        this.a(string);
        Integer n2 = this.getReadersSupport().readAddedBreakpointNo();
        String string2 = iRubyLineBreakpoint.getCondition();
        if (string2 != null && this.m) {
            string = this.i.createSetCondition(n2, string2);
            if (string != null) {
                this.a(string);
                this.getReadersSupport().readConditionSet();
            } else {
                p.info("conditional breakpoints are not supported by backend");
            }
        }
        if (!iRubyLineBreakpoint.isEnabled()) {
            this.b(iRubyLineBreakpoint);
        }
        this.h.put(n2, iRubyLineBreakpoint);
    }

    private synchronized void b(@NotNull IRubyLineBreakpoint iRubyLineBreakpoint) throws RubyDebuggerException {
        Integer n2;
        long l2 = r ^ 0x1FE0F9DF9020L;
        if (iRubyLineBreakpoint == null) {
            RubyDebuggerProxy.a(10);
        }
        if ((n2 = this.c(iRubyLineBreakpoint)) == null) {
            p.info("Unable to get id for a given breakpoint (" + iRubyLineBreakpoint + ")");
            return;
        }
        String string = this.i.createDisableBreakpoint(n2);
        if (string == null) {
            p.info("disabling breakpoints is nor supported by backend");
            return;
        }
        this.a(string);
        this.getReadersSupport().readDisabledBreakpointNo(n2);
    }

    public void removeBreakpoint(final IRubyBreakpoint breakpoint) {
        this.o.add((Object)new DebuggerCommand(){
            private static final long a = la.a(4154658076932653529L, 8262335869705153131L, MethodHandles.lookup().lookupClass()).a(23043318923921L);

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                long l2 = a ^ 0x3A14255661E9L;
                if (readersSupport == null) {
                    2.b(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    RubyDebuggerProxy.this.b(breakpoint);
                } else if (!RubyDebuggerProxy.this.c()) {
                    p.warn("Couldn't remove breakpoint during timeout");
                }
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = a ^ 0x4683FEC53C3L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$2", "run"));
            }
        });
    }

    private void b(@NotNull IRubyBreakpoint iRubyBreakpoint) {
        long l2 = r ^ 0x25F546ED419BL;
        if (iRubyBreakpoint == null) {
            RubyDebuggerProxy.a(11);
        }
        p.debug("Removing breakpoint: " + iRubyBreakpoint);
        if (iRubyBreakpoint instanceof IRubyLineBreakpoint) {
            this.a((IRubyLineBreakpoint)iRubyBreakpoint);
        } else if (iRubyBreakpoint instanceof IRubyExceptionBreakpoint) {
            this.b((IRubyExceptionBreakpoint)iRubyBreakpoint);
        } else {
            throw new IllegalArgumentException("Unknown breakpoint type: " + iRubyBreakpoint);
        }
    }

    private synchronized void a(@NotNull IRubyLineBreakpoint iRubyLineBreakpoint) {
        long l2 = r ^ 0x1C5C6A085F91L;
        if (iRubyLineBreakpoint == null) {
            RubyDebuggerProxy.a(12);
        }
        if (!this.isReady()) {
            p.debug("Session and/or debuggee is not ready, skipping removing of breakpoint: " + iRubyLineBreakpoint);
            return;
        }
        Integer n2 = this.c(iRubyLineBreakpoint);
        if (n2 == null) {
            p.debug("Breakpoint [" + iRubyLineBreakpoint + "] cannot be removed since its ID cannot be found. Might have been already removed.");
            return;
        }
        String string = this.i.createRemoveBreakpoint(n2);
        try {
            this.a(string);
            this.getReadersSupport().waitForRemovedBreakpoint(n2);
            this.h.remove(n2);
            p.debug("Breakpoint " + iRubyLineBreakpoint + " with id " + n2 + " successfully removed");
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            p.warn("Exception during removing breakpoint.", (Throwable)rubyDebuggerException);
        }
    }

    private synchronized void b(@NotNull IRubyExceptionBreakpoint iRubyExceptionBreakpoint) {
        long l2 = r ^ 0x5E91F4607A78L;
        if (iRubyExceptionBreakpoint == null) {
            RubyDebuggerProxy.a(13);
        }
        if (!this.isReady()) {
            p.debug("Session and/or debuggee is not ready, skipping removing of breakpoint: " + iRubyExceptionBreakpoint);
            return;
        }
        if (!this.f) {
            this.n.add(iRubyExceptionBreakpoint.getException());
            return;
        }
        String string = this.i.createCatchOff(iRubyExceptionBreakpoint);
        try {
            this.a(string);
            this.getReadersSupport().readCatchpointDeleted();
            p.debug("Exceptional breakpoint for " + iRubyExceptionBreakpoint + " is set");
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            p.warn("Exception during removing ecxeptional breakpoint.", (Throwable)rubyDebuggerException);
        }
    }

    public void updateBreakpoint(IRubyBreakpoint breakpoint) {
        long l2 = r ^ 0x118ABF53A4A1L;
        throw new UnsupportedOperationException("not implemented");
    }

    private synchronized Integer c(IRubyLineBreakpoint iRubyLineBreakpoint) {
        for (Map.Entry<Integer, IRubyLineBreakpoint> entry : this.h.entrySet()) {
            IRubyLineBreakpoint iRubyLineBreakpoint2 = entry.getValue();
            int n2 = entry.getKey();
            if (!iRubyLineBreakpoint.getFilePath().equals(iRubyLineBreakpoint2.getFilePath()) || iRubyLineBreakpoint.getLineNumber() != iRubyLineBreakpoint2.getLineNumber()) continue;
            return n2;
        }
        return null;
    }

    private void a() {
        new SuspensionReaderLoop(this).start();
    }

    public Socket getCommandSocket() throws RubyDebuggerException {
        if (this.l == null) {
            this.l = this.d();
        }
        return this.l;
    }

    public void resume(final RubyThread thread) {
        this.o.add((Object)new DebuggerCommand(){
            private static final long a = la.a(-6563637906495031375L, 6168133429462287342L, MethodHandles.lookup().lookupClass()).a(24389300259818L);

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                long l2 = a ^ 0x336037AEC6D7L;
                if (readersSupport == null) {
                    3.b(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    try {
                        RubyDebuggerProxy.this.a(RubyDebuggerProxy.this.i.createResume(thread));
                    }
                    catch (RubyDebuggerException rubyDebuggerException) {
                        throw new ExecutionException("resuming of " + thread.getId() + " failed", rubyDebuggerException);
                    }
                    if (p.isDebugEnabled()) {
                        p.debug("Resumed");
                    }
                } else if (!RubyDebuggerProxy.this.c()) {
                    p.warn("Couldn't resume during timeout");
                }
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = a ^ 0x1BFB3B6AEDE7L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$3", "run"));
            }
        });
    }

    private synchronized void a(String string) throws RubyDebuggerException {
        long l2 = r ^ 0x430203C1EE35L;
        p.debug("Sending command debugger: " + string);
        if (!this.isReady()) {
            throw new RubyDebuggerException("Trying to send a command [" + string + "] to non-started or finished proxy (debuggee: " + this.getDebugTarget() + ", output: \n\n" + Util.dumpAndDestroyProcess(this.k));
        }
        this.f().println(string);
    }

    public void sendStepOver(final RubyFrame frame, final boolean forceNewLine) {
        this.o.add((Object)new DebuggerCommand(){
            private static final long a = la.a(8308544458589527566L, 2459178590241363629L, MethodHandles.lookup().lookupClass()).a(190125381036292L);

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                long l2 = a ^ 0x25039CC272F7L;
                if (readersSupport == null) {
                    4.b(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    try {
                        if (forceNewLine) {
                            RubyDebuggerProxy.this.a(RubyDebuggerProxy.this.i.createForcedStepOver(frame));
                        } else {
                            RubyDebuggerProxy.this.a(RubyDebuggerProxy.this.i.createStepOver(frame));
                        }
                    }
                    catch (RubyDebuggerException rubyDebuggerException) {
                        throw new ExecutionException("Stepping failed", rubyDebuggerException);
                    }
                    if (p.isDebugEnabled()) {
                        p.debug("Step over");
                    }
                } else if (!RubyDebuggerProxy.this.c()) {
                    p.warn("Couldn't step over during timeout");
                }
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = a ^ 0x67841DE51DC2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$4", "run"));
            }
        });
    }

    public void sendStepReturnEnd(final @NotNull RubyFrame frame) {
        if (frame == null) {
            RubyDebuggerProxy.a(14);
        }
        this.o.add((Object)new DebuggerCommand(){
            private static final long a = la.a(-8823545261083091794L, -8897067941369446997L, MethodHandles.lookup().lookupClass()).a(172914597551111L);

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                long l2 = a ^ 0x1CCF490C6E4L;
                if (readersSupport == null) {
                    5.b(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    try {
                        RubyDebuggerProxy.this.a(RubyDebuggerProxy.this.i.createStepReturn(frame));
                    }
                    catch (RubyDebuggerException rubyDebuggerException) {
                        p.error("Stepping failed", (Throwable)rubyDebuggerException);
                    }
                    if (p.isDebugEnabled()) {
                        p.debug("Step out");
                    }
                } else if (!RubyDebuggerProxy.this.c()) {
                    p.warn("Couldn't step into during timeout");
                }
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = a ^ 0x705DB7F851A2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$5", "run"));
            }
        });
    }

    public void sendStepIntoEnd(RubyFrame frame, boolean forceNewLine) {
        long l2 = r ^ 0x396362707991L;
        try {
            if (forceNewLine) {
                this.a(this.i.createForcedStepInto(frame));
            } else {
                this.a(this.i.createStepInto(frame));
            }
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            p.error("Stepping failed", (Throwable)rubyDebuggerException);
        }
    }

    public RubyThreadInfo[] readThreadInfo() throws RubyDebuggerException {
        this.a(this.i.createReadThreads());
        return this.getReadersSupport().readThreads();
    }

    public RubyFrame[] readFrames(RubyThread thread) throws RubyDebuggerException {
        RubyFrameInfo[] rubyFrameInfoArray;
        long l2 = r ^ 0x4B443ADB49E6L;
        try {
            this.a(this.i.createReadFrames(thread));
            rubyFrameInfoArray = this.getReadersSupport().readFrames();
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            if (this.isReady()) {
                throw rubyDebuggerException;
            }
            p.debug("Session and/or debuggee is not ready, returning empty thread list.");
            rubyFrameInfoArray = new RubyFrameInfo[]{};
        }
        RubyFrame[] rubyFrameArray = new RubyFrame[rubyFrameInfoArray.length];
        for (int i10 = 0; i10 < rubyFrameInfoArray.length; ++i10) {
            RubyFrameInfo rubyFrameInfo = rubyFrameInfoArray[i10];
            rubyFrameArray[i10] = new RubyFrame(thread, rubyFrameInfo);
        }
        return rubyFrameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable[] readVariables(RubyFrame frame) throws RubyDebuggerException {
        RubyVariable[] rubyVariableArray = this.e;
        synchronized (this.e) {
            this.a(this.i.createReadLocalVariables(frame));
            RubyVariableInfo[] rubyVariableInfoArray = this.getReadersSupport().readVariables();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            rubyVariableArray = new RubyVariable[rubyVariableInfoArray.length];
            for (int i10 = 0; i10 < rubyVariableInfoArray.length; ++i10) {
                RubyVariableInfo rubyVariableInfo = rubyVariableInfoArray[i10];
                rubyVariableArray[i10] = new RubyVariable(rubyVariableInfo, frame);
            }
            return rubyVariableArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable[] readInstanceVariables(RubyVariable variable) throws RubyDebuggerException {
        RubyVariable[] rubyVariableArray = this.e;
        synchronized (this.e) {
            this.a(this.i.createReadInstanceVariable(variable));
            RubyVariableInfo[] rubyVariableInfoArray = this.getReadersSupport().readVariables();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            rubyVariableArray = new RubyVariable[rubyVariableInfoArray.length];
            for (int i10 = 0; i10 < rubyVariableInfoArray.length; ++i10) {
                RubyVariableInfo rubyVariableInfo = rubyVariableInfoArray[i10];
                rubyVariableArray[i10] = new RubyVariable(rubyVariableInfo, variable);
            }
            return rubyVariableArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable[] readGlobalVariables() throws RubyDebuggerException {
        RubyVariable[] rubyVariableArray = this.e;
        synchronized (this.e) {
            this.a(this.i.createReadGlobalVariables());
            RubyVariableInfo[] rubyVariableInfoArray = this.getReadersSupport().readVariables();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            rubyVariableArray = new RubyVariable[rubyVariableInfoArray.length];
            for (int i10 = 0; i10 < rubyVariableInfoArray.length; ++i10) {
                RubyVariableInfo rubyVariableInfo = rubyVariableInfoArray[i10];
                rubyVariableArray[i10] = new RubyVariable(this, rubyVariableInfo);
            }
            return rubyVariableArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable inspectExpression(RubyFrame frame, String expression) throws RubyDebuggerException {
        RubyVariableInfo[] rubyVariableInfoArray;
        expression = RubyDebuggerProxy.b(expression);
        Object object = this.e;
        synchronized (object) {
            this.a(this.i.createInspect(frame, expression));
            rubyVariableInfoArray = this.getReadersSupport().readVariables();
        }
        return rubyVariableInfoArray.length == 0 ? null : new RubyVariable(rubyVariableInfoArray[0], frame);
    }

    public ExpressionInfo getExpressionInfo(RubyFrame frame, String expression) throws RubyDebuggerException {
        expression = RubyDebuggerProxy.b(expression);
        this.a(this.i.createExpressionInfo(frame, expression));
        return this.getReadersSupport().readExpressionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean forced) {
        long l2 = r ^ 0x72B2BBAA6B2CL;
        RubyDebuggerProxy rubyDebuggerProxy = this;
        synchronized (rubyDebuggerProxy) {
            if (this.d) {
                p.debug("Trying to finish the same proxy more than once: " + this);
                return;
            }
            RubyDebugTarget rubyDebugTarget = this.getDebugTarget();
            if (rubyDebugTarget.isRemote()) {
                this.e();
            } else if (forced) {
                this.b();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    p.info("Interrupted during IO readers waiting", (Throwable)interruptedException);
                }
                if (!rubyDebugTarget.isRemote()) {
                    p.debug("Destroying process: " + rubyDebugTarget);
                    rubyDebugTarget.getProcess().destroy();
                }
            }
            this.d = true;
        }
        this.fireDebugEvent(RubyDebugEvent.createTerminateEvent(this));
    }

    private synchronized void b() {
        block3: {
            long l2 = r ^ 0x54E54DA25D36L;
            if (this.l != null && this.k.isAvailable()) {
                try {
                    this.a("exit");
                }
                catch (RubyDebuggerException rubyDebuggerException) {
                    p.debug("'exit' command failed. Remote process? -> " + this.k.isRemote());
                    if (this.k.isRemote()) break block3;
                    p.debug("'exit' command failed. Process running? -> " + this.k.isRunning());
                }
            }
        }
    }

    private synchronized void e() {
        long l2 = r ^ 0x283AC02CAEA5L;
        if (this.l != null && this.k.isAvailable()) {
            try {
                this.a("detach");
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                p.warn("'detach' command failed.");
            }
        }
    }

    public synchronized void jump(int line) {
        block2: {
            long l2 = r ^ 0x3A428C9D1BDDL;
            try {
                this.a("jump " + line);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                if (!this.isReady()) break block2;
                p.warn("Cannot jump", (Throwable)rubyDebuggerException);
            }
        }
    }

    public synchronized void threadPause(int id2) {
        block2: {
            long l2 = r ^ 0x227C1B36A3F1L;
            try {
                this.a("pause " + id2);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                if (!this.isReady()) break block2;
                p.warn("Cannot pause", (Throwable)rubyDebuggerException);
            }
        }
    }

    public synchronized void setType(RubyVariable var, String new_type) {
        block2: {
            long l2 = r ^ 0x3F16568CB912L;
            try {
                this.a("set_type " + var.getName() + " " + new_type);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                if (!this.isReady()) break block2;
                p.warn("Cannot set_type", (Throwable)rubyDebuggerException);
            }
        }
    }

    @NotNull
    private static String b(@NotNull String string) {
        long l2 = r ^ 0x1442A1BE3430L;
        if (string == null) {
            RubyDebuggerProxy.a(15);
        }
        string = StringUtil.replace((String)string, (String)"\\", (String)"\\\\");
        String string2 = string = StringUtil.replace((String)string, (String)"\n", (String)"\\n");
        if (string2 == null) {
            RubyDebuggerProxy.a(16);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Socket d() throws RubyDebuggerException {
        long l2 = r ^ 0x5C2A87E7BE49L;
        int n2 = this.k.getPort();
        String string = this.k.getHost();
        Socket socket = null;
        int n3 = this.q * 2;
        int n4 = 0;
        while (n4 < n3 && socket == null) {
            try {
                while (socket == null) {
                    Socket socket2 = new Socket(string, n2);
                    socket2.setSoTimeout(100);
                    try {
                        int n5 = socket2.getInputStream().read();
                        if (n5 != -1) continue;
                        TimeoutUtil.sleep((long)500L);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        socket = socket2;
                        socket.setSoTimeout(0);
                    }
                }
                p.debug("Successfully attached to " + string + ':' + n2);
            }
            catch (ConnectException connectException) {
                RubyDebuggerProxy rubyDebuggerProxy = this;
                synchronized (rubyDebuggerProxy) {
                    if (this.d) {
                        throw new RubyDebuggerException("Process was terminated before debugger connection was established.");
                    }
                    if (n4 == n3 - 1) {
                        this.a(connectException);
                    }
                }
                try {
                    if (this.k.isAvailable()) {
                        p.debug("Cannot connect to " + string + ':' + n2 + ". Trying again...(" + (n3 - n4 - 1) + ')');
                        Thread.sleep(500L);
                    }
                    this.a(connectException);
                }
                catch (InterruptedException interruptedException) {
                    p.info("Interrupted during attaching.", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException iOException) {
                throw new RubyDebuggerException(iOException);
            }
            ++n4;
        }
        return socket;
    }

    private void a(ConnectException connectException) throws RubyDebuggerException {
        long l2 = r ^ 0x634305A89C0EL;
        String string = this.k.isRemote() ? "[Remote Process at " + this.k.getHost() + ':' + this.k.getPort() + "]" : Util.dumpAndDestroyProcess(this.k);
        throw new RubyDebuggerException("Cannot connect to the debugged process at port " + this.k.getPort() + " in " + this.q + "s:\n\n" + string, connectException);
    }

    public boolean canReadFramesOfNonSuspendedThreads() {
        return this.j;
    }

    public boolean waitForDebuggerProxyReady() {
        int n2 = 0;
        while (n2++ < 3) {
            if (this.isReady()) {
                return true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return false;
    }

    static {
        r = la.a(2622610148346643952L, 8629807116416783245L, MethodHandles.lookup().lookupClass()).a(213220094701840L);
        p = Logger.getInstance(RubyDebuggerProxy.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = r ^ 0x5CAB43B6A566L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialBreakpoints";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToInclude";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToExclude";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/RubyDebuggerProxy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/RubyDebuggerProxy";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeNewlinesForDebugger";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attach";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachToRubyDebug";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionalBreakpoint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLineBreakpoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "disableLineBreakpoint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpointImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeLineBreakpoint";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeExceptionalBreakpoint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sendStepReturnEnd";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "escapeNewlinesForDebugger";
                break;
            }
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SuspensionReaderLoop
    extends Thread {
        final /* synthetic */ RubyDebuggerProxy this$0;
        private static final long a = la.a(-818546877094621755L, 6022771853827454945L, MethodHandles.lookup().lookupClass()).a(140485456747152L);

        SuspensionReaderLoop(RubyDebuggerProxy rubyDebuggerProxy) {
            long l2 = a ^ 0x75494097D668L;
            this.this$0 = rubyDebuggerProxy;
            super("RubyDebuggerLoop [" + System.currentTimeMillis() + ']');
        }

        public void suspensionOccurred(SuspensionPoint hit) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.this$0.k.suspensionOccurred(hit));
        }

        @Override
        public void run() {
            SuspensionPoint suspensionPoint;
            long l2 = a ^ 0x6BBE72AC7600L;
            p.debug("Waiting for breakpoints.");
            while ((suspensionPoint = this.this$0.getReadersSupport().readSuspension()) != SuspensionPoint.END) {
                p.debug(suspensionPoint.toString());
                if (!this.this$0.f && suspensionPoint.isException()) {
                    RubyThread rubyThread;
                    ExceptionSuspensionPoint exceptionSuspensionPoint = (ExceptionSuspensionPoint)suspensionPoint;
                    if (this.this$0.n.contains(exceptionSuspensionPoint.getExceptionType()) && (rubyThread = this.this$0.getDebugTarget().getThreadById(suspensionPoint.getThreadId())) != null) {
                        this.this$0.resume(rubyThread);
                        continue;
                    }
                }
                if (!this.this$0.isReady()) {
                    p.info("Session and/or debuggee is not ready, ignoring backend event - suspension point: " + suspensionPoint);
                    continue;
                }
                this.suspensionOccurred(suspensionPoint);
            }
            boolean bl2 = this.this$0.getReadersSupport().isUnexpectedFail();
            if (bl2) {
                p.warn("Unexpected fail. Debuggee: " + this.this$0.getDebugTarget() + ", output: \n\n" + Util.dumpAndDestroyProcess(this.this$0.k));
            }
            this.this$0.finish(bl2);
            p.debug("Socket reader loop finished.");
        }
    }

    private static abstract class DebuggerCommand {
        private static final long b = la.a(-6485033657961032341L, 3946810556939010856L, MethodHandles.lookup().lookupClass()).a(212727765775490L);

        private DebuggerCommand() {
        }

        public abstract void run(@NotNull ReadersSupport var1) throws ExecutionException;

        public void rejected(@NotNull Exception reason) {
            if (reason == null) {
                DebuggerCommand.a(0);
            }
            if (reason instanceof ExecutionException) {
                p.warn(reason.getLocalizedMessage());
            } else {
                p.error((Throwable)reason);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0xA9D4ED503E4L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/rubyforge/debugcommons/RubyDebuggerProxy$DebuggerCommand", "rejected"));
        }
    }
}

