/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.debugger;

import b.h.la;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyExperimentalDebuggerTopHitProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.a;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public class RubyDebugIdeGemHelper
implements DebugGemHelper {
    @NonNls
    public static final String RDEBUG_IDE_GEM_NAME = "ruby-debug-ide";
    @NonNls
    private static final String p = "ruby-debug-base";
    @NonNls
    private static final String f = "ruby-debug-base19x";
    @NonNls
    private static final String k = "debase";
    @NonNls
    private static final String o = "--debug";
    private static final Pattern r;
    private static final Pattern t;
    private static final Pattern g;
    private static final Pattern j;
    private static final String q = "(0\\.6(\\.[0-9A-z]+)*)";
    private static final String x = "(0\\.7(\\.[0-9A-z]+)*)";
    private static final Pattern e;
    private static final Pattern c;
    private static final Pattern a;
    private static final Pattern l;
    private static final String b = "(0\\.2(\\.[0-9A-z]+)*)";
    private static final String m = "(0\\.2(\\.[0-9A-z]+)*)";
    private static final Pattern y;
    private static final Pattern z;
    private static final Pattern n;
    private static final Pattern v;
    private static final String B = "0.7.0.beta7";
    private static final String i = "0.6.1";
    private static final String s = "0.10.5.rc10";
    private static final String d = "0.11.32";
    private static final String h = "0.2.3.beta3";
    private static final String w = "0.10.6";
    public static final String DEBUGGER_PRESENT_ASKED = "debugger.present.asked";
    public static final String DEBUGGER_SHOULD_USE_EXPERIMENTAL = "debugger.should.use.experimental";
    @Nullable
    private final State A;
    @NotNull
    private final RubyDebugMode u;
    private static final long C;

    public RubyDebugIdeGemHelper(@Nullable State state, @NotNull RubyDebugMode mode) {
        if (mode == null) {
            RubyDebugIdeGemHelper.a(0);
        }
        this.A = state;
        this.u = mode;
    }

    @Nullable
    public static GemInfo findGem(@NotNull String gemName, @Nullable Module module, @NotNull Sdk sdk) {
        if (gemName == null) {
            RubyDebugIdeGemHelper.a(1);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(2);
        }
        GemInfo gemInfo = null;
        if (module != null) {
            gemInfo = GemSearchUtil.findGem(module, gemName);
        }
        return gemInfo != null ? gemInfo : GemSearchUtil.findGem(module, sdk, gemName);
    }

    public static boolean checkForDebuggerPresence(@Nullable Module module) {
        long l2 = C ^ 0x2BED4868B20FL;
        return RubyDebugIdeGemHelper.a(module, "debugger", DEBUGGER_PRESENT_ASKED);
    }

    private static boolean a(@Nullable Module module, @NotNull String string, @NotNull String string2) {
        long l2 = C ^ 0x66E7FAA0A853L;
        if (string == null) {
            RubyDebugIdeGemHelper.a(3);
        }
        if (string2 == null) {
            RubyDebugIdeGemHelper.a(4);
        }
        if (module == null || PropertiesComponent.getInstance((Project)module.getProject()).getBoolean(string2)) {
            return true;
        }
        GemInfo gemInfo = GemSearchUtil.findGem(module, string);
        if (gemInfo == null) {
            return true;
        }
        int n2 = Messages.showYesNoDialog((Project)module.getProject(), (String)RBundle.message((String)"gems.debugger.in.gemfile", (Object[])new Object[]{string}), (String)RBundle.message((String)"gems.debugger.alert.title"), (Icon)Messages.getQuestionIcon());
        if (n2 == 0) {
            PropertiesComponent.getInstance((Project)module.getProject()).setValue(string2, true);
            return true;
        }
        return false;
    }

    @NotNull
    public String getRdebugIdeGemName() {
        long l2 = C ^ 0x6844FC86A67EL;
        if (RDEBUG_IDE_GEM_NAME == null) {
            RubyDebugIdeGemHelper.a(5);
        }
        return RDEBUG_IDE_GEM_NAME;
    }

    @NotNull
    public String getRdebugFrontEndGemName(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(6);
        }
        String string = DebugGemType.getBaseType(sdk).getGemName();
        if (string == null) {
            RubyDebugIdeGemHelper.a(7);
        }
        return string;
    }

    @Override
    public boolean isUsable() {
        return this.A != null;
    }

    @Override
    @NotNull
    public String updateRubyLib(@Nullable String rubyLib, @NotNull RubySdkSystemAccessor accessor, @NotNull PathMappingSettings mappingSettings) {
        long l2 = C ^ 0x87A53C81EFL;
        if (accessor == null) {
            RubyDebugIdeGemHelper.a(8);
        }
        if (mappingSettings == null) {
            RubyDebugIdeGemHelper.a(9);
        }
        assert (this.A != null) : "state must not be null at this point";
        rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(this.A.myIdeLib.getPath()));
        rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(this.A.myBaseLib.getPath()));
        if (this.A.myLineCacheNeeded) {
            VirtualFile virtualFile = this.A.myLineCacheLib;
            assert (this.A.myLineCacheLib != null);
            rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(virtualFile.getPath()));
        }
        String string = rubyLib;
        if (string == null) {
            RubyDebugIdeGemHelper.a(10);
        }
        return string;
    }

    @Override
    public boolean isMultiProcessDebugSupported() {
        long l2 = C ^ 0x17EF2B66C991L;
        assert (this.A != null) : "state must not be null at this point";
        return this.A.myMultiProcessDebugSupported;
    }

    @Override
    @NotNull
    public String getRdebugScriptPath() {
        long l2 = C ^ 0x69DFB95873D8L;
        assert (this.A != null) : "state must not be null at this point";
        String string = this.A.myRDebugScriptPath;
        if (string == null) {
            RubyDebugIdeGemHelper.a(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getErrorMsg() {
        long l2 = C ^ 0x6C92B3FD6C8L;
        String string = RBundle.message((String)"gem.not.found.executable.for.gem", (Object[])new Object[]{RDEBUG_IDE_GEM_NAME, this.u.getDebugScript()});
        if (string == null) {
            RubyDebugIdeGemHelper.a(12);
        }
        return string;
    }

    @Override
    public void enableVerboseMode(@NotNull List<String> args, boolean enableMode) {
        long l2 = C ^ 0x3291DF1E7BCFL;
        if (args == null) {
            RubyDebugIdeGemHelper.a(13);
        }
        if (enableMode) {
            args.add(o);
        }
    }

    @Override
    public void enableKeyValuePresentation(@NotNull List<String> args, boolean enableMode) {
        long l2 = C ^ 0x7167556F5B66L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(14);
        }
        if (this.A != null && this.A.myKeyValueHashAvailable && enableMode) {
            args.add("--key-value");
        }
    }

    @Override
    public void disableIntHandler(@NotNull List<String> args, boolean disableHandler) {
        long l2 = C ^ 0x5FDC19FE20CFL;
        if (args == null) {
            RubyDebugIdeGemHelper.a(15);
        }
        if (disableHandler) {
            args.add("--disable-int-handler");
        }
    }

    @Override
    public void setEvaluationTimeout(@NotNull List<String> args, int seconds) {
        long l2 = C ^ 0x4B4E1A6399DFL;
        if (args == null) {
            RubyDebugIdeGemHelper.a(16);
        }
        if (this.A != null && this.A.myTimeoutConfigurable) {
            args.add("--evaluation-timeout");
            args.add(Integer.toString(seconds));
        }
    }

    @Override
    public void enableEvaluationControl(@NotNull List<String> args, boolean enableMode) {
        long l2 = C ^ 0x4935E1F711EBL;
        if (args == null) {
            RubyDebugIdeGemHelper.a(17);
        }
        if (this.A != null && this.A.myEvaluationControlConfigurable && enableMode) {
            args.add("--evaluation-control");
        }
    }

    @Override
    public void setEvaluationTimeLimit(@NotNull List<String> args, int milliseconds) {
        long l2 = C ^ 0xC691280084EL;
        if (args == null) {
            RubyDebugIdeGemHelper.a(18);
        }
        if (this.A != null && this.A.myEvaluationControlConfigurable) {
            args.add("--time-limit");
            args.add(Integer.toString(milliseconds));
        }
    }

    @Override
    public void setEvaluationMemoryLimit(@NotNull List<String> args, int megabytes) {
        long l2 = C ^ 0x470C1153B928L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(19);
        }
        if (this.A != null && this.A.myEvaluationControlConfigurable) {
            args.add("--memory-limit");
            args.add(Integer.toString(megabytes));
        }
    }

    @Override
    public void addGemSpecificArgs(@NotNull List<String> args) {
        long l2 = C ^ 0x6EC348CDB550L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(20);
        }
        if (this.A != null && this.A.myRmProtocolExtensionsSupported) {
            args.add("--rubymine-protocol-extensions");
        }
    }

    @Override
    public boolean needsDebugPreLoader() {
        return true;
    }

    @Override
    public boolean supportsNonSuspendedFramesReading(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(21);
        }
        return !RubySdkUtil.isNativeRuby20(sdk) && !RubySdkUtil.isNativeRuby21(sdk) && !RubySdkUtil.isNativeRuby22(sdk) && !RubySdkUtil.isNativeRuby23(sdk) && !RubySdkUtil.isNativeRuby24(sdk) && !RubySdkUtil.isNativeRuby25(sdk) && !RubySdkUtil.isNativeRuby26(sdk);
    }

    @Override
    public boolean supportsCatchpointRemoval() {
        return this.A != null && this.A.myCatchPointRemovalSupported;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@Nullable Project project) {
        if (project == null || !this.supportFileFiltering()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                RubyDebugIdeGemHelper.a(22);
            }
            return list2;
        }
        List<VirtualFile> list3 = Arrays.asList(ProjectRootManager.getInstance((Project)project).getContentRoots());
        if (list3 == null) {
            RubyDebugIdeGemHelper.a(23);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<VirtualFile> getExcludedDirs(@Nullable Project project) {
        if (project == null || !this.supportFileFiltering()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                RubyDebugIdeGemHelper.a(24);
            }
            return list2;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ContainerUtil.addAll((Collection)arrayList, (Object[])ModuleRootManager.getInstance((Module)module).getExcludeRoots());
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            RubyDebugIdeGemHelper.a(25);
        }
        return arrayList2;
    }

    @Override
    public boolean supportFileFiltering() {
        return this.A != null && this.A.myFileFilterSupported;
    }

    @Override
    public boolean pauseActionSupported() {
        return true;
    }

    @Override
    public boolean debugConsoleSupported(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(26);
        }
        return this.A != null && this.A.myDebugConsoleSupported;
    }

    @Nullable
    protected static String getOrInstallDebugIdeGem(@Nullable Module module, @NotNull Sdk sdk, @NotNull String ideName) throws ExecutionException {
        String string;
        long l2 = C ^ 0xE10DE3081B4L;
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(27);
        }
        if (ideName == null) {
            RubyDebugIdeGemHelper.a(28);
        }
        DebugGemType debugGemType = DebugGemType.getBaseType(sdk);
        boolean bl2 = LanguageLevel.RUBY19.isLessThan(RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk));
        boolean bl3 = RubyExperimentalDebuggerTopHitProvider.EXPERIMENTAL_DEBUGGER_OPTION_DESCRIPTOR.isOptionEnabled();
        Pattern pattern = bl3 ? c : e;
        GemInfo gemInfo = RubyDebugIdeGemHelper.a(ideName, module, sdk, pattern);
        DebugGemType debugGemType2 = bl3 ? DebugGemType.IDE : DebugGemType.IDE_STABLE;
        boolean bl4 = debugGemType2.a(gemInfo);
        String string2 = debugGemType.getGemName();
        GemInfo gemInfo2 = bl2 && !JRubySdkUtil.isJRubySDK(sdk) ? RubyDebugIdeGemHelper.a(string2, module, sdk, bl3 ? z : y) : RubyDebugIdeGemHelper.findGem(string2, module, sdk);
        boolean bl5 = debugGemType.a(gemInfo2);
        if (gemInfo != null && bl4 && bl5) {
            return gemInfo.getVersion();
        }
        String string3 = RubySdkType.getPlatform(sdk);
        if (gemInfo2 == null) {
            string = RBundle.message((String)"gems.install.debug.gem", (Object[])new Object[]{string2});
        } else if (!bl5 && !RubyDebugIdeGemHelper.a(sdk, debugGemType)) {
            string = RBundle.message((String)"gems.update.debug.gem", (Object[])new Object[]{string2});
        } else if (gemInfo == null) {
            string = RBundle.message((String)"gems.install.debug.gem", (Object[])new Object[]{ideName});
        } else if (!bl4 && !RubyDebugIdeGemHelper.a(sdk, debugGemType2)) {
            string = RBundle.message((String)"gems.update.debug.gem", (Object[])new Object[]{ideName});
        } else {
            return gemInfo.getVersion();
        }
        int n2 = Messages.showYesNoDialog((Project)RModuleUtil.getInstance().getProject(module), (String)string, (String)RBundle.message((String)"gems.debugger.alert.title"), (Icon)Messages.getQuestionIcon());
        if (n2 == 0) {
            Object object;
            List<GemDependency> list2;
            Pattern pattern2;
            HashMap<GemDependency, String> hashMap = new HashMap<GemDependency, String>();
            boolean bl6 = RubySdkUtil.isRuby18(sdk);
            boolean bl7 = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().isWindows();
            boolean bl8 = JRubySdkUtil.isJRubySDK(sdk);
            Pattern pattern3 = pattern2 = bl3 ? a : l;
            if (bl8) {
                list2 = GemInstallUtil.findBundledGemsToInstall(RBundle.message((String)"gems.bundled.jruby.debug.not.found"), r, pattern2);
            } else if (bl7 && bl6 && RubyDebugIdeGemHelper.a(string3)) {
                list2 = GemInstallUtil.findBundledGemsToInstall(RBundle.message((String)"gems.bundled.win32.debug.not.found"), j, pattern2);
                list2.add(0, GemDependency.any("linecache"));
            } else {
                object = bl2 ? (bl3 ? n : v) : (bl6 ? t : g);
                list2 = GemInstallUtil.findBundledGemsToInstall(RBundle.message((String)"gems.bundled.debug.not.found"), new Pattern[]{object, pattern2});
            }
            GemInstallUtil.installGemsRequirements(sdk, module, list2, !bl8, false, false, false, false, null, hashMap);
            object = GemUiUtil.buildInstallErrorsText(hashMap);
            if (object != null) {
                throw new ExecutionException(RBundle.message((String)"gems.gem.installing.failed") + ". " + (String)object);
            }
            RubyDebugIdeGemHelper.a(sdk, debugGemType2, debugGemType);
            GemInfo gemInfo3 = RubyDebugIdeGemHelper.a(ideName, module, sdk, pattern);
            return gemInfo3 != null ? gemInfo3.getVersion() : null;
        }
        RubyDebugIdeGemHelper.a(sdk, debugGemType2, debugGemType);
        return gemInfo != null && gemInfo2 != null ? gemInfo.getVersion() : null;
    }

    @Nullable
    private static GemInfo a(@NotNull String string, @Nullable Module module, @NotNull Sdk sdk, @NotNull Pattern pattern) {
        if (string == null) {
            RubyDebugIdeGemHelper.a(29);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(30);
        }
        if (pattern == null) {
            RubyDebugIdeGemHelper.a(31);
        }
        Collection<GemInfo> collection = GemManager.getInstance().getAllGems(sdk, module);
        return GemSearchUtil.findGem(collection, (Function<? super GemInfo, Boolean>)((Function)gemInfo -> {
            if (string == null) {
                RubyDebugIdeGemHelper.a(39);
            }
            if (pattern == null) {
                RubyDebugIdeGemHelper.a(40);
            }
            return gemInfo.getName().equals(string) && pattern.matcher(gemInfo.getVersion()).matches();
        }));
    }

    @Nullable
    private static GemInfo a(@NotNull String string, @Nullable String string2, @Nullable Module module, @NotNull Sdk sdk) {
        if (string == null) {
            RubyDebugIdeGemHelper.a(32);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(33);
        }
        GemInfo gemInfo = null;
        if (module != null) {
            gemInfo = GemSearchUtil.findGem(module, sdk, string, string2);
        }
        return gemInfo != null ? gemInfo : GemSearchUtil.findGem(module, sdk, string, string2);
    }

    private static void a(Sdk sdk, DebugGemType debugGemType, DebugGemType debugGemType2) {
        PropertiesComponent.getInstance().setValue(RubyDebugIdeGemHelper.b(sdk, debugGemType2), debugGemType2.getVersion(), null);
        PropertiesComponent.getInstance().setValue(RubyDebugIdeGemHelper.b(sdk, debugGemType), debugGemType.getVersion(), null);
    }

    private static boolean a(@NotNull Sdk sdk, DebugGemType debugGemType) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(34);
        }
        return VersionComparatorUtil.compare((String)PropertiesComponent.getInstance().getValue(RubyDebugIdeGemHelper.b(sdk, debugGemType)), (String)debugGemType.getVersion()) >= 0;
    }

    private static String b(Sdk sdk, DebugGemType debugGemType) {
        return sdk.getHomePath() + ":" + debugGemType.name();
    }

    private static boolean a(String string) {
        long l2 = C ^ 0x295575D6B7DFL;
        return string != null && string.contains("i386") && (RubySdkUtil.isMswin32(string) || RubySdkUtil.isMingw32(string));
    }

    @Nullable
    public static State createState(@Nullable Module module, @NotNull Sdk sdk, @Nullable String gemVersion, @NotNull RubyDebugMode mode) throws ExecutionException {
        VirtualFile virtualFile;
        Object object;
        long l2 = C ^ 0x44677A5F0E60L;
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(35);
        }
        if (mode == null) {
            RubyDebugIdeGemHelper.a(36);
        }
        if (gemVersion == null) {
            return null;
        }
        GemInfo gemInfo = RubyDebugIdeGemHelper.a(RDEBUG_IDE_GEM_NAME, gemVersion, module, sdk);
        GemInfo gemInfo2 = RubyDebugIdeGemHelper.findGem(DebugGemType.getBaseType(sdk).getGemName(), module, sdk);
        if (gemInfo == null || !gemInfo.isValid() || gemInfo2 == null || !gemInfo2.isValid()) {
            return null;
        }
        boolean bl2 = RubyDebugIdeGemHelper.a(sdk, gemInfo2);
        GemInfo gemInfo3 = null;
        if (bl2 && ((gemInfo3 = GemSearchUtil.findGem(module, sdk, (String)(object = RubySdkUtil.isRuby19(sdk) && !JRubySdkUtil.isJRubySDK(sdk) ? "linecache19" : "linecache"), null)) == null || !gemInfo3.isValid())) {
            String string = RBundle.message((String)"ruby.debugger.cannot.start.debug", (Object[])new Object[]{RBundle.message((String)"ruby.debugger.cannot.find.gem", (Object[])new Object[]{object})});
            throw new ExecutionException(string);
        }
        object = gemInfo.getFile();
        assert (object != null);
        String string = GemUtil.findScriptInBinDir(mode.getDebugScript(), object.findChild("bin"));
        VirtualFile virtualFile2 = gemInfo.getLibFolder();
        VirtualFile virtualFile3 = gemInfo2.getLibFolder();
        VirtualFile virtualFile4 = virtualFile = gemInfo3 != null ? gemInfo3.getLibFolder() : null;
        if (string == null || virtualFile2 == null || virtualFile3 == null || bl2 && virtualFile == null) {
            return null;
        }
        return new State(bl2, string, virtualFile2, virtualFile3, virtualFile, gemInfo, null);
    }

    private static boolean a(@NotNull Sdk sdk, @NotNull GemInfo gemInfo) {
        long l2 = C ^ 0x451B57DA2848L;
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(37);
        }
        if (gemInfo == null) {
            RubyDebugIdeGemHelper.a(38);
        }
        String string = sdk.getVersionString();
        if (RubySdkUtil.isRuby18(sdk) && string != null && string.contains("1.8.6")) {
            return false;
        }
        if (k.equals(gemInfo.getName())) {
            return false;
        }
        String string2 = f.equals(gemInfo.getName()) ? "0.11.30.pre10" : "0.10.5.rc9";
        return VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)string2) <= 0;
    }

    static {
        C = la.a(-890641765781608129L, -1598084796044568608L, MethodHandles.lookup().lookupClass()).a(74763802536073L);
        long l2 = C ^ 0x2AA60E7AD091L;
        r = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*)-java.gem");
        t = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*).gem");
        g = Pattern.compile("ruby-debug-base19x-([0-9]+(\\.[0-9A-z]+)*).gem");
        j = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*)(-x86)?-mswin32.gem");
        e = Pattern.compile(q);
        c = Pattern.compile(x);
        a = Pattern.compile("ruby-debug-ide-(0\\.7(\\.[0-9A-z]+)*).gem");
        l = Pattern.compile("ruby-debug-ide-(0\\.6(\\.[0-9A-z]+)*).gem");
        y = Pattern.compile("(0\\.2(\\.[0-9A-z]+)*)");
        z = Pattern.compile("(0\\.2(\\.[0-9A-z]+)*)");
        n = Pattern.compile("debase-(0\\.2(\\.[0-9A-z]+)*).gem");
        v = Pattern.compile("debase-(0\\.2(\\.[0-9A-z]+)*).gem");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = C ^ 0x3946E5EF4280L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 3: 
            case 29: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 2: 
            case 6: 
            case 21: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "askedProperty";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideName";
                break;
            }
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdebugIdeGemName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdebugFrontEndGemName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRubyLib";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdebugScriptPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMsg";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedDirs";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findGem";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkForGemPresence";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRdebugFrontEndGemName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateRubyLib";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "enableVerboseMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "enableKeyValuePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disableIntHandler";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationTimeout";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enableEvaluationControl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationTimeLimit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationMemoryLimit";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addGemSpecificArgs";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "supportsNonSuspendedFramesReading";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "debugConsoleSupported";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOrInstallDebugIdeGem";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findGemByVersionPattern";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "alreadyAskedToUpdate";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isLineCacheNeeded";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findGemByVersionPattern$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        @NotNull
        private static final String c = "0.4.17.beta9";
        @NotNull
        private static final String h = "0.4.23.beta2";
        @NotNull
        private static final String b = "0.6.1.beta9";
        @NotNull
        private static final String a = "0.4.23.beta2";
        @NotNull
        private static final String d = "0.4.24.beta4";
        @NotNull
        private static final String f = "0.5.0";
        @NotNull
        private static final String g = "0.6.0.pre1";
        @NotNull
        private static final String e = "0.7.0.beta5";
        public final boolean myLineCacheNeeded;
        public final boolean myMultiProcessDebugSupported;
        public final boolean myTimeoutConfigurable;
        public final boolean myEvaluationControlConfigurable;
        public final boolean myDebugConsoleSupported;
        public final boolean myCatchPointRemovalSupported;
        public final boolean myRmProtocolExtensionsSupported;
        public final boolean myFileFilterSupported;
        public final boolean myKeyValueHashAvailable;
        @NotNull
        public final String myRDebugScriptPath;
        @NotNull
        public final VirtualFile myIdeLib;
        @NotNull
        public final VirtualFile myBaseLib;
        @Nullable
        public final VirtualFile myLineCacheLib;
        private static final long i = la.a(-3744793159439667465L, 6145176642209883863L, MethodHandles.lookup().lookupClass()).a(100594346345338L);

        private State(boolean lineCacheNeeded, @NotNull String rDebugScriptPath, @NotNull VirtualFile ideLib, @NotNull VirtualFile baseLib, @Nullable VirtualFile lineCacheLib, @Nullable GemInfo gemInfo) {
            long l2 = i ^ 0x2925A55B1D6AL;
            if (rDebugScriptPath == null) {
                State.a(0);
            }
            if (ideLib == null) {
                State.a(1);
            }
            if (baseLib == null) {
                State.a(2);
            }
            this.myLineCacheNeeded = lineCacheNeeded;
            if (gemInfo != null) {
                String string = gemInfo.getVersion();
                this.myMultiProcessDebugSupported = VersionComparatorUtil.compare((String)string, (String)c) > 0;
                this.myTimeoutConfigurable = VersionComparatorUtil.compare((String)string, (String)"0.4.23.beta2") >= 0;
                this.myEvaluationControlConfigurable = VersionComparatorUtil.compare((String)string, (String)b) >= 0;
                this.myDebugConsoleSupported = VersionComparatorUtil.compare((String)string, (String)"0.4.23.beta2") >= 0;
                this.myRmProtocolExtensionsSupported = VersionComparatorUtil.compare((String)string, (String)d) >= 0;
                this.myCatchPointRemovalSupported = VersionComparatorUtil.compare((String)string, (String)f) >= 0;
                this.myFileFilterSupported = VersionComparatorUtil.compare((String)string, (String)g) >= 0;
                this.myKeyValueHashAvailable = VersionComparatorUtil.compare((String)string, (String)e) >= 0;
            } else {
                this.myMultiProcessDebugSupported = false;
                this.myTimeoutConfigurable = false;
                this.myEvaluationControlConfigurable = false;
                this.myDebugConsoleSupported = false;
                this.myRmProtocolExtensionsSupported = false;
                this.myCatchPointRemovalSupported = false;
                this.myFileFilterSupported = false;
                this.myKeyValueHashAvailable = false;
            }
            this.myRDebugScriptPath = rDebugScriptPath;
            this.myIdeLib = ideLib;
            this.myBaseLib = baseLib;
            this.myLineCacheLib = lineCacheLib;
            assert (!lineCacheNeeded || lineCacheLib != null);
        }

        /* synthetic */ State(boolean x0, String x1, VirtualFile x2, VirtualFile x3, VirtualFile x4, GemInfo x5, a x6) {
            this(x0, x1, x2, x3, x4, x5);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = i ^ 0x3BD3EA0E828DL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rDebugScriptPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ideLib";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseLib";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$State";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DebugGemType
    extends Enum<DebugGemType> {
        public static final /* enum */ DebugGemType BASE_18;
        public static final /* enum */ DebugGemType BASE_19;
        public static final /* enum */ DebugGemType BASE_20;
        public static final /* enum */ DebugGemType BASE_JAVA_18;
        public static final /* enum */ DebugGemType BASE_JAVA_19;
        public static final /* enum */ DebugGemType BASE_JAVA_20;
        public static final /* enum */ DebugGemType BASE_RBX_18;
        public static final /* enum */ DebugGemType BASE_RBX_19;
        public static final /* enum */ DebugGemType BASE_RBX_20;
        public static final /* enum */ DebugGemType IDE_STABLE;
        public static final /* enum */ DebugGemType IDE;
        private final String b;
        private final String a;
        private static final /* synthetic */ DebugGemType[] c;
        private static final long d;

        public static DebugGemType[] values() {
            return (DebugGemType[])c.clone();
        }

        public static DebugGemType valueOf(String name) {
            return Enum.valueOf(DebugGemType.class, name);
        }

        private DebugGemType(String version, String name) {
            if (version == null) {
                DebugGemType.a(0);
            }
            if (name == null) {
                DebugGemType.a(1);
            }
            this.b = version;
            this.a = name;
        }

        @NotNull
        public String getVersion() {
            String string = this.b;
            if (string == null) {
                DebugGemType.a(2);
            }
            return string;
        }

        @NotNull
        public String getGemName() {
            String string = this.a;
            if (string == null) {
                DebugGemType.a(3);
            }
            return string;
        }

        public static DebugGemType getBaseType(Sdk sdk) {
            long l2 = d ^ 0x3B81D71667BBL;
            String string = RubySdkUtil.isRubinius(sdk) ? "BASE_RBX" : (JRubySdkUtil.isJRubySDK(sdk) ? "BASE_JAVA" : "BASE");
            String string2 = LanguageLevel.RUBY19.isLessThan(RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk)) ? "_20" : (RubySdkUtil.isRuby19(sdk) ? "_19" : "_18");
            return DebugGemType.valueOf(string + string2);
        }

        private boolean a(GemInfo gemInfo) {
            if (gemInfo == null) {
                return false;
            }
            String string = gemInfo.getVersion();
            return VersionComparatorUtil.compare((String)string, (String)this.getVersion()) >= 0;
        }

        static {
            d = la.a(-3249834214690287293L, -8285267410788927920L, MethodHandles.lookup().lookupClass()).a(211302140151721L);
            long l2 = d ^ 0x532DBA590E36L;
            BASE_18 = new DebugGemType(RubyDebugIdeGemHelper.s, RubyDebugIdeGemHelper.p);
            BASE_19 = new DebugGemType(RubyDebugIdeGemHelper.d, RubyDebugIdeGemHelper.f);
            BASE_20 = new DebugGemType(RubyDebugIdeGemHelper.h, RubyDebugIdeGemHelper.k);
            BASE_JAVA_18 = new DebugGemType(RubyDebugIdeGemHelper.w, RubyDebugIdeGemHelper.p);
            BASE_JAVA_19 = new DebugGemType(RubyDebugIdeGemHelper.w, RubyDebugIdeGemHelper.p);
            BASE_JAVA_20 = new DebugGemType(RubyDebugIdeGemHelper.w, RubyDebugIdeGemHelper.p);
            BASE_RBX_18 = new DebugGemType(RubyDebugIdeGemHelper.h, RubyDebugIdeGemHelper.k);
            BASE_RBX_19 = new DebugGemType(RubyDebugIdeGemHelper.h, RubyDebugIdeGemHelper.k);
            BASE_RBX_20 = new DebugGemType(RubyDebugIdeGemHelper.h, RubyDebugIdeGemHelper.k);
            IDE_STABLE = new DebugGemType(RubyDebugIdeGemHelper.i, RubyDebugIdeGemHelper.RDEBUG_IDE_GEM_NAME);
            IDE = new DebugGemType(RubyDebugIdeGemHelper.B, RubyDebugIdeGemHelper.RDEBUG_IDE_GEM_NAME);
            c = new DebugGemType[]{BASE_18, BASE_19, BASE_20, BASE_JAVA_18, BASE_JAVA_19, BASE_JAVA_20, BASE_RBX_18, BASE_RBX_19, BASE_RBX_20, IDE_STABLE, IDE};
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x6246902B94E7L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$DebugGemType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$DebugGemType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

