/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.rhtml.lang.formatter.helpers;

import b.h.la;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ERbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ERbRubyInjectionTag;
import org.jetbrains.plugins.ruby.erb.psi.ERbTokenTypes;
import org.jetbrains.plugins.ruby.erb.psi.impl.ERbRubyInjectionTagNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;

public class RHTMLFormatterUtil {
    private static final long a = la.a(-3638105395990125550L, 1598804591080235619L, MethodHandles.lookup().lookupClass()).a(42571734520318L);

    private RHTMLFormatterUtil() {
    }

    static TextRange safelyCreateTextRange(int startOffset, int endOffset) {
        return startOffset < endOffset ? new TextRange(startOffset, endOffset) : null;
    }

    public static boolean canBeCorrectBlock(@Nullable ASTNode node) {
        return node != null && node.getText().trim().length() > 0;
    }

    public static boolean containsTextRange(TextRange container, TextRange range) {
        return container.getStartOffset() <= range.getStartOffset() && container.getEndOffset() >= range.getEndOffset();
    }

    @Nullable
    public static ASTNode getNodeByBlockForRHTMLFormatter(Block child1) {
        if (child1 instanceof AbstractBlock) {
            return ((AbstractBlock)child1).getNode();
        }
        if (child1 instanceof RubyBlock) {
            return ((RubyBlock)child1).getNode();
        }
        return null;
    }

    @Nullable
    public static RCompoundStatement getParentRCmpStByRHTMLOrHTMLChildNode(@NotNull FileViewProvider provider, @NotNull ASTNode node) {
        RCompoundStatement rCompoundStatement;
        if (provider == null) {
            RHTMLFormatterUtil.a(0);
        }
        if (node == null) {
            RHTMLFormatterUtil.a(1);
        }
        if ((rCompoundStatement = RHTMLFormatterUtil.getRCmpStNodeStartOffset(provider, node)) == null) {
            return null;
        }
        return RHTMLFormatterUtil.isRHTMLXmlTagForRubyBlockEnd(node, rCompoundStatement, provider) ? RCompoundStatementNavigator.getParentCompoundStatement((PsiElement)rCompoundStatement) : rCompoundStatement;
    }

    @Nullable
    public static RCompoundStatement getRCmpStNodeStartOffset(@NotNull FileViewProvider provider, @NotNull ASTNode node) {
        int n2;
        PsiElement psiElement;
        if (provider == null) {
            RHTMLFormatterUtil.a(2);
        }
        if (node == null) {
            RHTMLFormatterUtil.a(3);
        }
        if ((psiElement = provider.findElementAt(n2 = node.getStartOffset(), (Language)RubyLanguage.INSTANCE)) == null) {
            return null;
        }
        if (psiElement instanceof RCompoundStatement) {
            return (RCompoundStatement)psiElement;
        }
        return RCompoundStatementNavigator.getByPsiElement(psiElement);
    }

    @Nullable
    public static PsiElement findUpperHTMLElement(@NotNull FileViewProvider provider, int startOffset, @Nullable TextRange boundsTRange) {
        TextRange textRange;
        TextRange textRange2;
        PsiElement psiElement;
        if (provider == null) {
            RHTMLFormatterUtil.a(4);
        }
        PsiElement psiElement2 = (psiElement = provider.findElementAt(startOffset, (Language)HTMLLanguage.INSTANCE)) != null ? psiElement.getParent() : null;
        TextRange textRange3 = textRange2 = psiElement2 != null ? psiElement2.getTextRange() : null;
        while (!(psiElement instanceof XmlText || psiElement instanceof XmlDocument || RHTMLFormatterUtil.isRegisteredContainerElement(psiElement) || textRange2 == null || textRange2.getStartOffset() != startOffset || boundsTRange != null && !RHTMLFormatterUtil.isRegisteredContainerElement(psiElement2) && !RHTMLFormatterUtil.containsTextRange(boundsTRange, textRange2))) {
            psiElement2 = (psiElement = psiElement.getParent()) != null ? psiElement.getParent() : null;
            textRange2 = psiElement2 != null ? psiElement2.getTextRange() : null;
        }
        if (psiElement instanceof XmlText || psiElement instanceof XmlDocument) {
            psiElement = psiElement.getFirstChild();
        }
        if (psiElement instanceof XmlProlog) {
            psiElement = psiElement.getNextSibling();
        }
        TextRange textRange4 = textRange = psiElement != null ? psiElement.getTextRange() : null;
        if (boundsTRange != null && textRange != null && !boundsTRange.intersectsStrict(textRange)) {
            return null;
        }
        return psiElement;
    }

    public static PsiElement findRHTMLElementByStartOffset(FileViewProvider vProvider, int startOffset, boolean searchHighest) {
        PsiElement psiElement = vProvider.findElementAt(startOffset, (Language)ERbLanguage.RHTML);
        if (searchHighest && psiElement != null) {
            for (PsiElement psiElement2 = psiElement.getParent(); psiElement2 != null && !(psiElement2 instanceof XmlDocument) && psiElement2.getTextRange().getStartOffset() == startOffset; psiElement2 = psiElement2.getParent()) {
                psiElement = psiElement2;
            }
        }
        return psiElement;
    }

    public static boolean isRHTMLXmlTagForRubyBlockEnd(@NotNull ASTNode rhtmlTagNode, @NotNull RCompoundStatement nodeCmpSt, @NotNull FileViewProvider vProvider) {
        PsiElement psiElement;
        if (rhtmlTagNode == null) {
            RHTMLFormatterUtil.a(5);
        }
        if (nodeCmpSt == null) {
            RHTMLFormatterUtil.a(6);
        }
        if (vProvider == null) {
            RHTMLFormatterUtil.a(7);
        }
        if ((psiElement = RHTMLFormatterUtil.findRHTMLElementByStartOffset(vProvider, nodeCmpSt.getTextRange().getEndOffset() - 1, false)) != null) {
            ERbRubyInjectionTag eRbRubyInjectionTag = ERbRubyInjectionTagNavigator.getByPsiElement(psiElement);
            ASTNode aSTNode = eRbRubyInjectionTag != null ? eRbRubyInjectionTag.getNode() : null;
            return aSTNode != null && aSTNode.getTextRange().equals((Object)rhtmlTagNode.getTextRange());
        }
        return false;
    }

    public static boolean isRegisteredContainerElement(PsiElement htmlPsi) {
        return RHTMLFormatterUtil.isTagOrAttrElementOrAttrValue(htmlPsi) || RHTMLFormatterUtil.isSpecialElement(htmlPsi);
    }

    public static boolean isHTMLDocumentRootOrProlog(ASTNode parentNode) {
        IElementType iElementType = parentNode.getElementType();
        return iElementType == XmlElementType.HTML_DOCUMENT || iElementType == XmlElementType.XML_PROLOG || iElementType == XmlElementType.XML_PROCESSING_INSTRUCTION;
    }

    public static boolean isTagOrAttrElementOrAttrValue(PsiElement htmlPsi) {
        return htmlPsi instanceof XmlTag || htmlPsi instanceof XmlAttribute || htmlPsi instanceof XmlAttributeValue || htmlPsi instanceof XmlDoctype || htmlPsi instanceof XmlProcessingInstruction;
    }

    public static boolean isSpecialElement(PsiElement htmlPsi) {
        return RHTMLFormatterUtil.isJSEmbeddedContent(htmlPsi);
    }

    public static boolean isScripletRHTMLXmlTagNode(@NotNull ASTNode rhtmlTagNode) {
        ASTNode aSTNode;
        if (rhtmlTagNode == null) {
            RHTMLFormatterUtil.a(8);
        }
        return (aSTNode = rhtmlTagNode.getFirstChildNode()) != null && aSTNode.getElementType() == ERbTokenTypes.ERB_SCRIPTLET_START;
    }

    static boolean isJSEmbeddedContent(PsiElement htmlPsi) {
        return htmlPsi != null && !(htmlPsi.getLanguage() instanceof XMLLanguage) && htmlPsi.getLanguage() != Language.ANY;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x2A9A489854A7L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhtmlTagNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCmpSt";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vProvider";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/rhtml/lang/formatter/helpers/RHTMLFormatterUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentRCmpStByRHTMLOrHTMLChildNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRCmpStNodeStartOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpperHTMLElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRHTMLXmlTagForRubyBlockEnd";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isScripletRHTMLXmlTagNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

