/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.marker.ui;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.marker.MarkerBar;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.plaf.ComponentUI;

public class MarkerBarUI
extends ComponentUI {
    protected int MARKER_BODY_WIDTH = 12;
    protected int MARKER_BODY_HEIGHT = 12;
    protected int MARKER_BICK_HEIGHT = 6;
    protected int baselineLeft;
    protected int baselineTop;
    protected int baselineLength;
    protected Rectangle viewRect = new Rectangle();
    protected Polygon[] polys = new Polygon[0];

    protected Polygon[] calculateMarkerAreas(MarkerBar bar) {
        int i;
        BoundedTableModel model = bar.getDataModel();
        int count = model.getRowCount();
        if (this.polys.length < count) {
            this.polys = new Polygon[count * 2];
            for (i = 0; i < this.polys.length; ++i) {
                Polygon p;
                int[] xx = new int[5];
                int[] yy = new int[5];
                this.polys[i] = p = new Polygon(xx, yy, 5);
            }
        }
        for (i = 0; i < count; ++i) {
            int intValueAt = (Integer)model.getValueAt(i, bar.getPositionColumn());
            int logicalOffset = intValueAt - model.getLowerBound();
            int baselineOffset = this.logicalOffsetToBaselineOffset(logicalOffset, model);
            int[] xx = this.polys[i].xpoints;
            int[] yy = this.polys[i].ypoints;
            if (bar.getOrientation() == 0) {
                int x = this.baselineLeft + baselineOffset;
                if (bar.isFliped()) {
                    xx[0] = x;
                    yy[0] = this.baselineTop;
                    xx[1] = x + this.MARKER_BODY_WIDTH / 2;
                    yy[1] = this.baselineTop + this.MARKER_BICK_HEIGHT;
                    xx[2] = x + this.MARKER_BODY_WIDTH / 2;
                    yy[2] = this.baselineTop + this.MARKER_BICK_HEIGHT + this.MARKER_BODY_HEIGHT;
                    xx[3] = x - this.MARKER_BODY_WIDTH / 2;
                    yy[3] = this.baselineTop + this.MARKER_BICK_HEIGHT + this.MARKER_BODY_HEIGHT;
                    xx[4] = x - this.MARKER_BODY_WIDTH / 2;
                    yy[4] = this.baselineTop + this.MARKER_BICK_HEIGHT;
                } else {
                    xx[0] = x;
                    yy[0] = this.baselineTop;
                    xx[1] = x + this.MARKER_BODY_WIDTH / 2;
                    yy[1] = this.baselineTop - this.MARKER_BICK_HEIGHT;
                    xx[2] = x + this.MARKER_BODY_WIDTH / 2;
                    yy[2] = this.baselineTop - this.MARKER_BICK_HEIGHT - this.MARKER_BODY_HEIGHT;
                    xx[3] = x - this.MARKER_BODY_WIDTH / 2;
                    yy[3] = this.baselineTop - this.MARKER_BICK_HEIGHT - this.MARKER_BODY_HEIGHT;
                    xx[4] = x - this.MARKER_BODY_WIDTH / 2;
                    yy[4] = this.baselineTop - this.MARKER_BICK_HEIGHT;
                }
            } else {
                int y = this.baselineLeft + baselineOffset;
                if (bar.isFliped()) {
                    xx[0] = this.baselineTop;
                    yy[0] = y;
                    yy[1] = y + this.MARKER_BODY_WIDTH / 2;
                    xx[1] = this.baselineTop - this.MARKER_BICK_HEIGHT;
                    yy[2] = y + this.MARKER_BODY_WIDTH / 2;
                    xx[2] = this.baselineTop - this.MARKER_BICK_HEIGHT - this.MARKER_BODY_HEIGHT;
                    yy[3] = y - this.MARKER_BODY_WIDTH / 2;
                    xx[3] = this.baselineTop - this.MARKER_BICK_HEIGHT - this.MARKER_BODY_HEIGHT;
                    yy[4] = y - this.MARKER_BODY_WIDTH / 2;
                    xx[4] = this.baselineTop - this.MARKER_BICK_HEIGHT;
                } else {
                    xx[0] = this.baselineTop;
                    yy[0] = y;
                    yy[1] = y + this.MARKER_BODY_WIDTH / 2;
                    xx[1] = this.baselineTop + this.MARKER_BICK_HEIGHT;
                    yy[2] = y + this.MARKER_BODY_WIDTH / 2;
                    xx[2] = this.baselineTop + this.MARKER_BICK_HEIGHT + this.MARKER_BODY_HEIGHT;
                    yy[3] = y - this.MARKER_BODY_WIDTH / 2;
                    xx[3] = this.baselineTop + this.MARKER_BICK_HEIGHT + this.MARKER_BODY_HEIGHT;
                    yy[4] = y - this.MARKER_BODY_WIDTH / 2;
                    xx[4] = this.baselineTop + this.MARKER_BICK_HEIGHT;
                }
            }
            this.polys[i].invalidate();
        }
        return this.polys;
    }

    protected int logicalOffsetToBaselineOffset(int logicalOffset, BoundedTableModel model) {
        int positionRange = model.getUpperBound() - model.getLowerBound();
        return logicalOffset * this.baselineLength / positionRange;
    }

    protected int baselineOffsetToLogicalOffset(int baselineOffset, BoundedTableModel model) {
        int positionRange = model.getUpperBound() - model.getLowerBound();
        return baselineOffset * positionRange / this.baselineLength;
    }

    protected int componentOffsetToLogicalOffset(int componentOffsetLeft, BoundedTableModel dataModel) {
        return this.baselineOffsetToLogicalOffset(componentOffsetLeft - this.baselineLeft, dataModel);
    }

    protected void calculateViewRectAndBaseline(MarkerBar bar) {
        Insets insets = bar.getInsets();
        this.viewRect.x = insets.left;
        this.viewRect.y = insets.top;
        this.viewRect.width = bar.getWidth() - (insets.right + this.viewRect.x);
        this.viewRect.height = bar.getHeight() - (insets.bottom + this.viewRect.y);
        if (bar.getOrientation() == 0) {
            this.baselineLeft = this.viewRect.x + this.MARKER_BODY_WIDTH / 2;
            this.baselineLength = this.viewRect.width - this.MARKER_BODY_WIDTH - 1;
            this.baselineTop = bar.isFliped() ? this.viewRect.y : this.viewRect.y + this.viewRect.height - 1;
        } else {
            this.baselineLeft = this.viewRect.y + this.MARKER_BODY_WIDTH / 2;
            this.baselineLength = this.viewRect.height - this.MARKER_BODY_WIDTH - 1;
            this.baselineTop = bar.isFliped() ? this.viewRect.x + this.viewRect.width - 1 : this.viewRect.x;
        }
    }

    public int getMarkerSideGap() {
        return this.MARKER_BODY_WIDTH / 2;
    }
}

