/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.io.File;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.wiztools.commons.CollectionsUtil;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapArrayList;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.CookieVersion;
import org.wiztools.restclient.bean.HTTPMethod;
import org.wiztools.restclient.bean.HTTPVersion;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntitySimple;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.RequestBean;
import org.wiztools.restclient.bean.RequestExecuter;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.bean.ResponseBean;
import org.wiztools.restclient.bean.SSLReq;
import org.wiztools.restclient.ui.FileOpenUtil;
import org.wiztools.restclient.ui.FontableEditor;
import org.wiztools.restclient.ui.MessageDialog;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.ScrollableComponent;
import org.wiztools.restclient.ui.StatusBarPanel;
import org.wiztools.restclient.ui.TwoColumnTablePanel;
import org.wiztools.restclient.ui.dnd.FileDropTargetListener;
import org.wiztools.restclient.ui.history.HistoryManager;
import org.wiztools.restclient.ui.reqauth.ReqAuthPanel;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;
import org.wiztools.restclient.ui.reqetc.ReqEtcPanel;
import org.wiztools.restclient.ui.reqgo.ReqUrlGoPanel;
import org.wiztools.restclient.ui.reqmethod.ReqMethodPanel;
import org.wiztools.restclient.ui.reqssl.ReqSSLPanel;
import org.wiztools.restclient.ui.reqtest.ReqTestPanel;
import org.wiztools.restclient.ui.resbody.ResBodyPanel;
import org.wiztools.restclient.ui.resheader.ResHeaderPanel;
import org.wiztools.restclient.ui.resstats.ResStatsPanel;
import org.wiztools.restclient.ui.resstatus.ResStatusPanel;
import org.wiztools.restclient.ui.restest.ResTestPanel;
import org.wiztools.restclient.util.ContentTypesCommon;
import org.wiztools.restclient.util.HttpUtil;
import org.wiztools.restclient.util.Util;

@Singleton
public class RESTViewImpl
extends JPanel
implements RESTView {
    private static final Logger LOG = Logger.getLogger(RESTViewImpl.class.getName());
    @Inject
    private ReqUrlGoPanel jp_url_go;
    @Inject
    private StatusBarPanel jp_status_bar;
    @Inject
    private ReqMethodPanel jp_req_method;
    @Inject
    private ReqBodyPanel jp_req_body;
    @Inject
    private ReqAuthPanel jp_req_auth;
    @Inject
    private ReqSSLPanel jp_req_ssl;
    @Inject
    private ReqEtcPanel jp_req_etc;
    @Inject
    private ReqTestPanel jp_req_test;
    @Inject
    private ResStatusPanel jp_res_status;
    @Inject
    private ResHeaderPanel jp_res_headers;
    @Inject
    private ResBodyPanel jp_res_body;
    @Inject
    private ResTestPanel jp_res_test;
    @Inject
    private ResStatsPanel jp_res_stats;
    @Inject
    private MessageDialog messageDialog;
    @Inject
    private RESTUserInterface rest_ui;
    @Inject
    private HistoryManager historyManager;
    private TwoColumnTablePanel jp_2col_req_headers;
    private TwoColumnTablePanel jp_2col_req_cookies;
    private RESTView view = this;
    private Thread requestThread;
    private Response lastResponse;

    private JTabbedPane initJTPRequest() {
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("Method", this.jp_req_method.getComponent());
        this.jp_2col_req_headers = new TwoColumnTablePanel(new String[]{"Header", "Value"}, ContentTypesCommon.getCommon(), this.rest_ui);
        jtp.addTab("Header", this.jp_2col_req_headers);
        this.jp_2col_req_cookies = new TwoColumnTablePanel(new String[]{"Cookie", "Value"}, this.rest_ui);
        jtp.addTab("Cookie", this.jp_2col_req_cookies);
        jtp.addTab("Body", this.jp_req_body.getComponent());
        jtp.addTab("Auth", this.jp_req_auth.getComponent());
        jtp.addTab("SSL", this.jp_req_ssl.getComponent());
        jtp.add("Etc.", this.jp_req_etc.getComponent());
        jtp.addTab("Test", this.jp_req_test.getComponent());
        return jtp;
    }

    private JTabbedPane initJTPResponse() {
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("Headers", this.jp_res_headers.getComponent());
        jtp.addTab("Body", this.jp_res_body.getComponent());
        jtp.addTab("Test Result", this.jp_res_test.getComponent());
        jtp.addTab("Stats", this.jp_res_stats.getComponent());
        return jtp;
    }

    private JPanel initUIRequest() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp.setLayout(new BorderLayout(5, 5));
        this.jp_url_go.addActionListener(ae -> this.jb_requestActionPerformed());
        jp.add(this.jp_url_go.getComponent(), "North");
        jp.add((Component)this.initJTPRequest(), "Center");
        jp.setBorder(BorderFactory.createTitledBorder(null, "HTTP Request", 2, 0));
        return jp;
    }

    private JPanel initUIResponse() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jp.setLayout(new BorderLayout(5, 5));
        jp.add(this.jp_res_status.getComponent(), "North");
        jp.add((Component)this.initJTPResponse(), "Center");
        jp.setBorder(BorderFactory.createTitledBorder(null, "HTTP Response", 2, 0));
        return jp;
    }

    @PostConstruct
    protected void init() {
        FileDropTargetListener l = new FileDropTargetListener();
        l.addDndAction(files -> FileOpenUtil.open(this.view, (File)files.get(0)));
        new DropTarget(this, l);
        String fontName = ServiceLocator.getInstance(IGlobalOptions.class).getProperty("font.options.font");
        String fontSizeStr = ServiceLocator.getInstance(IGlobalOptions.class).getProperty("font.options.fontSize");
        int fontSize = 12;
        if (fontSizeStr != null) {
            try {
                fontSize = Integer.parseInt(fontSizeStr);
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.WARNING, "Font size property is not a number: {0}", fontSizeStr);
            }
        }
        if (fontName != null) {
            Font f = new Font(fontName, 0, fontSize);
            ((FontableEditor)((Object)this.jp_res_body)).setEditorFont(f);
        }
        this.setLayout(new BorderLayout());
        JSplitPane jsp_main = new JSplitPane(0);
        jsp_main.setDividerSize(5);
        jsp_main.add(this.initUIRequest());
        jsp_main.add(this.initUIResponse());
        this.add((Component)jsp_main, "Center");
        this.add(this.jp_status_bar.getComponent(), "South");
    }

    @Override
    public void setUIToLastRequestResponse() {
        if (this.historyManager.lastRequest() != null && this.lastResponse != null) {
            this.setUIFromRequest(this.historyManager.lastRequest());
            this.setUIFromResponse(this.lastResponse);
        }
    }

    @Override
    public Response getResponseFromUI() {
        ResponseBean response = new ResponseBean();
        response.setResponseBody(this.jp_res_body.getBody());
        String statusLine = this.jp_res_status.getStatus();
        response.setStatusLine(statusLine);
        response.setStatusCode(HttpUtil.getStatusCodeFromStatusLine(statusLine));
        MultiValueMap<String, String> headers = this.jp_res_headers.getHeaders();
        headers.keySet().stream().forEach(key -> headers.get((String)key).stream().forEach(value -> response.addHeader((String)key, (String)value)));
        response.setTestResult(this.jp_res_test.getTestResult());
        response.setExecutionTime(this.jp_res_stats.getExecutionTime());
        return response;
    }

    @Override
    public Request getRequestFromUI() throws IllegalStateException {
        this.correctRequestURL();
        RequestBean request = new RequestBean();
        Auth auth = this.jp_req_auth.getAuth();
        request.setAuth(auth);
        String url = this.jp_url_go.getUrlString();
        try {
            request.setUrl(new URL(url));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("URL is malformed", ex);
        }
        HTTPMethod method = this.jp_req_method.getSelectedMethod();
        if (StringUtil.isEmpty(method.name())) {
            throw new IllegalStateException("HTTP method name is empty.");
        }
        request.setMethod(method);
        MultiValueMap<String, String> headers = this.jp_2col_req_headers.getData();
        headers.keySet().stream().forEach(key -> {
            Collection values = headers.get((String)key);
            values.stream().forEach(value -> request.addHeader((String)key, (String)value));
        });
        MultiValueMap<String, String> cookies = this.jp_2col_req_cookies.getData();
        for (String key2 : cookies.keySet()) {
            Collection<String> values = cookies.get(key2);
            for (String value : values) {
                try {
                    HttpCookie cookie = new HttpCookie(key2, value);
                    cookie.setVersion(this.jp_req_etc.getCookieVersion().getIntValue());
                    request.addCookie(cookie);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        if (this.jp_req_method.doesSelectedMethodSupportEntityBody()) {
            request.setBody(this.jp_req_body.getEntity());
        }
        if (this.jp_url_go.isSslUrl()) {
            SSLReq sslReq = this.jp_req_ssl.getSslReq();
            request.setSslReq(sslReq);
        }
        request.setHttpVersion(this.jp_req_etc.getHttpVersion());
        request.setFollowRedirect(this.jp_req_etc.isFollowRedirects());
        request.setIgnoreResponseBody(this.jp_req_etc.isIgnoreResponseBody());
        String testScript = this.jp_req_test.getTestScript();
        testScript = testScript == null || testScript.trim().equals("") ? null : testScript.trim();
        request.setTestScript(testScript);
        return request;
    }

    private void jb_requestActionPerformed() {
        block6: {
            if (this.jp_url_go.isIdle()) {
                try {
                    final Request request = this.getRequestFromUI();
                    List<String> errors = this.validateRequest(request);
                    if (errors.isEmpty()) {
                        this.clearUIResponse();
                        final RequestExecuter executer = ServiceLocator.getInstance(RequestExecuter.class);
                        this.requestThread = new Thread(){

                            @Override
                            public void run() {
                                executer.execute(request, RESTViewImpl.this.view);
                            }

                            @Override
                            public void interrupt() {
                                executer.abortExecution();
                                super.interrupt();
                            }
                        };
                        this.requestThread.start();
                        break block6;
                    }
                    String errStr = Util.getHTMLListFromList(errors);
                    JOptionPane.showMessageDialog(this.rest_ui.getFrame(), errStr, "Validation error", 0);
                }
                catch (IllegalStateException ex) {
                    this.doError(Util.getStackTrace(ex));
                }
            } else if (this.jp_url_go.isRunning()) {
                this.requestThread.interrupt();
                this.jp_url_go.setAsIdle();
            }
        }
    }

    @Override
    public void doStart(Request request) {
        this.historyManager.add(request);
        SwingUtilities.invokeLater(() -> {
            this.jp_status_bar.showProgressBar();
            this.jp_status_bar.setStatus("Processing request...");
            this.jp_url_go.setAsRunning();
        });
    }

    @Override
    public void doResponse(Response response) {
        SwingUtilities.invokeLater(() -> {
            this.setUIFromResponse(response);
            this.lastResponse = response;
            int bodyLength = response.getResponseBody() != null ? response.getResponseBody().length : 0;
            this.setStatusMessage("Response time: " + response.getExecutionTime() + " ms; body-size: " + bodyLength + " byte(s)");
        });
    }

    @Override
    public void doCancelled() {
        SwingUtilities.invokeLater(() -> this.setStatusMessage("Request cancelled!"));
    }

    @Override
    public void doEnd() {
        SwingUtilities.invokeLater(() -> {
            this.jp_status_bar.hideProgressBar();
            this.jp_url_go.setAsIdle();
        });
    }

    @Override
    public void doError(String error) {
        SwingUtilities.invokeLater(() -> {
            this.showError(error);
            this.setStatusMessage("An error occurred during request.");
        });
    }

    @Override
    public void showError(String error) {
        this.messageDialog.showError(error);
    }

    @Override
    public void showError(Throwable ex) {
        this.messageDialog.showError(Util.getStackTrace(ex));
    }

    @Override
    public void showMessage(String title, String message) {
        this.messageDialog.showMessage(title, message);
    }

    @Override
    public void clearUIResponse() {
        this.lastResponse = null;
        this.jp_res_status.clear();
        this.jp_res_body.clear();
        this.jp_res_headers.clear();
        this.jp_res_test.clear();
        this.jp_res_stats.clear();
    }

    @Override
    public void enableBody() {
        this.jp_req_body.enableBody();
    }

    @Override
    public void disableBody() {
        this.jp_req_body.disableBody();
    }

    private void correctRequestURL() {
        String t;
        String str = this.jp_url_go.getUrlString();
        if (StringUtil.isNotEmpty(str) && !(t = str.toLowerCase()).startsWith("http://") && !t.startsWith("https://") && !t.matches("^[a-z]+://.*")) {
            str = "http://" + str;
            this.jp_url_go.setUrlString(str);
        }
    }

    private List<String> validateRequest(Request request) {
        ReqEntity entity;
        List<String> authErrors;
        ArrayList<String> errors = new ArrayList<String>();
        if (request.getUrl() == null) {
            errors.add("URL is invalid.");
        }
        if (!(authErrors = this.jp_req_auth.validateIfFilled()).isEmpty()) {
            errors.addAll(authErrors);
        }
        if (this.jp_req_method.doesSelectedMethodSupportEntityBody() && (entity = this.jp_req_body.getEntity()) instanceof ReqEntitySimple && ((ReqEntitySimple)entity).getContentType() == null) {
            errors.add("Content type not set for body.");
        }
        return errors;
    }

    @Override
    public void clearUIRequest() {
        this.jp_url_go.clear();
        this.jp_req_method.clear();
        this.jp_2col_req_headers.setData(CollectionsUtil.EMPTY_MULTI_VALUE_MAP);
        this.jp_2col_req_cookies.setData(CollectionsUtil.EMPTY_MULTI_VALUE_MAP);
        this.jp_req_body.clear();
        this.jp_req_body.disableBody();
        this.jp_req_auth.clear();
        this.jp_req_ssl.clear();
        this.jp_req_etc.clear();
        this.jp_req_test.clear();
    }

    @Override
    public void setUIFromResponse(Response response) {
        this.clearUIResponse();
        this.jp_res_status.setStatus(response.getStatusLine());
        this.jp_res_headers.setHeaders(response.getHeaders());
        if (response.getResponseBody() != null) {
            this.jp_res_body.setBody(response.getResponseBody(), response.getContentType());
        }
        this.jp_res_test.setTestResult(response.getTestResult());
        this.jp_res_stats.setBodySize(response.getResponseBody().length);
        this.jp_res_stats.setExecutionTime(response.getExecutionTime());
    }

    @Override
    public void setUIFromRequest(Request request) {
        this.clearUIRequest();
        this.jp_url_go.setUrlString(request.getUrl().toString());
        HTTPMethod reqMethod = request.getMethod();
        this.jp_req_method.setSelectedMethod(reqMethod);
        MultiValueMap<String, String> headers = request.getHeaders();
        this.jp_2col_req_headers.setData(headers);
        List<HttpCookie> cookies = request.getCookies();
        MultiValueMapArrayList<String, String> cookiesMap = new MultiValueMapArrayList<String, String>();
        int version = CookieVersion.DEFAULT_VERSION.getIntValue();
        for (HttpCookie cookie : cookies) {
            cookiesMap.put(cookie.getName(), cookie.getValue());
            version = cookie.getVersion();
        }
        this.jp_2col_req_cookies.setData(cookiesMap);
        this.jp_req_etc.setCookieVersion(CookieVersion.getValue(version));
        ReqEntity body = request.getBody();
        if (body != null) {
            if (this.jp_req_method.doesSelectedMethodSupportEntityBody()) {
                this.jp_req_body.enableBody();
            }
            this.jp_req_body.setEntity(body);
        }
        if (request.getAuth() != null) {
            this.jp_req_auth.setAuth(request.getAuth());
        }
        if (request.getSslReq() != null) {
            this.jp_req_ssl.setSslReq(request.getSslReq());
        }
        if (request.getHttpVersion() == HTTPVersion.HTTP_1_1) {
            this.jp_req_etc.setHttpVersion(HTTPVersion.HTTP_1_1);
        } else if (request.getHttpVersion() == HTTPVersion.HTTP_1_0) {
            this.jp_req_etc.setHttpVersion(HTTPVersion.HTTP_1_0);
        }
        this.jp_req_etc.setFollowRedirects(request.isFollowRedirect());
        this.jp_req_etc.setIgnoreResponseBody(request.isIgnoreResponseBody());
        this.jp_req_test.setTestScript(request.getTestScript() == null ? "" : request.getTestScript());
    }

    @Override
    public void setStatusMessage(String msg) {
        this.jp_status_bar.setStatus(msg);
    }

    @Override
    public Request getLastRequest() {
        return this.historyManager.lastRequest();
    }

    @Override
    public Response getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public String getUrl() {
        return this.jp_url_go.getUrlString();
    }

    @Override
    public void setUrl(String url) {
        this.jp_url_go.setUrlString(url);
    }

    @Override
    public void runClonedRequestTest(Request request, Response response) {
        this.jp_req_test.runClonedRequestTest(request, response);
    }

    @Override
    public Font getTextAreaFont() {
        return ((FontableEditor)((Object)this.jp_req_body)).getEditorFont();
    }

    @Override
    public void setTextAreaFont(Font f) {
        ((FontableEditor)((Object)this.jp_req_body)).setEditorFont(f);
        ((FontableEditor)((Object)this.jp_res_body)).setEditorFont(f);
    }

    @Override
    public void setTextAreaScrollSpeed(int scrollSpeed) {
        ((ScrollableComponent)((Object)this.jp_req_body)).setScrollSpeed(scrollSpeed);
        ((ScrollableComponent)((Object)this.jp_res_body)).setScrollSpeed(scrollSpeed);
    }

    @Override
    public Container getContainer() {
        return this;
    }
}

