/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.Axis;
import org.intellij.lang.xpath.psi.XPathAxisSpecifier;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;

public class XPathAxisSpecifierImpl
extends XPathElementImpl
implements XPathAxisSpecifier {
    public XPathAxisSpecifierImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public Axis getAxis() {
        ASTNode[] nodes = this.getNode().getChildren(XPathTokenTypes.AXIS);
        if (nodes.length > 0) {
            Axis axis = Axis.fromName(nodes[0].getText());
            if (axis == null) {
                XPathAxisSpecifierImpl.$$$reportNull$$$0(0);
            }
            return axis;
        }
        if (this.getNode().findChildByType(XPathTokenTypes.AT) != null) {
            Axis axis = Axis.ATTRIBUTE;
            if (axis == null) {
                XPathAxisSpecifierImpl.$$$reportNull$$$0(1);
            }
            return axis;
        }
        Axis axis = Axis.CHILD;
        if (axis == null) {
            XPathAxisSpecifierImpl.$$$reportNull$$$0(2);
        }
        return axis;
    }

    @Override
    public boolean isDefaultAxis() {
        ASTNode node = this.getNode();
        boolean b = node.getChildren(XPathTokenTypes.AXIS).length == 0;
        return b && node.findChildByType(XPathTokenTypes.AT) == null;
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathAxisSpecifier(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathAxisSpecifierImpl", "getAxis"));
    }
}

