/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FwTaskRunner {
    private static final Logger LOG = Logger.getInstance(FwTaskRunner.class);

    public static boolean tryFindTasksAndRun(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FwTaskRunner.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FwTaskRunner.$$$reportNull$$$0(1);
        }
        return FwTaskRunner.tryFindTasksAndRun(project, file, (Condition<TaskOptions>)Conditions.alwaysTrue());
    }

    public static boolean tryFindTasksAndRun(@NotNull Project project, @NotNull VirtualFile file, @NotNull Condition<TaskOptions> taskFilter) {
        if (project == null) {
            FwTaskRunner.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FwTaskRunner.$$$reportNull$$$0(3);
        }
        if (taskFilter == null) {
            FwTaskRunner.$$$reportNull$$$0(4);
        }
        if (!file.isValid()) {
            LOG.debug("Invalid file " + file.getUrl());
            return false;
        }
        if (project.isDefault() || !project.isInitialized() || project.isDisposed()) {
            return false;
        }
        if (TaskRunner.getInstance().inRefreshState(file.getUrl())) {
            return false;
        }
        List options = (List)ReadAction.compute(() -> {
            if (project == null) {
                FwTaskRunner.$$$reportNull$$$0(5);
            }
            if (file == null) {
                FwTaskRunner.$$$reportNull$$$0(6);
            }
            if (taskFilter == null) {
                FwTaskRunner.$$$reportNull$$$0(7);
            }
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            return ContainerUtil.filter(ProjectTasksOptions.getInstance(project).findTasksForFile(file), (Condition)taskFilter);
        });
        if (options.isEmpty()) {
            return false;
        }
        DataContext dataContext = TaskUtils.getContext(project, file);
        Runnable runTasks = () -> TaskRunner.getInstance().runTasksForFile(dataContext, options);
        if (DumbService.isDumb((Project)project)) {
            DumbService.getInstance((Project)project).runWhenSmart(runTasks);
        } else {
            runTasks.run();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFilter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/FwTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryFindTasksAndRun";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$tryFindTasksAndRun$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

