/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkFormDecorator;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkConfigurationFactory<S extends PhpTestFrameworkConfiguration>
implements Comparable<PhpTestFrameworkConfigurationFactory> {
    @NotNull
    protected final PhpTestFrameworkType myTestFrameworkType;
    @Nullable
    protected final PhpTestFrameworkFormDecorator myDecorator;

    public PhpTestFrameworkConfigurationFactory(@NotNull PhpTestFrameworkType type, @Nullable PhpTestFrameworkFormDecorator decorator) {
        if (type == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(0);
        }
        this.myTestFrameworkType = type;
        this.myDecorator = decorator;
    }

    public boolean isSingleInstance() {
        return false;
    }

    @NotNull
    public abstract String getPresentableName();

    @NotNull
    public PhpTestFrameworkType getTestFrameworkType() {
        PhpTestFrameworkType phpTestFrameworkType = this.myTestFrameworkType;
        if (phpTestFrameworkType == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(1);
        }
        return phpTestFrameworkType;
    }

    public boolean accepts(@NotNull PhpTestFrameworkConfiguration config) {
        if (config == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(2);
        }
        return this.getTestFrameworkType() == config.getFrameworkType();
    }

    @Nullable
    public UnnamedConfigurable createForm(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration config) {
        UnnamedConfigurable form;
        if (project == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(3);
        }
        if (config == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(4);
        }
        if (!((form = this.createBaseForm(project, config)) instanceof PhpTestFrameworkBaseConfigurableForm) || this.myDecorator == null) {
            return form;
        }
        return this.myDecorator.decorate(project, (PhpTestFrameworkBaseConfigurableForm)form);
    }

    @Nullable
    public abstract UnnamedConfigurable createBaseForm(@NotNull Project var1, @NotNull PhpTestFrameworkConfiguration var2);

    public abstract S createNewInstance(@NotNull Project var1, @NotNull List<PhpTestFrameworkConfiguration> var2);

    public abstract S createByInterpreter(@Nullable PhpInterpreter var1);

    protected void fillSettingsByDefaultValue(@NotNull PhpTestFrameworkConfiguration local, @NotNull S settings, @NotNull NullableFunction<String, String> pathConverter) {
        String remoteConfigurationFile;
        String remotePath;
        if (local == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(6);
        }
        if (pathConverter == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)(remotePath = (String)pathConverter.fun((Object)local.getExecutablePath())))) {
            settings.setExecutablePath(remotePath);
        }
        if (StringUtil.isNotEmpty((String)(remoteConfigurationFile = (String)pathConverter.fun((Object)local.getConfigurationFilePath())))) {
            settings.setConfigurationFilePath(remoteConfigurationFile);
        }
        settings.setUseConfigurationFile(local.isUseConfigurationFile());
    }

    @Override
    public int compareTo(@NotNull PhpTestFrameworkConfigurationFactory factory) {
        int types;
        if (factory == null) {
            PhpTestFrameworkConfigurationFactory.$$$reportNull$$$0(8);
        }
        if ((types = this.myTestFrameworkType.compareTo(factory.getTestFrameworkType())) != 0) {
            return types;
        }
        boolean single1 = this.isSingleInstance();
        boolean single2 = factory.isSingleInstance();
        if (!single1 && single2) {
            return 1;
        }
        if (single1 && !single2) {
            return -1;
        }
        return StringUtil.compare((String)this.getPresentableName(), (String)factory.getPresentableName(), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkConfigurationFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathConverter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkConfigurationFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createForm";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillSettingsByDefaultValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

