/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.lang;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import org.angularjs.codeInsight.tags.AngularJSTagDescriptor;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;

public class AngularJSErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement error) {
        if (error == null) {
            AngularJSErrorFilter.$$$reportNull$$$0(0);
        }
        Project project = error.getProject();
        Language language = error.getLanguage();
        if ("CSS".equals(language.getID()) && PsiTreeUtil.getParentOfType((PsiElement)error, XmlAttribute.class) != null && AngularIndexUtil.hasAngularJS(project)) {
            PsiFile file = error.getContainingFile();
            PsiErrorElement nextError = error;
            while (nextError != null) {
                if (AngularJSErrorFilter.hasAngularInjectionAt(project, file, nextError.getTextOffset())) {
                    return false;
                }
                nextError = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextError, PsiErrorElement.class);
            }
        }
        if (HTMLLanguage.INSTANCE.is(language) && error.getErrorDescription().endsWith("not closed")) {
            PsiElement parent = error.getParent();
            XmlElementDescriptor descriptor = parent instanceof XmlTag ? ((XmlTag)parent).getDescriptor() : null;
            return !(descriptor instanceof AngularJSTagDescriptor);
        }
        return true;
    }

    private static boolean hasAngularInjectionAt(Project project, PsiFile file, int offset) {
        PsiElement injection = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(file, offset);
        return injection != null && injection.getContainingFile().getLanguage() == AngularJSLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/angularjs/lang/AngularJSErrorFilter", "shouldHighlightErrorElement"));
    }
}

