/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsException
extends Exception {
    public static final VcsException[] EMPTY_ARRAY = new VcsException[0];
    private VirtualFile myVirtualFile;
    private Collection<String> myMessages;
    private boolean isWarning;

    public VcsException(String message) {
        super(message);
        this.isWarning = false;
        this.initMessage(message);
    }

    private void initMessage(@Nullable String message) {
        this.myMessages = Collections.singleton(VcsException.prepareMessage(message));
    }

    @NotNull
    private static String prepareMessage(@Nullable String message) {
        String string = (String)ObjectUtils.notNull((Object)message, (Object)VcsBundle.message("exception.text.unknown.error", new Object[0]));
        if (string == null) {
            VcsException.$$$reportNull$$$0(0);
        }
        return string;
    }

    public VcsException(Throwable throwable, boolean isWarning) {
        this(VcsException.getMessage(throwable), throwable);
        this.isWarning = isWarning;
    }

    public VcsException(Throwable throwable) {
        this(throwable, false);
    }

    public VcsException(String message, Throwable cause) {
        super(message, cause);
        this.isWarning = false;
        this.initMessage(message);
    }

    public VcsException(String message, boolean isWarning) {
        this(message);
        this.isWarning = isWarning;
    }

    public VcsException(@NotNull Collection<String> messages) {
        if (messages == null) {
            VcsException.$$$reportNull$$$0(1);
        }
        this.isWarning = false;
        this.myMessages = ContainerUtil.map(messages, VcsException::prepareMessage);
    }

    public void setVirtualFile(VirtualFile virtualFile2) {
        this.myVirtualFile = virtualFile2;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public String[] getMessages() {
        String[] stringArray = ArrayUtil.toStringArray(this.myMessages);
        if (stringArray == null) {
            VcsException.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    public VcsException setIsWarning(boolean warning) {
        this.isWarning = warning;
        return this;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    @Override
    @NotNull
    public String getMessage() {
        String string = StringUtil.join(this.myMessages, (String)", ");
        if (string == null) {
            VcsException.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static String getMessage(@Nullable Throwable throwable) {
        return throwable != null ? (String)ObjectUtils.chooseNotNull((Object)throwable.getMessage(), (Object)throwable.getLocalizedMessage()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsException";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

