/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.settings;

import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.WPUtil;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPSettingsPanel
extends JPanel {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myWPPathField;
    private JPanel myErrorPanel;
    private FacetErrorPanel myFacetErrorPanel;
    private boolean myEnabled;

    public WPSettingsPanel(@Nullable Project project, boolean internalValidation) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add(this.myMainPanel);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> browseFolderListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(WPBundle.message("wp.settings.select.wordpress.directory", new Object[0]), WPBundle.message("wp.settings.select.wordpress.root.directory", new Object[0]), (ComponentWithBrowseButton)this.myWPPathField, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                String lastSavedPath;
                String directoryName = this.getComponentText();
                if (!StringUtil.isEmptyOrSpaces((String)directoryName) && !StringUtil.isEmptyOrSpaces((String)(lastSavedPath = WPDataService.getLastWPPath()))) {
                    lastSavedPath = FileUtil.toSystemIndependentName((String)lastSavedPath);
                    return LocalFileSystem.getInstance().findFileByPath(lastSavedPath);
                }
                return super.getInitialFile();
            }
        };
        this.myWPPathField.addActionListener((ActionListener)browseFolderListener);
        this.myEnabled = this.isEnabled();
        if (internalValidation) {
            this.initErrorValidation();
        }
    }

    private void initErrorValidation() {
        this.myFacetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)this.myFacetErrorPanel.getComponent(), "Center");
        this.myFacetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                String result = WPSettingsPanel.this.getValidationMessage();
                if (result != null) {
                    ValidationResult validationResult = new ValidationResult(result);
                    if (validationResult == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return validationResult;
                }
                ValidationResult validationResult = ValidationResult.OK;
                if (validationResult == null) {
                    2.$$$reportNull$$$0(1);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/wordpress/settings/WPSettingsPanel$2", "check"));
            }
        }, new JComponent[]{this.myWPPathField.getTextField()});
        this.myFacetErrorPanel.getValidatorsManager().validate();
    }

    @Nullable
    public String getValidationMessage() {
        if (!this.myEnabled) {
            return null;
        }
        String result = WPUtil.validateWPFolder(this.myWPPathField.getText());
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myEnabled = enabled;
        if (this.myFacetErrorPanel != null) {
            this.myFacetErrorPanel.getValidatorsManager().validate();
        }
    }

    public JComponent createMainPanel() {
        return this.myMainPanel;
    }

    public boolean isModified(WPDataService service) {
        return !Comparing.strEqual((String)this.myWPPathField.getText(), (String)service.getWPPath());
    }

    public void apply(WPDataService.State state) {
        state.setWPPathAndUpdateLastUsed(this.myWPPathField.getText());
    }

    public void reset(WPDataService service) {
        this.myWPPathField.setText(service.getWPPath());
    }

    public void setPath(String path) {
        this.myWPPathField.setText(path);
    }

    public void addComponentChangesListener(final Runnable listener) {
        this.myWPPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                listener.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/wordpress/settings/WPSettingsPanel$3", "textChanged"));
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myWPPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setEnabled(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/WordPressBundle").getString("wp.settings.installation.path"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

