/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.visibility;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uml.core.actions.visibility.DeselectedVisibilityIcon;
import com.intellij.uml.core.actions.visibility.SelectedVisibilityIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ChangeVisibilityLevelAction
extends DiagramAction {
    private static final SelectedVisibilityIcon SELECTED_ICON = new SelectedVisibilityIcon();
    private static final DeselectedVisibilityIcon DESELECTED_ICON = new DeselectedVisibilityIcon();
    private final DiagramVisibilityManager myVisibilityManager;
    private final VisibilityLevel myLevel;
    private final DiagramBuilder myBuilder;

    public ChangeVisibilityLevelAction(DiagramVisibilityManager visibilityManager, VisibilityLevel level, DiagramBuilder builder) {
        super(level.getDisplayName(), "", ChangeVisibilityLevelAction.getActionIcon(visibilityManager, level));
        this.myVisibilityManager = visibilityManager;
        this.myLevel = level;
        this.myBuilder = builder;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setIcon(ChangeVisibilityLevelAction.getActionIcon(this.myVisibilityManager, this.myLevel));
    }

    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(1);
        }
        this.myVisibilityManager.setCurrentVisibilityLevel(this.myLevel);
        this.myBuilder.getDataModel().refreshDataModel();
        this.myBuilder.update(true, true);
        this.myBuilder.getGraph().updateViews();
        if (this.myVisibilityManager.isRelayoutNeeded()) {
            this.myBuilder.relayout();
        }
    }

    private static Icon getActionIcon(DiagramVisibilityManager mgr, VisibilityLevel level) {
        return level == mgr.getCurrentVisibilityLevel() ? SELECTED_ICON : DESELECTED_ICON;
    }

    public String getActionName() {
        return "Change Visibility to " + this.myLevel.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/core/actions/visibility/ChangeVisibilityLevelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

