/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hunspell;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.util.Consumer;
import dk.dren.hunspell.Hunspell;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunspellDictionary
implements Dictionary {
    private final Alphabet myAlphabet;
    private static final String DIC = "dic";
    private static final String AFF = "aff";
    @NotNull
    private final String myName;
    private Hunspell.Dictionary myDictionary;

    public HunspellDictionary(@NotNull String path) throws FileNotFoundException, UnsupportedEncodingException {
        if (path == null) {
            HunspellDictionary.$$$reportNull$$$0(0);
        }
        this(path, path);
    }

    public HunspellDictionary(@NotNull String name, @NotNull String path) throws FileNotFoundException, UnsupportedEncodingException {
        if (name == null) {
            HunspellDictionary.$$$reportNull$$$0(1);
        }
        if (path == null) {
            HunspellDictionary.$$$reportNull$$$0(2);
        }
        this.myAlphabet = new Alphabet();
        this.myName = name;
        if (HunspellDictionary.isHunspell(path)) {
            this.myDictionary = Hunspell.getInstance().getDictionary(FileUtilRt.getNameWithoutExtension((String)path), true);
            this.fillAlphabet();
        }
    }

    private void fillAlphabet() {
        new FileLoader(this.myName).load(word -> IntStream.range(0, word.length()).forEach(i -> this.myAlphabet.getIndex(word.charAt(i), true)));
    }

    public static boolean isHunspell(@NotNull String path) {
        if (path == null) {
            HunspellDictionary.$$$reportNull$$$0(3);
        }
        if (!FileUtilRt.extensionEquals((String)path, (String)DIC)) {
            return false;
        }
        File dic = new File(path);
        File aff = new File(FileUtilRt.getNameWithoutExtension((String)path) + "." + AFF);
        return dic.exists() && aff.exists();
    }

    public void getSuggestions(@NotNull String word, @NotNull Consumer<String> consumer) {
        if (word == null) {
            HunspellDictionary.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            HunspellDictionary.$$$reportNull$$$0(5);
        }
        this.myDictionary.suggest(word).forEach(arg_0 -> consumer.consume(arg_0));
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            HunspellDictionary.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Boolean contains(@NotNull String word) {
        boolean contains;
        if (word == null) {
            HunspellDictionary.$$$reportNull$$$0(7);
        }
        boolean bl = contains = !this.myDictionary.misspelled(word) || !this.myDictionary.misspelled(StringUtil.capitalize((String)word));
        if (contains) {
            return true;
        }
        if (IntStream.range(0, word.length()).allMatch(index -> {
            if (word == null) {
                HunspellDictionary.$$$reportNull$$$0(9);
            }
            return this.myAlphabet.getIndex(word.charAt(index), false) == -1;
        })) {
            return null;
        }
        return false;
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public void traverse(@NotNull Consumer<String> action) {
        if (action == null) {
            HunspellDictionary.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Set<String> getWords() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hunspell/HunspellDictionary";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hunspell/HunspellDictionary";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isHunspell";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestions";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$contains$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

