/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import gnu.trove.TIntArrayList;

public class DominatedNodesBuilder {
    private final int myNodesCnt;
    private final TIntArrayList myDominatorsTree;
    private final TIntArrayList myDominatedIdx;
    private final TIntArrayList myDominatedLinks;

    public DominatedNodesBuilder(TIntArrayList dominatorsTree, int nodesCnt) {
        this.myDominatorsTree = dominatorsTree;
        this.myNodesCnt = nodesCnt;
        this.myDominatedIdx = new TIntArrayList(this.myNodesCnt);
        this.myDominatedLinks = new TIntArrayList(this.myNodesCnt);
    }

    public void execute() {
        int i;
        int i2;
        for (i2 = 0; i2 < this.myNodesCnt; ++i2) {
            this.myDominatedIdx.add(0);
            this.myDominatedLinks.add(-1);
        }
        for (i2 = 1; i2 < this.myNodesCnt; ++i2) {
            int dominator = this.myDominatorsTree.get(i2);
            this.myDominatedIdx.set(dominator, this.myDominatedIdx.get(dominator) + 1);
        }
        int offset = 0;
        TIntArrayList runningIndex = new TIntArrayList(this.myNodesCnt);
        for (i = 0; i < this.myNodesCnt; ++i) {
            int cnt = this.myDominatedIdx.get(i);
            runningIndex.add(cnt);
            this.myDominatedIdx.set(i, offset);
            offset += cnt;
        }
        for (i = 1; i < this.myNodesCnt; ++i) {
            int dominator = this.myDominatorsTree.get(i);
            int left = runningIndex.get(dominator);
            int was = this.myDominatedIdx.get(dominator);
            if (was < 0 || left <= 0) continue;
            this.myDominatedLinks.set(was + left - 1, i);
            runningIndex.set(dominator, left - 1);
        }
    }

    public TIntArrayList getDominatedIdx() {
        return this.myDominatedIdx;
    }

    public TIntArrayList getDominatedLinks() {
        return this.myDominatedLinks;
    }
}

