/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ReadV8LogRawAction;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8RawLogProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.FlatTopCalls;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNode;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.V8CpuDiffViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartParameters;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import icons.NodeJSIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CpuDiffCalculator
extends Task.Backgroundable {
    private final V8LogCachingReader myBase;
    @NotNull
    private final File myChangedFile;
    private final boolean mySwitchLogs;
    private DiffNode myTopDownDiff;
    private DiffNode myBottomUpDiff;
    private V8LogCachingReader myOtherReader;
    private V8LogCachingReader myBaseForDiff;
    private V8LogCachingReader myChangedForDiff;
    private List<Pair<String, List<DiffNode>>> myFlatDiff;

    public CpuDiffCalculator(@NotNull Project project, V8LogCachingReader base, @NotNull File changedFile, boolean switchLogs) {
        if (project == null) {
            CpuDiffCalculator.$$$reportNull$$$0(0);
        }
        if (changedFile == null) {
            CpuDiffCalculator.$$$reportNull$$$0(1);
        }
        super(project, "Calculating V8 CPU Profiles Diff", true);
        this.myBase = base;
        this.myChangedFile = changedFile;
        this.mySwitchLogs = switchLogs;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CpuDiffCalculator.$$$reportNull$$$0(2);
        }
        try {
            V8RawLogProcessor processor = new V8RawLogProcessor(this.myProject, this.myChangedFile, (Consumer<? super String>)((Consumer)s -> {
                if (indicator == null) {
                    CpuDiffCalculator.$$$reportNull$$$0(3);
                }
                indicator.setText(s);
                indicator.cancel();
            }));
            processor.run(indicator);
            this.myOtherReader = processor.getReader();
            this.myBaseForDiff = this.mySwitchLogs ? this.myOtherReader.cloneReader() : this.myBase;
            this.myChangedForDiff = this.mySwitchLogs ? this.myBase : this.myOtherReader.cloneReader();
        }
        catch (IOException e) {
            ReadV8LogRawAction.createNotificator(this.myProject).consume((Object)("Error in V8 logs diff processing: " + e.getMessage()));
            indicator.cancel();
            return;
        }
        this.myTopDownDiff = this.treeDiff(this.myBaseForDiff.getTopDown(), this.myChangedForDiff.getTopDown());
        this.myBottomUpDiff = this.treeDiff(this.myBaseForDiff.getBottomUp(), this.myChangedForDiff.getBottomUp());
        this.correctBottomUpPercentOfParent();
        this.myFlatDiff = this.flatDiff(this.myBaseForDiff.getFlat(), this.myChangedForDiff.getFlat());
    }

    private List<Pair<String, List<DiffNode>>> flatDiff(FlatTopCalls baseFlat, FlatTopCalls changedFlat) {
        String[] order;
        List<Pair<String, List<V8ProfileLine>>> baseFlatPresentation = baseFlat.createPresentation();
        List<Pair<String, List<V8ProfileLine>>> changedFlatPresentation = changedFlat.createPresentation();
        HashMap map = new HashMap();
        HashMap baseMap = new HashMap();
        for (Pair<String, List<V8ProfileLine>> pair : baseFlatPresentation) {
            baseMap.put(pair.getFirst(), pair.getSecond());
        }
        for (Pair<String, List<V8ProfileLine>> pair : changedFlatPresentation) {
            map.put(pair.getFirst(), new BeforeAfter(baseMap.get(pair.getFirst()), pair.getSecond()));
        }
        for (Pair<String, List<V8ProfileLine>> pair : baseFlatPresentation) {
            if (map.containsKey(pair.getFirst())) continue;
            map.put(pair.getFirst(), new BeforeAfter(pair.getSecond(), null));
        }
        HashMap middleMap = new HashMap();
        final Iterator iterator = map.entrySet().iterator();
        new ToDiffNodesConvertor((Map)middleMap){
            private ArrayList<DiffNode> myList;
            final /* synthetic */ Map val$middleMap;
            {
                this.val$middleMap = map;
            }

            @Override
            protected void currentNode() {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.myList = new ArrayList();
                this.val$middleMap.put(entry.getKey(), this.myList);
                this.myBaseCurrentChildren = (List)((BeforeAfter)entry.getValue()).getBefore();
                this.myChangedCurrentChildren = (List)((BeforeAfter)entry.getValue()).getAfter();
            }

            @Override
            protected void onNode(DiffNode node, V8ProfileLine baseLine, V8ProfileLine changedForBase) {
                this.myList.add(node);
            }

            @Override
            protected boolean queueIsNotEmpty() {
                return iterator.hasNext();
            }
        }.execute();
        ArrayList<Pair<String, List<DiffNode>>> result = new ArrayList<Pair<String, List<DiffNode>>>();
        for (String key : order = new String[]{"GC", "Shared Libraries", "JavaScript", "C++"}) {
            List list = (List)middleMap.get(key);
            if (list == null) continue;
            result.add((Pair<String, List<DiffNode>>)Pair.create((Object)key, (Object)list));
        }
        return result;
    }

    private void correctBottomUpPercentOfParent() {
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        List<DiffNode> topLevel = this.myBottomUpDiff.getChildren();
        for (DiffNode line : topLevel) {
            queue.add(Pair.create((Object)line, (Object)new BeforeAfter((Object)((int)this.myBaseForDiff.getNumTicks()), (Object)((int)this.myChangedForDiff.getNumTicks()))));
        }
        while (!queue.isEmpty()) {
            DiffNode line;
            Pair current = (Pair)queue.removeFirst();
            line = (DiffNode)current.getFirst();
            int beforeTicks = 0;
            int afterTicks = 0;
            if (line.getBefore() != null) {
                line.getBefore().setNumParentTicks((Integer)((BeforeAfter)current.getSecond()).getBefore());
                beforeTicks = line.getBefore().getTotal();
            }
            if (line.getAfter() != null) {
                line.getAfter().setNumParentTicks((Integer)((BeforeAfter)current.getSecond()).getAfter());
                afterTicks = line.getAfter().getTotal();
            }
            for (DiffNode childLine : line.getChildren()) {
                queue.add(Pair.create((Object)childLine, (Object)new BeforeAfter((Object)beforeTicks, (Object)afterTicks)));
            }
        }
    }

    public void onSuccess() {
        Consumer<String> notificator = ReadV8LogRawAction.createNotificator(this.myProject);
        V8CpuViewCreatorPartner otherPartner = new V8CpuViewCreatorPartner(this.myProject, this.myOtherReader.getResources(), this.myOtherReader, notificator, this.myOtherReader.getV8LogFile().getName(), null, null, new FlameChartParameters());
        V8ProfilingMainComponent.showMe(this.myProject, this.myOtherReader.getV8LogFile().getName(), "V8 CPU Profiling", NodeJSIcons.OpenV8ProfilingLog_ToolWin, 1, otherPartner, null, null, null);
        CompositeCloseable resources = new CompositeCloseable();
        V8CpuDiffViewCreatorPartner partner = new V8CpuDiffViewCreatorPartner(this.myProject, resources, this.myBaseForDiff, this.myChangedForDiff, notificator, this.myTopDownDiff, this.myBottomUpDiff, this.myFlatDiff);
        String name = this.myBaseForDiff.getV8LogFile().getName() + "->" + this.myChangedForDiff.getV8LogFile().getName();
        V8ProfilingMainComponent.showMe(this.myProject, name, "V8 CPU Profiling", NodeJSIcons.OpenV8ProfilingLog_ToolWin, 1, partner, null, null, AllIcons.Actions.Diff);
    }

    private DiffNode treeDiff(V8ProfileLine base, V8ProfileLine changed) {
        DiffNode root = new DiffNode(V8CpuLogCall.dumb("", -1L), new DiffNode.Ticks(0, 0), new DiffNode.Ticks(0, 0));
        final ArrayDeque<Trinity> queue = new ArrayDeque<Trinity>();
        queue.add(new Trinity((Object)root, (Object)base, (Object)changed));
        new ToDiffNodesConvertor(){
            private DiffNode myTarget;

            @Override
            protected void currentNode() {
                Trinity trinity = (Trinity)queue.removeFirst();
                this.myTarget = (DiffNode)trinity.getFirst();
                this.myBaseCurrentChildren = trinity.getSecond() == null ? null : ((V8ProfileLine)trinity.getSecond()).getChildren();
                this.myChangedCurrentChildren = trinity.getThird() == null ? null : ((V8ProfileLine)trinity.getThird()).getChildren();
            }

            @Override
            protected void onNode(DiffNode node, V8ProfileLine baseLine, V8ProfileLine changedForBase) {
                this.myTarget.addChild(node);
                if (baseLine != null && changedForBase != null) {
                    queue.add(new Trinity((Object)node, (Object)baseLine, (Object)changedForBase));
                }
            }

            @Override
            protected boolean queueIsNotEmpty() {
                return !queue.isEmpty();
            }
        }.execute();
        return root;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/CpuDiffCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$run$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class ToDiffNodesConvertor {
        protected List<V8ProfileLine> myBaseCurrentChildren;
        protected List<V8ProfileLine> myChangedCurrentChildren;

        private ToDiffNodesConvertor() {
        }

        public void execute() {
            while (this.queueIsNotEmpty()) {
                this.currentNode();
                if (this.myChangedCurrentChildren == null) {
                    for (V8ProfileLine baseLine : this.myBaseCurrentChildren) {
                        this.onNode(new DiffNode(baseLine.getCall(), new DiffNode.Ticks(baseLine.getTotalTicks(), baseLine.getSelfTicks()), null), baseLine, null);
                    }
                    continue;
                }
                if (this.myBaseCurrentChildren == null) {
                    for (V8ProfileLine changedLine : this.myChangedCurrentChildren) {
                        this.onNode(new DiffNode(changedLine.getCall(), null, new DiffNode.Ticks(changedLine.getTotalTicks(), changedLine.getSelfTicks())), null, changedLine);
                    }
                    continue;
                }
                HashMap map = new HashMap();
                for (V8ProfileLine changedLine : this.myChangedCurrentChildren) {
                    map.put(changedLine.getPresentation(true), changedLine);
                }
                for (V8ProfileLine baseLine : this.myBaseCurrentChildren) {
                    V8ProfileLine changedForBase = (V8ProfileLine)map.remove(baseLine.getPresentation(true));
                    if (changedForBase != null) {
                        DiffNode newTarget = new DiffNode(baseLine.getCall(), new DiffNode.Ticks(baseLine.getTotalTicks(), baseLine.getSelfTicks()), new DiffNode.Ticks(changedForBase.getTotalTicks(), changedForBase.getSelfTicks()));
                        this.onNode(newTarget, baseLine, changedForBase);
                        continue;
                    }
                    this.onNode(new DiffNode(baseLine.getCall(), new DiffNode.Ticks(baseLine.getTotalTicks(), baseLine.getSelfTicks()), null), baseLine, null);
                }
                for (V8ProfileLine changedLine : map.values()) {
                    this.onNode(new DiffNode(changedLine.getCall(), null, new DiffNode.Ticks(changedLine.getTotalTicks(), changedLine.getSelfTicks())), null, changedLine);
                }
            }
        }

        protected abstract void currentNode();

        protected abstract void onNode(DiffNode var1, V8ProfileLine var2, V8ProfileLine var3);

        protected abstract boolean queueIsNotEmpty();
    }
}

