/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.schema;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedPropertyDefiningElement;
import com.jetbrains.php.phing.dom.schema.PhingAttributeInfo;
import com.jetbrains.php.phing.dom.schema.PhingSchema;
import com.jetbrains.php.phing.dom.schema.TagDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingTagInfo {
    private static final Logger LOG = Logger.getInstance(PhingTagInfo.class);
    private final String myId;
    private final List<PhingAttributeInfo> myAttributes;
    private final Map<String, TagDescription> myChildTagsNameToIds;
    private final List<PhingSchema.Containers> myContainers;
    private final Class<? extends PhingPredefinedElement> myClassToRegister;
    private final List<String> myPropertyNames;

    public PhingTagInfo(String id, List<PhingAttributeInfo> attributes, Map<String, TagDescription> childTagsIds, List<PhingSchema.Containers> containers, @Nullable Class<? extends PhingPredefinedElement> classToRegister) {
        this.myId = id;
        attributes = new ArrayList<PhingAttributeInfo>(attributes);
        Collections.sort(attributes, PhingAttributeInfo.NAME_COMPARATOR);
        this.myAttributes = Collections.unmodifiableList(attributes);
        this.myChildTagsNameToIds = PhingSchema.copySortedUnmodifiable(childTagsIds);
        this.myContainers = Collections.unmodifiableList(new ArrayList<PhingSchema.Containers>(containers));
        Class clazz = this.myClassToRegister = classToRegister == null ? PhingPredefinedElement.class : classToRegister;
        if (classToRegister != null && !PhingPredefinedPropertyDefiningElement.class.isAssignableFrom(classToRegister)) {
            this.myPropertyNames = Collections.emptyList();
        } else {
            ArrayList<String> propertyNames = new ArrayList<String>();
            for (PhingAttributeInfo attribute : attributes) {
                if (!attribute.isProperty()) continue;
                propertyNames.add(attribute.getName());
            }
            this.myPropertyNames = Collections.unmodifiableList(propertyNames);
        }
    }

    public String getId() {
        return this.myId;
    }

    public Map<String, TagDescription> getChildTagsNameToIds() {
        return this.myChildTagsNameToIds;
    }

    @NotNull
    public List<String> getPropertyNames() {
        List<String> list = this.myPropertyNames;
        if (list == null) {
            PhingTagInfo.$$$reportNull$$$0(0);
        }
        return list;
    }

    public List<PhingSchema.Containers> getContainers() {
        return this.myContainers;
    }

    private void register(DomExtensionsRegistrar registrar, PhingSchema schema, DomGenericInfo genericInfo) {
        for (PhingAttributeInfo phingAttributeInfo : this.myAttributes) {
            phingAttributeInfo.registerAsChildOf(registrar);
        }
        for (Map.Entry entry : this.myChildTagsNameToIds.entrySet()) {
            String tagName = (String)entry.getKey();
            String tagId = ((TagDescription)entry.getValue()).getId();
            PhingTagInfo tagInfo = schema.getTagInfo(tagId);
            if (tagInfo == null) {
                LOG.error("Failed to find description for id " + tagId);
                return;
            }
            tagInfo.registerExtension(tagName, registrar, genericInfo, ((TagDescription)entry.getValue()).getAnno());
        }
        for (PhingSchema.Containers containers : this.myContainers) {
            Map<String, TagDescription> nameToDescription = containers.getNameToIdMap(schema);
            for (Map.Entry<String, TagDescription> entry : nameToDescription.entrySet()) {
                PhingTagInfo info = schema.getTagInfo(entry.getValue().getId());
                if (info == null) continue;
                info.registerExtension(entry.getKey(), registrar, genericInfo, entry.getValue().getAnno());
            }
        }
    }

    @Nullable
    public static PhingTagInfo registerChildrenExtensions(@NotNull PhingPredefinedElement element, @NotNull DomExtensionsRegistrar registrar, @NotNull PhingSchema schema) {
        PhingTagInfo info;
        if (element == null) {
            PhingTagInfo.$$$reportNull$$$0(1);
        }
        if (registrar == null) {
            PhingTagInfo.$$$reportNull$$$0(2);
        }
        if (schema == null) {
            PhingTagInfo.$$$reportNull$$$0(3);
        }
        if ((info = element.getPhingInfo()) != null) {
            info.register(registrar, schema, element.getGenericInfo());
        }
        return info;
    }

    public void registerExtension(@NotNull String name, @NotNull DomExtensionsRegistrar registrar, DomGenericInfo elementInfo, TagDescription.Anno anno) {
        if (name == null) {
            PhingTagInfo.$$$reportNull$$$0(4);
        }
        if (registrar == null) {
            PhingTagInfo.$$$reportNull$$$0(5);
        }
        if (anno.getDescription(elementInfo, name) == null) {
            DomExtension extension = anno.register(registrar, name, this.myClassToRegister);
            PhingPredefinedElement.registerTagInfo(extension, this);
        }
    }

    public void writeTo(Element tagElement) {
        Element attributesRoot = new Element("attrs");
        tagElement.addContent(attributesRoot);
        for (PhingAttributeInfo attribute : this.myAttributes) {
            Element element = attribute.writeTo();
            attributesRoot.addContent(element);
        }
        if (!this.myChildTagsNameToIds.isEmpty()) {
            Element childrenElement = new Element("children");
            tagElement.addContent(childrenElement);
            for (Map.Entry entry : this.myChildTagsNameToIds.entrySet()) {
                childrenElement.setAttribute((String)entry.getKey(), ((TagDescription)entry.getValue()).getStringPresentation());
            }
        }
        if (!this.myContainers.isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (PhingSchema.Containers containers : this.myContainers) {
                values.add(containers.getAttributeValue());
            }
            tagElement.setAttribute("container", StringUtil.join(values, (String)","));
        }
        if (this.myClassToRegister != null && this.myClassToRegister != PhingPredefinedElement.class) {
            tagElement.setAttribute("class", this.myClassToRegister.getName());
        }
    }

    public static PhingTagInfo read(Element element) {
        List<PhingSchema.Containers> containers;
        Element attrs = element.getChild("attrs");
        ArrayList<PhingAttributeInfo> attributeInfos = new ArrayList<PhingAttributeInfo>();
        for (Element attribute : attrs.getChildren()) {
            attributeInfos.add(PhingAttributeInfo.readFrom(attribute));
        }
        Element children = element.getChild("children");
        HashMap<String, TagDescription> childNameToId = new HashMap<String, TagDescription>();
        if (children != null) {
            for (Attribute attribute : children.getAttributes()) {
                childNameToId.put(attribute.getName(), TagDescription.getFromStringPresentation(attribute.getValue()));
            }
        }
        String id = element.getName();
        String containerValue = element.getAttributeValue("container");
        if (!StringUtil.isEmpty((String)containerValue)) {
            containers = new ArrayList();
            List values = StringUtil.split((String)containerValue, (String)",");
            for (PhingSchema.Containers container : PhingSchema.Containers.values()) {
                if (!values.contains(container.getAttributeValue())) continue;
                containers.add(container);
            }
        } else {
            containers = Collections.emptyList();
        }
        String classToRegisterValue = element.getAttributeValue("class");
        Class<?> classToRegister = null;
        if (!StringUtil.isEmptyOrSpaces((String)classToRegisterValue)) {
            try {
                classToRegister = Class.forName(classToRegisterValue);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Failed to create class " + classToRegisterValue, (Throwable)e);
            }
        }
        return new PhingTagInfo(id, attributeInfos, childNameToId, containers, classToRegister);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/schema/PhingTagInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/schema/PhingTagInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerChildrenExtensions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

