/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class CreateJSFunctionIntentionActionBase
extends BaseCreateFix {
    private final String myName;
    private final String myIntentionNameKey;

    public CreateJSFunctionIntentionActionBase(String name, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String nameKey) {
        this.myName = name;
        this.myIntentionNameKey = nameKey;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)this.myIntentionNameKey, (Object[])new Object[]{this.myName});
        if (string == null) {
            CreateJSFunctionIntentionActionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.create.function.intention.family", (Object[])new Object[0]);
        if (string == null) {
            CreateJSFunctionIntentionActionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
        boolean constructor;
        if (anchorParent == null) {
            CreateJSFunctionIntentionActionBase.$$$reportNull$$$0(2);
        }
        boolean ecma = DialectDetector.isActionScript(anchorParent);
        String referencedName = referenceExpression == null ? this.myName : (ecma ? referenceExpression.getReferencedName() : referenceExpression.getText());
        PsiElement clazz = CreateJSFunctionIntentionActionBase.findClass(anchorParent);
        if (referenceExpression != null && clazz instanceof JSClass) {
            this.addAccessModifier(template, referenceExpression, staticContext, (JSClass)clazz);
        }
        this.writeFunctionAndName(template, referencedName, anchorParent, clazz, referenceExpression);
        template.addTextSegment("(");
        if (referenceExpression != null) {
            this.addParameters(template, referenceExpression, anchorParent);
        }
        template.addTextSegment(")");
        boolean bl = constructor = referenceExpression != null && referenceExpression.getParent() instanceof JSNewExpression;
        if (referenceExpression != null && (ecma || DialectDetector.isTypeScript(anchorParent) && clazz != null && (!(clazz instanceof JSClass) || ((JSClass)clazz).isInterface())) && !constructor) {
            template.addTextSegment(":");
            this.addReturnType(template, referenceExpression, anchorParent);
        }
        if (clazz == null || clazz instanceof JSClass && !((JSClass)clazz).isInterface()) {
            template.addTextSegment(" {");
            if (referenceExpression != null) {
                this.addBody(template, referenceExpression, anchorParent);
            } else {
                template.addEndVariable();
            }
            template.addTextSegment("}");
        } else {
            this.addSemicolonSegment(template, anchorParent);
            template.addEndVariable();
        }
    }

    protected void writeFunctionAndName(Template template, String referencedName, @NotNull PsiElement anchorParent, @Nullable PsiElement clazz, JSReferenceExpression referenceExpression) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionActionBase.$$$reportNull$$$0(3);
        }
        template.addTextSegment("function ");
        template.addTextSegment(referencedName);
    }

    protected abstract void addParameters(Template var1, JSReferenceExpression var2, @NotNull PsiElement var3);

    protected abstract void addReturnType(Template var1, JSReferenceExpression var2, @NotNull PsiElement var3);

    protected abstract void addBody(Template var1, JSReferenceExpression var2, @NotNull PsiElement var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionActionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeFunctionAndName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

