/*
 * Decompiled with CFR 0.152.
 */
package free.jin.plugin;

import free.jin.Connection;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.Preferences;
import free.jin.Resource;
import free.jin.Server;
import free.jin.User;
import free.jin.action.JinAction;
import free.jin.plugin.PluginContext;
import free.jin.plugin.PluginStartException;
import free.jin.plugin.PluginUIContainer;
import free.jin.ui.PreferencesPanel;
import free.util.MemoryFile;
import free.util.models.Model;
import java.util.Map;
import javax.swing.ListModel;

public abstract class Plugin {
    private PluginContext context;
    private Connection conn;
    private Preferences prefs;
    private I18n i18n;

    public boolean setContext(PluginContext pluginContext) {
        if (this.context != null) {
            throw new IllegalStateException("PluginContext already set");
        }
        this.context = pluginContext;
        return true;
    }

    public Connection getConn() {
        if (this.conn == null) {
            this.conn = this.context.getConnection();
        }
        return this.conn;
    }

    public Preferences getPrefs() {
        if (this.prefs == null) {
            Preferences preferences = this.context.getPreferences(this);
            Preferences preferences2 = this.getUser().getPrefs();
            this.prefs = Preferences.createBackedUp(Preferences.createWrapped(preferences2, this.getId() + "."), preferences);
        }
        return this.prefs;
    }

    public Map getResources(String string) {
        return Jin.getInstance().getResources(string, this);
    }

    public Resource getResource(String string, String string2) {
        return Jin.getInstance().getResource(string, string2, this);
    }

    public I18n getI18n() {
        if (this.i18n == null) {
            this.i18n = I18n.get(this.getClass(), Plugin.class);
        }
        return this.i18n;
    }

    public PluginUIContainer createContainer(String string, int n) {
        return Jin.getInstance().getUIProvider().createPluginUIContainer(this, string, n);
    }

    public MemoryFile getFile(String string) {
        return this.getUser().getFile(this.getId() + "/" + string);
    }

    public void setFile(String string, MemoryFile memoryFile) {
        this.getUser().setFile(this.getId() + "/" + string, memoryFile);
    }

    public User getUser() {
        return this.context.getUser();
    }

    public Server getServer() {
        return this.getUser().getServer();
    }

    public Plugin getPlugin(String string) {
        return this.context.getPlugin(string);
    }

    public void setOtherPluginsPaused(boolean bl) {
        Plugin[] pluginArray = this.context.getPlugins();
        for (int i = 0; i < pluginArray.length; ++i) {
            if (pluginArray[i] == this) continue;
            pluginArray[i].setPaused(bl);
        }
    }

    public ListModel getActions() {
        return this.context.getActions();
    }

    public JinAction getAction(String string) {
        return this.context.getAction(string);
    }

    public void exportAction(JinAction jinAction) {
        this.context.addAction(jinAction);
    }

    public abstract String getId();

    public abstract String getName();

    public boolean hasPreferencesUI() {
        return false;
    }

    public PreferencesPanel getPreferencesUI() {
        throw new IllegalStateException("This plugin has no preferences ui");
    }

    public Model[] getHotPrefs() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void start() throws PluginStartException {
    }

    public void saveState() {
    }

    public void stop() {
    }

    public void setPaused(boolean bl) {
    }

    public boolean isPaused() {
        return false;
    }
}

