/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.classfile.constant.ConstantString;
import jd.core.model.classfile.constant.ConstantValue;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Ldc;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotClassEclipseReconstructor {
    public static void Reconstruct(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list) {
        int i = list.size();
        if (i < 3) {
            return;
        }
        i -= 2;
        ConstantPool constants = classFile.getConstantPool();
        block0: while (i-- > 0) {
            String exceptionName;
            String name;
            Instruction instruction = list.get(i);
            if (instruction.opcode != 262) continue;
            IfInstruction ii = (IfInstruction)instruction;
            if (ii.value.opcode != 178) continue;
            int jumpOffset = ii.GetJumpOffset();
            instruction = list.get(i + 1);
            if (instruction.opcode != 318) continue;
            FastTry ft = (FastTry)instruction;
            if (ft.catches.size() != 1 || ft.finallyInstructions != null || ft.instructions.size() != 2) continue;
            FastTry.FastCatch fc = ft.catches.get(0);
            if (fc.instructions.size() != 1 || fc.otherExceptionTypeIndexes != null) continue;
            instruction = list.get(i + 2);
            if (ft.offset >= jumpOffset || jumpOffset > instruction.offset) continue;
            GetStatic gs = (GetStatic)ii.value;
            ConstantFieldref cfr = constants.getConstantFieldref(gs.index);
            if (cfr.class_index != classFile.getThisClassIndex()) continue;
            ConstantNameAndType cnatField = constants.getConstantNameAndType(cfr.name_and_type_index);
            String signature = constants.getConstantUtf8(cnatField.descriptor_index);
            if (!"Ljava/lang/Class;".equals(signature) || !(name = constants.getConstantUtf8(cnatField.name_index)).startsWith("class$")) continue;
            instruction = (Instruction)ft.instructions.get(0);
            if (instruction.opcode != 264) continue;
            DupStore ds = (DupStore)instruction;
            if (ds.objectref.opcode != 184) continue;
            Invokestatic is = (Invokestatic)ds.objectref;
            if (is.args.size() != 1) continue;
            instruction = (Instruction)is.args.get(0);
            if (instruction.opcode != 18) continue;
            ConstantMethodref cmr = constants.getConstantMethodref(is.index);
            name = constants.getConstantClassName(cmr.class_index);
            if (!name.equals("java/lang/Class")) continue;
            ConstantNameAndType cnatMethod = constants.getConstantNameAndType(cmr.name_and_type_index);
            name = constants.getConstantUtf8(cnatMethod.name_index);
            if (!name.equals("forName")) continue;
            Ldc ldc = (Ldc)instruction;
            ConstantValue cv = constants.getConstantValue(ldc.index);
            if (cv.tag != 8) continue;
            instruction = (Instruction)ft.instructions.get(1);
            if (instruction.opcode != 179) continue;
            PutStatic ps = (PutStatic)instruction;
            if (ps.index != gs.index || ps.valueref.opcode != 263 || ps.valueref.offset != ds.offset || !(exceptionName = constants.getConstantClassName(fc.exceptionTypeIndex)).equals("Ljava/lang/ClassNotFoundException;") || fc.instructions.get((int)0).opcode != 191) continue;
            ConstantString cs = (ConstantString)cv;
            String className = constants.getConstantUtf8(cs.string_index);
            String internalName = className.replace('.', '/');
            referenceMap.add(internalName);
            int index = constants.addConstantUtf8(internalName);
            index = constants.addConstantClass(index);
            ldc = new Ldc(18, ii.offset, ii.lineNumber, index);
            ReplaceDupLoadVisitor visitor = new ReplaceDupLoadVisitor(ds, ldc);
            visitor.visit(list.get(i + 2));
            list.remove(i + 1);
            list.remove(i);
            Field[] fields = classFile.getFields();
            int j = fields.length;
            while (j-- > 0) {
                Field field = fields[j];
                if (field.name_index != cnatField.name_index) continue;
                field.access_flags |= 0x1000;
                continue block0;
            }
        }
    }
}

