/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ui;

import org.jetbrains.annotations.NonNls;

import javax.swing.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * @author cdr
 */

public abstract class DisposableComponent {
  @NonNls protected static final String ANCESTOR_PROPERTY = "ancestor";

  protected DisposableComponent() {
    // invoke later because getComponent() may not exist yet at the moment of constructor call
    SwingUtilities.invokeLater(() -> {
      // call destroyProcess when component gets destroyed
      final JComponent component = getComponent();
      if (component == null) return; //or should it be dispose()?

      component.addPropertyChangeListener(ANCESTOR_PROPERTY,new PropertyChangeListener() {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
          final Object oldValue = evt.getOldValue();
          final Object newValue = evt.getNewValue();
          if (oldValue != null && newValue == null) {
            dispose();
          }
        }
      });
    });
  }

  public void dispose() {}
  public abstract JComponent getComponent();

}
