package com.intellij.javaee.supportProvider;

import com.intellij.openapi.extensions.ExtensionPointName;

/**
 * Register implementation of this extension point in plugin.xml to provide if your framework need to perform additional tuning of
 * the project model when JavaEE framework is added to a module (e.g. modify WAR/EAR artifacts, setup the created run configuration, etc).
 *
 * @author nik
 */
public abstract class JavaeeFrameworkSupportContributor {
  public static final ExtensionPointName<JavaeeFrameworkSupportContributor> EP_NAME = ExtensionPointName.create("com.intellij.javaee.frameworkSupportContributor");

  public abstract void setupFrameworkSupport(JavaeeFrameworkSupportContributionModel model);

}
