/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

/**
 * author: lesya
 */
public abstract class JavaeeNodeDescriptor<P> extends JamNodeDescriptor<P> {
  public static final JavaeeNodeDescriptor[] EMPTY_ARRAY = new JavaeeNodeDescriptor[0];

  protected JavaeeNodeDescriptor(Project project, NodeDescriptor parentDescriptor, Object parameters, P element) {
    super(project, parentDescriptor, parameters, element);
  }

  @NotNull
  @Override
  public JavaeeNodeDescriptor[] getChildren() {
    return EMPTY_ARRAY;
  }

}
