/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.model.common.ejb;

import com.intellij.jam.view.DeleteHandler;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.psi.PsiClass;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.PrimaryKey;

@DeleteHandler("com.intellij.openapi.module.EjbDeleteHandler")
public interface Interceptor extends EnvironmentGroup, InterceptorMethodContainer {

  @PrimaryKey
  @NameValue
  GenericValue<PsiClass> getInterceptorClass();

  void processInterceptorBindings(Processor<InterceptorBinding> processor);

}

