// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.xml;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.xml.GenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author peter
 */
public interface CustomBean extends CommonSpringBean {

  @Override
  @NotNull XmlTag getXmlTag();

  @Nullable String getClassName();

  @Nullable GenericValue<PsiMethod> getFactoryMethod();

  @Nullable GenericValue<SpringBeanPointer> getFactoryBean();

  @NotNull CustomBeanWrapper getWrapper();

  @Nullable
  XmlAttribute getIdAttribute();
}
