// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiElementRef;
import com.intellij.spring.constants.SpringAnnotationsConstants;

import java.util.List;

public abstract class JavaConfigConfiguration extends SpringJavaConfiguration {
  public static final JamClassMeta<JavaConfigConfiguration> META = new JamClassMeta<>(JavaConfigConfiguration.class);

  private static final JamChildrenQuery<JavaConfigJavaBean> BEANS_QUERY =
    JamChildrenQuery.annotatedMethods(JavaConfigJavaBean.META, JavaConfigJavaBean.class);

  private static final JamChildrenQuery<SpringJavaExternalBean> EXTERNAL_BEANS_QUERY =
    JamChildrenQuery.annotatedMethods(SpringJavaExternalBean.META, SpringJavaExternalBean.class);

  public JavaConfigConfiguration() {
    super(SpringAnnotationsConstants.JAVA_CONFIG_CONFIGURATION);
  }

  static {
    META.addChildrenQuery(BEANS_QUERY);
    META.addChildrenQuery(EXTERNAL_BEANS_QUERY);
  }

  @Override
  public List<? extends SpringJavaBean> getBeans() {
    return BEANS_QUERY.findChildren(PsiElementRef.real(getPsiElement()));
  }

  public List<? extends SpringJavaExternalBean> getExternalBeans() {
    return EXTERNAL_BEANS_QUERY.findChildren(PsiElementRef.real(getPsiElement()));
  }
}